/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.raft.KafkaRaftManager;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.server.Server;
import kafka.server.Server$;
import kafka.server.metadata.BrokerServerMetrics;
import kafka.server.metadata.BrokerServerMetrics$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Mx4jLoader$;
import kafka.utils.VerifiableProperties$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerMetrics;
import org.apache.kafka.controller.QuorumControllerMetrics;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.LoggingFaultHandler;
import org.apache.kafka.server.fault.ProcessExitingFaultHandler;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\ted\u0001\u0002\u001f>\u0001\tC\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t/\u0002\u0011\t\u0011)A\u00051\"AA\r\u0001B\u0001B\u0003%Q\rC\u0003t\u0001\u0011\u0005A\u000f\u0003\u0006z\u0001A\u0005\t1!Q\u0001\niD\u0011\"!\b\u0001\u0005\u0004%I!a\b\t\u000f\u0005\u0005\u0002\u0001)A\u0005{\"I\u00111\u0005\u0001C\u0002\u0013%\u0011Q\u0005\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u0002!I\u0011\u0011\u0006\u0001C\u0002\u0013%\u00111\u0006\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002\u0012!I\u0011q\u0006\u0001C\u0002\u0013%\u0011\u0011\u0007\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u00024!I\u0011q\b\u0001C\u0002\u0013%\u0011\u0011\t\u0005\t\u0003\u007f\u0002\u0001\u0015!\u0003\u0002D!I\u0011\u0011\u0011\u0001C\u0002\u0013%\u00111\u0011\u0005\t\u00037\u0003\u0001\u0015!\u0003\u0002\u0006\"I\u0011Q\u0014\u0001C\u0002\u0013%\u0011q\u0014\u0005\t\u0003S\u0003\u0001\u0015!\u0003\u0002\"\"I\u00111\u0016\u0001C\u0002\u0013%\u0011Q\u0016\u0005\t\u0003o\u0003\u0001\u0015!\u0003\u00020\"9\u0011\u0011\u0018\u0001\u0005B\u0005m\u0006bBAb\u0001\u0011\u0005\u00131\u0018\u0005\b\u0003\u000b\u0004A\u0011IA^\u000f\u001d\t9-\u0010E\u0001\u0003\u00134a\u0001P\u001f\t\u0002\u0005-\u0007BB:\u001b\t\u0003\ti\rC\u0005\u0002Pj\u0011\r\u0011\"\u0001\u0002R\"A\u0011q\u001b\u000e!\u0002\u0013\t\u0019\u000eC\u0005\u0002Zj\u0011\r\u0011\"\u0001\u0002\\\"A\u0011Q\u001d\u000e!\u0002\u0013\ti\u000eC\u0005\u0002hj\u0011\r\u0011\"\u0001\u0002j\"A\u0011\u0011\u001f\u000e!\u0002\u0013\tYOB\u0005\u0002tj\u0001\n1%\t\u0002v\u001e9!\u0011\r\u000e\t\u0002\n=aaBA}5!\u0005\u00151 \u0005\u0007g\u0012\"\tA!\u0004\t\u0013\tEA%!A\u0005B\u0005E\u0007\"\u0003B\nI\u0005\u0005I\u0011\u0001B\u000b\u0011%\u0011i\u0002JA\u0001\n\u0003\u0011y\u0002C\u0005\u0003*\u0011\n\t\u0011\"\u0011\u0003,!I!1\u0007\u0013\u0002\u0002\u0013\u0005!Q\u0007\u0005\n\u0005\u007f!\u0013\u0011!C!\u0005\u0003B\u0011Ba\u0011%\u0003\u0003%\tE!\u0012\t\u0013\t\u001dC%!A\u0005\n\t%sa\u0002B25!\u0005%q\u000b\u0004\b\u0005#R\u0002\u0012\u0011B*\u0011\u0019\u0019x\u0006\"\u0001\u0003V!I!\u0011C\u0018\u0002\u0002\u0013\u0005\u0013\u0011\u001b\u0005\n\u0005'y\u0013\u0011!C\u0001\u0005+A\u0011B!\b0\u0003\u0003%\tA!\u0017\t\u0013\t%r&!A\u0005B\t-\u0002\"\u0003B\u001a_\u0005\u0005I\u0011\u0001B/\u0011%\u0011ydLA\u0001\n\u0003\u0012\t\u0005C\u0005\u0003D=\n\t\u0011\"\u0011\u0003F!I!qI\u0018\u0002\u0002\u0013%!\u0011\n\u0005\b\u0005KRB\u0011\u0001B4\u0011%\u0011YG\u0007b\u0001\n\u0003\u0011i\u0007\u0003\u0005\u0003xi\u0001\u000b\u0011\u0002B8\u0005=Y\u0015MZ6b%\u00064GoU3sm\u0016\u0014(B\u0001 @\u0003\u0019\u0019XM\u001d<fe*\t\u0001)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001\u0019\u0015*\u0014\t\u0003\t\u001ek\u0011!\u0012\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\u0005)[U\"A\u001f\n\u00051k$AB*feZ,'\u000f\u0005\u0002O#6\tqJ\u0003\u0002Q\u007f\u0005)Q\u000f^5mg&\u0011!k\u0014\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jOB\u0011!*V\u0005\u0003-v\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006!A/[7f!\tI&-D\u0001[\u0015\t\u00016L\u0003\u0002];\u000611m\\7n_:T!\u0001\u00110\u000b\u0005}\u0003\u0017AB1qC\u000eDWMC\u0001b\u0003\ry'oZ\u0005\u0003Gj\u0013A\u0001V5nK\u0006\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\t\u0004\t\u001aD\u0017BA4F\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011\u000e\u001d\b\u0003U:\u0004\"a[#\u000e\u00031T!!\\!\u0002\rq\u0012xn\u001c;?\u0013\tyW)\u0001\u0004Qe\u0016$WMZ\u0005\u0003cJ\u0014aa\u0015;sS:<'BA8F\u0003\u0019a\u0014N\\5u}Q!QO^<y!\tQ\u0005\u0001C\u0003T\t\u0001\u0007A\u000bC\u0003X\t\u0001\u0007\u0001\fC\u0003e\t\u0001\u0007Q-A\u0002yIE\u0002r\u0001R>~\u0003\u0003\t\t\"\u0003\u0002}\u000b\n1A+\u001e9mKN\u0002\"A\u0013@\n\u0005}l$AD'fi\u0006\u0004&o\u001c9feRLWm\u001d\t\u0005\u0003\u0007\ti!\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003%\u0011wn\u001c;tiJ\f\u0007OC\u0002\u0002\fu\u000b\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003\u001f\t)AA\tC_>$8\u000f\u001e:ba6+G/\u00193bi\u0006\u0004R!a\u0005\u0002\u001a!l!!!\u0006\u000b\u0007\u0005]Q)\u0001\u0006d_2dWm\u0019;j_:LA!a\u0007\u0002\u0016\t\u00191+Z9\u0002\u00135,G/\u0019)s_B\u001cX#A?\u0002\u00155,G/\u0019)s_B\u001c\b%A\tc_>$8\u000f\u001e:ba6+G/\u00193bi\u0006,\"!!\u0001\u0002%\t|w\u000e^:ue\u0006\u0004X*\u001a;bI\u0006$\u0018\rI\u0001\f_\u001a4G.\u001b8f\t&\u00148/\u0006\u0002\u0002\u0012\u0005aqN\u001a4mS:,G)\u001b:tA\u00059Q.\u001a;sS\u000e\u001cXCAA\u001a!\u0011\t)$!\u000f\u000e\u0005\u0005]\"bAA\u00187&!\u00111HA\u001c\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u001dG>tGO]8mY\u0016\u0014\u0018+^8sk64v\u000e^3sg\u001a+H/\u001e:f+\t\t\u0019\u0005\u0005\u0004\u0002F\u0005M\u0013qK\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u00055\u0013qJ\u0001\u0005kRLGN\u0003\u0002\u0002R\u0005!!.\u0019<b\u0013\u0011\t)&a\u0012\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0005\u0002Z\u0005m\u0013qLA6\u001b\t\tY%\u0003\u0003\u0002^\u0005-#aA'baB!\u0011\u0011MA4\u001b\t\t\u0019G\u0003\u0003\u0002f\u0005=\u0013\u0001\u00027b]\u001eLA!!\u001b\u0002d\t9\u0011J\u001c;fO\u0016\u0014\b\u0003BA7\u0003srA!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0004\u0003gj\u0016\u0001\u0002:bMRLA!a\u001e\u0002r\u0005Q!+\u00194u\u0007>tg-[4\n\t\u0005m\u0014Q\u0010\u0002\f\u0003\u0012$'/Z:t'B,7M\u0003\u0003\u0002x\u0005E\u0014!H2p]R\u0014x\u000e\u001c7feF+xN];n->$XM]:GkR,(/\u001a\u0011\u0002\u0017I\fg\r^'b]\u0006<WM]\u000b\u0003\u0003\u000b\u0003b!a\"\u0002\f\u0006=UBAAE\u0015\r\t\u0019hP\u0005\u0005\u0003\u001b\u000bII\u0001\tLC\u001a\\\u0017MU1gi6\u000bg.Y4feB!\u0011\u0011SAL\u001b\t\t\u0019JC\u0002]\u0003+S!AP/\n\t\u0005e\u00151\u0013\u0002\u0015\u0003BLW*Z:tC\u001e,\u0017I\u001c3WKJ\u001c\u0018n\u001c8\u0002\u0019I\fg\r^'b]\u0006<WM\u001d\u0011\u0002\r\t\u0014xn[3s+\t\t\t\u000b\u0005\u0003EM\u0006\r\u0006c\u0001&\u0002&&\u0019\u0011qU\u001f\u0003\u0019\t\u0013xn[3s'\u0016\u0014h/\u001a:\u0002\u000f\t\u0014xn[3sA\u0005Q1m\u001c8ue>dG.\u001a:\u0016\u0005\u0005=\u0006\u0003\u0002#g\u0003c\u00032ASAZ\u0013\r\t),\u0010\u0002\u0011\u0007>tGO]8mY\u0016\u00148+\u001a:wKJ\f1bY8oiJ|G\u000e\\3sA\u000591\u000f^1siV\u0004HCAA_!\r!\u0015qX\u0005\u0004\u0003\u0003,%\u0001B+oSR\f\u0001b\u001d5vi\u0012|wO\\\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8\u0002\u001f-\u000bgm[1SC\u001a$8+\u001a:wKJ\u0004\"A\u0013\u000e\u0014\u0005i\u0019ECAAe\u00035iU\r^1eCR\fGk\u001c9jGV\u0011\u00111\u001b\t\u0005\u0003C\n).C\u0002r\u0003G\na\"T3uC\u0012\fG/\u0019+pa&\u001c\u0007%A\tNKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:,\"!!8\u0011\t\u0005}\u0017\u0011]\u0007\u00027&\u0019\u00111].\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0011R*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8!\u0003=iU\r^1eCR\fGk\u001c9jG&#WCAAv!\u0011\ty.!<\n\u0007\u0005=8L\u0001\u0003Vk&$\u0017\u0001E'fi\u0006$\u0017\r^1U_BL7-\u00133!\u0005-\u0001&o\\2fgN\u0014v\u000e\\3\u0014\u0005\t\u001a\u0015f\u0001\u0012%_\tQ!I]8lKJ\u0014v\u000e\\3\u0014\u0011\u0011\u001a\u0015Q B\u0001\u0005\u000f\u00012!a@#\u001b\u0005Q\u0002c\u0001#\u0003\u0004%\u0019!QA#\u0003\u000fA\u0013x\u000eZ;diB\u0019AI!\u0003\n\u0007\t-QI\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0003\u0010A\u0019\u0011q \u0013\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u00119\u0002E\u0002E\u00053I1Aa\u0007F\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011\tCa\n\u0011\u0007\u0011\u0013\u0019#C\u0002\u0003&\u0015\u00131!\u00118z\u0011!I\b&!AA\u0002\t]\u0011a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t5\u0002CBA\n\u0005_\u0011\t#\u0003\u0003\u00032\u0005U!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\u000e\u0003>A\u0019AI!\u000f\n\u0007\tmRIA\u0004C_>dW-\u00198\t\u0011eT\u0013\u0011!a\u0001\u0005C\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005/\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003'\f1B]3bIJ+7o\u001c7wKR\u0011!1\n\t\u0005\u0003C\u0012i%\u0003\u0003\u0003P\u0005\r$AB(cU\u0016\u001cGO\u0001\bD_:$(o\u001c7mKJ\u0014v\u000e\\3\u0014\u0011=\u001a\u0015Q B\u0001\u0005\u000f!\"Aa\u0016\u0011\u0007\u0005}x\u0006\u0006\u0003\u0003\"\tm\u0003\u0002C=4\u0003\u0003\u0005\rAa\u0006\u0015\t\t]\"q\f\u0005\tsV\n\t\u00111\u0001\u0003\"\u0005Q!I]8lKJ\u0014v\u000e\\3\u0002\u001d\r{g\u000e\u001e:pY2,'OU8mK\u0006\t\u0012N\\5uS\u0006d\u0017N_3M_\u001e$\u0015N]:\u0015\u0007i\u0014I\u0007C\u0003Ts\u0001\u0007A+\u0001\u0007d_:4\u0017nZ*dQ\u0016l\u0017-\u0006\u0002\u0003pA!!\u0011\u000fB:\u001b\t\tI!\u0003\u0003\u0003v\u0005%!!E&bM.\f7i\u001c8gS\u001e\u001c6\r[3nC\u0006i1m\u001c8gS\u001e\u001c6\r[3nC\u0002\u0002")
public class KafkaRaftServer
implements Server,
Logging {
    private final KafkaConfig config;
    private final Time time;
    private final /* synthetic */ Tuple3 x$1;
    private final MetaProperties metaProps;
    private final BootstrapMetadata bootstrapMetadata;
    private final Seq<String> offlineDirs;
    private final Metrics metrics;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private final Option<BrokerServer> broker;
    private final Option<ControllerServer> controller;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaConfigSchema configSchema() {
        return KafkaRaftServer$.MODULE$.configSchema();
    }

    public static Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> initializeLogDirs(KafkaConfig kafkaConfig) {
        return KafkaRaftServer$.MODULE$.initializeLogDirs(kafkaConfig);
    }

    public static Uuid MetadataTopicId() {
        return KafkaRaftServer$.MODULE$.MetadataTopicId();
    }

    public static TopicPartition MetadataPartition() {
        return KafkaRaftServer$.MODULE$.MetadataPartition();
    }

    public static String MetadataTopic() {
        return KafkaRaftServer$.MODULE$.MetadataTopic();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private MetaProperties metaProps() {
        return this.metaProps;
    }

    private BootstrapMetadata bootstrapMetadata() {
        return this.bootstrapMetadata;
    }

    private Seq<String> offlineDirs() {
        return this.offlineDirs;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    private Option<BrokerServer> broker() {
        return this.broker;
    }

    private Option<ControllerServer> controller() {
        return this.controller;
    }

    @Override
    public void startup() {
        Mx4jLoader$.MODULE$.maybeLoad();
        this.raftManager().startup();
        this.controller().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.startup();
            return BoxedUnit.UNIT;
        });
        this.broker().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.startup();
            return BoxedUnit.UNIT;
        });
        AppInfoParser.registerAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.config.brokerId()), (Metrics)this.metrics(), (long)this.time.milliseconds());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> KafkaBroker$.MODULE$.STARTED_MESSAGE());
    }

    @Override
    public void shutdown() {
        this.broker().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.raftManager().shutdown();
        this.controller().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString($this.config.brokerId()), (Metrics)this.metrics()), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    @Override
    public void awaitShutdown() {
        this.broker().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.awaitShutdown();
            return BoxedUnit.UNIT;
        });
    }

    public KafkaRaftServer(KafkaConfig config, Time time, Option<String> threadNamePrefix) {
        None$ none$;
        None$ none$2;
        this.config = config;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(26).append("[KafkaRaftServer nodeId=").append(config.nodeId()).append("] ").toString());
        KafkaMetricsReporter$.MODULE$.startReporters(VerifiableProperties$.MODULE$.apply(config.originals()));
        KafkaYammerMetrics.INSTANCE.configure(config.originals());
        Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> tuple3 = KafkaRaftServer$.MODULE$.initializeLogDirs(config);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        MetaProperties metaProps = (MetaProperties)tuple3._1();
        BootstrapMetadata bootstrapMetadata = (BootstrapMetadata)tuple3._2();
        Seq offlineDirs = (Seq)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)metaProps, (Object)bootstrapMetadata, (Object)offlineDirs);
        this.x$1 = tuple32;
        this.metaProps = (MetaProperties)this.x$1._1();
        this.bootstrapMetadata = (BootstrapMetadata)this.x$1._2();
        this.offlineDirs = (Seq)this.x$1._3();
        this.metrics = Server$.MODULE$.initializeMetrics(config, time, this.metaProps().clusterId());
        this.controllerQuorumVotersFuture = CompletableFuture.completedFuture(RaftConfig.parseVoterConnections(config.quorumVoters()));
        this.raftManager = new KafkaRaftManager(this.metaProps(), config, new MetadataRecordSerde(), KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), time, this.metrics(), threadNamePrefix, this.controllerQuorumVotersFuture());
        if (config.processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$)) {
            BrokerServerMetrics brokerMetrics = BrokerServerMetrics$.MODULE$.apply(this.metrics());
            ProcessExitingFaultHandler fatalFaultHandler = new ProcessExitingFaultHandler();
            LoggingFaultHandler metadataLoadingFaultHandler = new LoggingFaultHandler("metadata loading", () -> brokerMetrics.metadataLoadErrorCount().getAndIncrement());
            LoggingFaultHandler metadataApplyingFaultHandler = new LoggingFaultHandler("metadata application", () -> brokerMetrics.metadataApplyErrorCount().getAndIncrement());
            none$2 = new Some((Object)new BrokerServer(config, this.metaProps(), this.raftManager(), time, this.metrics(), brokerMetrics, threadNamePrefix, this.offlineDirs(), this.controllerQuorumVotersFuture(), (FaultHandler)fatalFaultHandler, (FaultHandler)metadataLoadingFaultHandler, (FaultHandler)metadataApplyingFaultHandler));
        } else {
            none$2 = this.broker = None$.MODULE$;
        }
        if (config.processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$)) {
            QuorumControllerMetrics controllerMetrics = new QuorumControllerMetrics(KafkaYammerMetrics.defaultRegistry(), time);
            LoggingFaultHandler metadataFaultHandler = new LoggingFaultHandler("controller metadata", () -> controllerMetrics.incrementMetadataErrorCount());
            ProcessExitingFaultHandler fatalFaultHandler = new ProcessExitingFaultHandler();
            none$ = new Some((Object)new ControllerServer(this.metaProps(), config, this.raftManager(), time, this.metrics(), (ControllerMetrics)controllerMetrics, threadNamePrefix, this.controllerQuorumVotersFuture(), KafkaRaftServer$.MODULE$.configSchema(), this.raftManager().apiVersions(), this.bootstrapMetadata(), (FaultHandler)metadataFaultHandler, (FaultHandler)fatalFaultHandler));
        } else {
            none$ = None$.MODULE$;
        }
        this.controller = none$;
    }

    public static interface ProcessRole {
    }
}

