/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.deployment.dev.ClassScanResult;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.testing.JunitTestRunner;
import io.quarkus.deployment.dev.testing.TestClassResult;
import io.quarkus.deployment.dev.testing.TestClassUsages;
import io.quarkus.deployment.dev.testing.TestResult;
import io.quarkus.deployment.dev.testing.TestRunListener;
import io.quarkus.deployment.dev.testing.TestState;
import io.quarkus.deployment.dev.testing.TestSupport;
import java.util.HashSet;
import java.util.Map;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.launcher.PostDiscoveryFilter;

public class ModuleTestRunner {
    final TestState testState = new TestState();
    private final TestSupport testSupport;
    private final CuratedApplication testApplication;
    private final DevModeContext.ModuleInfo moduleInfo;
    private final TestClassUsages testClassUsages = new TestClassUsages();
    private JunitTestRunner runner;

    public ModuleTestRunner(TestSupport testSupport, CuratedApplication testApplication, DevModeContext.ModuleInfo moduleInfo) {
        this.testSupport = testSupport;
        this.testApplication = testApplication;
        this.moduleInfo = moduleInfo;
    }

    public synchronized void abort() {
        this.notifyAll();
        if (this.runner != null) {
            this.runner.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Runnable prepare(ClassScanResult classScanResult, boolean reRunFailures, long runId, TestRunListener listener) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.testApplication.getAugmentClassLoader());
        try {
            ModuleTestRunner moduleTestRunner = this;
            synchronized (moduleTestRunner) {
                if (this.runner != null) {
                    throw new IllegalStateException("Tests already in progress");
                }
                JunitTestRunner.Builder builder = new JunitTestRunner.Builder().setClassScanResult(classScanResult).setRunId(runId).setTestState(this.testState).setTestClassUsages(this.testClassUsages).setTestApplication(this.testApplication).setIncludeTags(this.testSupport.includeTags).setExcludeTags(this.testSupport.excludeTags).setInclude(this.testSupport.include).setExclude(this.testSupport.exclude).setIncludeEngines(this.testSupport.includeEngines).setExcludeEngines(this.testSupport.excludeEngines).setTestType(this.testSupport.testType).setModuleInfo(this.moduleInfo).addListener(listener).setFailingTestsOnly(classScanResult != null && this.testSupport.brokenOnlyMode);
                if (reRunFailures) {
                    final HashSet<UniqueId> ids = new HashSet<UniqueId>();
                    for (Map.Entry<String, TestClassResult> e : this.testSupport.testRunResults.getCurrentFailing().entrySet()) {
                        for (TestResult test : e.getValue().getFailing()) {
                            ids.add(test.uniqueId);
                        }
                    }
                    builder.addAdditionalFilter(new PostDiscoveryFilter(){

                        public FilterResult apply(TestDescriptor testDescriptor) {
                            return FilterResult.includedIf((boolean)ids.contains(testDescriptor.getUniqueId()));
                        }
                    });
                }
                this.runner = builder.build();
            }
            final Runnable prepared = this.runner.prepare();
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ClassLoader old = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader((ClassLoader)ModuleTestRunner.this.testApplication.getAugmentClassLoader());
                    try {
                        prepared.run();
                    }
                    finally {
                        ModuleTestRunner moduleTestRunner = ModuleTestRunner.this;
                        synchronized (moduleTestRunner) {
                            ModuleTestRunner.this.runner = null;
                        }
                        Thread.currentThread().setContextClassLoader(old);
                    }
                }
            };
            return runnable;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public TestState getTestState() {
        return this.testState;
    }
}

