/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.keycloak.config.Option;
import org.keycloak.config.OptionBuilder;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;

public class PropertyMapper<T> {
    static PropertyMapper IDENTITY = new PropertyMapper(new OptionBuilder(null, String.class).build(), null, null, null, null, false){

        @Override
        public ConfigValue getConfigValue(String name, ConfigSourceInterceptorContext context) {
            return context.proceed(name);
        }
    };
    private final Option<T> option;
    private final String to;
    private final BiFunction<Optional<String>, ConfigSourceInterceptorContext, Optional<String>> mapper;
    private final String mapFrom;
    private final boolean mask;
    private final String paramLabel;
    private final String envVarFormat;
    private String cliFormat;

    PropertyMapper(Option<T> option, String to, BiFunction<Optional<String>, ConfigSourceInterceptorContext, Optional<String>> mapper, String mapFrom, String paramLabel, boolean mask) {
        this.option = option;
        this.to = to == null ? this.getFrom() : to;
        this.mapper = mapper == null ? PropertyMapper::defaultTransformer : mapper;
        this.mapFrom = mapFrom;
        this.paramLabel = paramLabel;
        this.mask = mask;
        this.cliFormat = Configuration.toCliFormat(option.getKey());
        this.envVarFormat = Configuration.toEnvVarFormat(this.getFrom());
    }

    private static Optional<String> defaultTransformer(Optional<String> value, ConfigSourceInterceptorContext context) {
        return value;
    }

    ConfigValue getConfigValue(ConfigSourceInterceptorContext context) {
        return this.getConfigValue(this.to, context);
    }

    ConfigValue getConfigValue(String name, ConfigSourceInterceptorContext context) {
        String from = this.getFrom();
        if (this.to != null && this.to.endsWith(Configuration.OPTION_PART_SEPARATOR)) {
            from = name.replace(this.to.substring(0, this.to.lastIndexOf(46)), from.substring(0, from.lastIndexOf(45)));
        }
        if (Environment.isRebuild().booleanValue() && this.isRunTime() && name.startsWith("kc.")) {
            return ConfigValue.builder().withName(name).build();
        }
        ConfigValue config = this.convertValue(context.proceed(from));
        if (config == null) {
            if (this.mapFrom != null) {
                PropertyMapper parentMapper;
                String parentKey = "kc." + this.mapFrom;
                ConfigValue parentValue = this.convertValue(context.proceed(parentKey));
                if (parentValue == null && (parentMapper = PropertyMappers.getMapper(parentKey)) != null && parentMapper.getDefaultValue().isPresent()) {
                    parentValue = ConfigValue.builder().withValue(parentMapper.getDefaultValue().get().toString()).build();
                }
                return this.transformValue(Optional.ofNullable(parentValue == null ? null : parentValue.getValue()), context);
            }
            ConfigValue defaultValue = this.transformValue(this.option.getDefaultValue().map(Objects::toString), context);
            if (defaultValue != null) {
                return defaultValue;
            }
            ConfigValue current = context.proceed(name);
            if (current != null) {
                return this.transformValue(Optional.ofNullable(current.getValue()), context);
            }
            return current;
        }
        Optional<String> configValue = Optional.ofNullable(config.getValue());
        if (config.getName().equals(name)) {
            return config;
        }
        ConfigValue transformedValue = this.transformValue(configValue, context);
        if (transformedValue == null) {
            return context.proceed(name);
        }
        return transformedValue;
    }

    public Option<T> getOption() {
        return this.option;
    }

    public Class<T> getType() {
        return this.option.getType();
    }

    public String getFrom() {
        return "kc." + this.option.getKey();
    }

    public String getDescription() {
        return this.option.getDescription();
    }

    public List<String> getExpectedValues() {
        return this.option.getExpectedValues();
    }

    public Optional<T> getDefaultValue() {
        return this.option.getDefaultValue();
    }

    public OptionCategory getCategory() {
        return this.option.getCategory();
    }

    public boolean isHidden() {
        return this.option.isHidden();
    }

    public boolean isBuildTime() {
        return this.option.isBuildTime();
    }

    public boolean isRunTime() {
        return !this.option.isBuildTime();
    }

    public String getTo() {
        return this.to;
    }

    public String getParamLabel() {
        return this.paramLabel;
    }

    public String getCliFormat() {
        return this.cliFormat;
    }

    public String getEnvVarFormat() {
        return this.envVarFormat;
    }

    boolean isMask() {
        return this.mask;
    }

    private ConfigValue transformValue(Optional<String> value, ConfigSourceInterceptorContext context) {
        if (value == null) {
            return null;
        }
        if (this.mapper == null) {
            return ConfigValue.builder().withName(this.to).withValue((String)value.orElse(null)).build();
        }
        Optional<String> mappedValue = this.mapper.apply(value, context);
        if (mappedValue == null || mappedValue.isEmpty()) {
            return null;
        }
        return ConfigValue.builder().withName(this.to).withValue(mappedValue.get()).withRawValue((String)value.orElse(null)).build();
    }

    private ConfigValue convertValue(ConfigValue configValue) {
        if (configValue == null) {
            return null;
        }
        return configValue.withValue((String)Optional.ofNullable(configValue.getValue()).map(String::trim).orElse(null));
    }

    public static <T> Builder<T> fromOption(Option<T> opt) {
        return new Builder<T>(opt);
    }

    public static class Builder<T> {
        private final Option<T> option;
        private String to;
        private BiFunction<Optional<String>, ConfigSourceInterceptorContext, Optional<String>> mapper;
        private String mapFrom = null;
        private boolean isMasked = false;
        private String paramLabel;

        public Builder(Option<T> option) {
            this.option = option;
        }

        public Builder<T> to(String to) {
            this.to = to;
            return this;
        }

        public Builder<T> transformer(BiFunction<Optional<String>, ConfigSourceInterceptorContext, Optional<String>> mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder<T> paramLabel(String label) {
            this.paramLabel = label;
            return this;
        }

        public Builder<T> mapFrom(String mapFrom) {
            this.mapFrom = mapFrom;
            return this;
        }

        public Builder<T> isMasked(boolean isMasked) {
            this.isMasked = isMasked;
            return this;
        }

        public PropertyMapper<T> build() {
            if (this.paramLabel == null && Boolean.class.equals((Object)this.option.getType())) {
                this.paramLabel = Boolean.TRUE + "|" + Boolean.FALSE;
            }
            return new PropertyMapper<T>(this.option, this.to, this.mapper, this.mapFrom, this.paramLabel, this.isMasked);
        }
    }
}

