/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.user;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.user.MapUserConsentEntity;
import org.keycloak.models.map.user.MapUserCredentialEntity;
import org.keycloak.models.map.user.MapUserEntity;
import org.keycloak.models.map.user.MapUserFederatedIdentityEntity;

public class MapUserEntityImpl
extends MapUserEntity.AbstractUserEntity
implements MapUserEntity {
    private final DeepCloner cloner;
    private String fId;
    private Map<String, List<String>> fAttributes;
    private Long fCreatedTimestamp;
    private List<MapUserCredentialEntity> fCredentials;
    private String fEmail;
    private String fEmailConstraint;
    private Boolean fEmailVerified;
    private Boolean fEnabled;
    private Set<MapUserFederatedIdentityEntity> fFederatedIdentities;
    private String fFederationLink;
    private String fFirstName;
    private Set<String> fGroupsMembership;
    private String fLastName;
    private Long fNotBefore;
    private String fRealmId;
    private Set<String> fRequiredActions;
    private Set<String> fRolesMembership;
    private String fServiceAccountClientLink;
    private Set<MapUserConsentEntity> fUserConsents;
    private String fUsername;

    private MapUserEntityImpl() {
        this(DeepCloner.DUMB_CLONER);
    }

    public MapUserEntityImpl(DeepCloner cloner) {
        this.cloner = cloner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapUserEntityImpl)) {
            return false;
        }
        MapUserEntityImpl other = (MapUserEntityImpl)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAttributes(), other.getAttributes()) && Objects.equals(this.getCreatedTimestamp(), other.getCreatedTimestamp()) && Objects.equals(this.getCredentials(), other.getCredentials()) && Objects.equals(this.getEmail(), other.getEmail()) && Objects.equals(this.getEmailConstraint(), other.getEmailConstraint()) && Objects.equals(this.getFederatedIdentities(), other.getFederatedIdentities()) && Objects.equals(this.getFederationLink(), other.getFederationLink()) && Objects.equals(this.getFirstName(), other.getFirstName()) && Objects.equals(this.getGroupsMembership(), other.getGroupsMembership()) && Objects.equals(this.getLastName(), other.getLastName()) && Objects.equals(this.getNotBefore(), other.getNotBefore()) && Objects.equals(this.getRealmId(), other.getRealmId()) && Objects.equals(this.getRequiredActions(), other.getRequiredActions()) && Objects.equals(this.getRolesMembership(), other.getRolesMembership()) && Objects.equals(this.getServiceAccountClientLink(), other.getServiceAccountClientLink()) && Objects.equals(this.getUserConsents(), other.getUserConsents()) && Objects.equals(this.getUsername(), other.getUsername()) && Objects.equals(this.isEmailVerified(), other.isEmailVerified()) && Objects.equals(this.isEnabled(), other.isEnabled());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public <V> V deepClone(V obj) {
        return this.cloner.from(obj);
    }

    @Override
    public List<String> getAttribute(String p0) {
        return this.fAttributes == null ? null : this.fAttributes.get(p0);
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return this.fAttributes;
    }

    @Override
    public void setAttributes(Map<String, List<String>> p0) {
        Map<String, List<String>> map = p0 = p0 == null ? null : (Map<String, List<String>>)p0.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() == null ? null : new LinkedList((Collection)entry.getValue()), (o1, o2) -> o1, HashMap::new));
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        this.updated |= !Objects.equals(this.fAttributes, p0);
        this.fAttributes = p0;
    }

    @Override
    public void removeAttribute(String p0) {
        if (this.fAttributes == null) {
            return;
        }
        boolean removed = this.fAttributes.remove(p0) != null;
        this.updated |= removed;
    }

    @Override
    public void setAttribute(String p0, List<String> p1) {
        LinkedList v;
        boolean valueUndefined;
        LinkedList<String> linkedList = p1 = p1 == null ? null : new LinkedList<String>(p1);
        if (p1 != null) {
            p1.removeIf(UndefinedValuesUtils::isUndefined);
        }
        if (valueUndefined = UndefinedValuesUtils.isUndefined(p1)) {
            if (this.fAttributes != null) {
                this.updated |= this.fAttributes.remove(p0) != null;
            }
            return;
        }
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, List<String>>();
        }
        this.updated |= !Objects.equals(v = this.fAttributes.put(p0, p1), p1);
    }

    @Override
    public void setCreatedTimestamp(Long p0) {
        this.updated |= !Objects.equals(this.fCreatedTimestamp, p0);
        this.fCreatedTimestamp = p0;
    }

    @Override
    public Long getCreatedTimestamp() {
        return this.fCreatedTimestamp;
    }

    @Override
    public Boolean removeCredential(MapUserCredentialEntity p0) {
        if (this.fCredentials == null) {
            return false;
        }
        boolean removed = this.fCredentials.remove(p0);
        this.updated |= removed;
        return removed;
    }

    @Override
    public List<MapUserCredentialEntity> getCredentials() {
        return this.fCredentials;
    }

    @Override
    public void addCredential(MapUserCredentialEntity p0) {
        if (UndefinedValuesUtils.isUndefined(p0 = this.deepClone(p0))) {
            return;
        }
        if (this.fCredentials == null) {
            this.fCredentials = new LinkedList<MapUserCredentialEntity>();
        }
        this.fCredentials.add(p0);
        this.updated = true;
    }

    @Override
    public void setCredentials(List<MapUserCredentialEntity> p0) {
        List<MapUserCredentialEntity> list = p0 = p0 == null ? null : (List<MapUserCredentialEntity>)p0.stream().map(entry -> this.deepClone(entry)).collect(Collectors.toCollection(LinkedList::new));
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        this.updated |= !Objects.equals(this.fCredentials, p0);
        this.fCredentials = p0;
    }

    @Override
    public Optional<MapUserCredentialEntity> getCredential(String p0) {
        if (this.fCredentials == null || this.fCredentials.isEmpty()) {
            return Optional.empty();
        }
        return this.fCredentials.stream().filter(o -> Objects.equals(o.getId(), p0)).findFirst();
    }

    @Override
    public Boolean removeCredential(String p0) {
        boolean removed = this.fCredentials != null && this.fCredentials.removeIf(o -> Objects.equals(o.getId(), p0));
        this.updated |= removed;
        return removed;
    }

    @Override
    public String getEmail() {
        return this.fEmail;
    }

    @Override
    public void setEmail(String p0) {
        this.updated |= !Objects.equals(this.fEmail, p0);
        this.fEmail = p0;
    }

    @Override
    public void setEmailConstraint(String p0) {
        this.updated |= !Objects.equals(this.fEmailConstraint, p0);
        this.fEmailConstraint = p0;
    }

    @Override
    public String getEmailConstraint() {
        return this.fEmailConstraint;
    }

    @Override
    public void setEmailVerified(Boolean p0) {
        this.updated |= !Objects.equals(this.fEmailVerified, p0);
        this.fEmailVerified = p0;
    }

    @Override
    public Boolean isEmailVerified() {
        return this.fEmailVerified;
    }

    @Override
    public Boolean isEnabled() {
        return this.fEnabled;
    }

    @Override
    public void setEnabled(Boolean p0) {
        this.updated |= !Objects.equals(this.fEnabled, p0);
        this.fEnabled = p0;
    }

    @Override
    public Set<MapUserFederatedIdentityEntity> getFederatedIdentities() {
        return this.fFederatedIdentities;
    }

    @Override
    public Optional<MapUserFederatedIdentityEntity> getFederatedIdentity(String p0) {
        if (this.fFederatedIdentities == null || this.fFederatedIdentities.isEmpty()) {
            return Optional.empty();
        }
        return this.fFederatedIdentities.stream().filter(o -> Objects.equals(o.getIdentityProvider(), p0)).findFirst();
    }

    @Override
    public void addFederatedIdentity(MapUserFederatedIdentityEntity p0) {
        if (UndefinedValuesUtils.isUndefined(p0 = this.deepClone(p0))) {
            return;
        }
        if (this.fFederatedIdentities == null) {
            this.fFederatedIdentities = new HashSet<MapUserFederatedIdentityEntity>();
        }
        this.updated |= this.fFederatedIdentities.add(p0);
    }

    @Override
    public Boolean removeFederatedIdentity(String p0) {
        boolean removed = this.fFederatedIdentities != null && this.fFederatedIdentities.removeIf(o -> Objects.equals(o.getIdentityProvider(), p0));
        this.updated |= removed;
        return removed;
    }

    @Override
    public void setFederatedIdentities(Set<MapUserFederatedIdentityEntity> p0) {
        Set<MapUserFederatedIdentityEntity> set = p0 = p0 == null ? null : (Set<MapUserFederatedIdentityEntity>)p0.stream().map(entry -> this.deepClone(entry)).collect(Collectors.toCollection(HashSet::new));
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        this.updated |= !Objects.equals(this.fFederatedIdentities, p0);
        this.fFederatedIdentities = p0;
    }

    @Override
    public Boolean removeFederatedIdentity(MapUserFederatedIdentityEntity p0) {
        if (this.fFederatedIdentities == null) {
            return false;
        }
        boolean removed = this.fFederatedIdentities.remove(p0);
        this.updated |= removed;
        return removed;
    }

    @Override
    public String getFederationLink() {
        return this.fFederationLink;
    }

    @Override
    public void setFederationLink(String p0) {
        this.updated |= !Objects.equals(this.fFederationLink, p0);
        this.fFederationLink = p0;
    }

    @Override
    public String getFirstName() {
        return this.fFirstName;
    }

    @Override
    public void setFirstName(String p0) {
        this.updated |= !Objects.equals(this.fFirstName, p0);
        this.fFirstName = p0;
    }

    @Override
    public void addGroupsMembership(String p0) {
        if (UndefinedValuesUtils.isUndefined(p0)) {
            return;
        }
        if (this.fGroupsMembership == null) {
            this.fGroupsMembership = new HashSet<String>();
        }
        this.updated |= this.fGroupsMembership.add(p0);
    }

    @Override
    public Set<String> getGroupsMembership() {
        return this.fGroupsMembership;
    }

    @Override
    public void setGroupsMembership(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        this.updated |= !Objects.equals(this.fGroupsMembership, p0);
        this.fGroupsMembership = p0;
    }

    @Override
    public void removeGroupsMembership(String p0) {
        if (this.fGroupsMembership == null) {
            return;
        }
        boolean removed = this.fGroupsMembership.remove(p0);
        this.updated |= removed;
    }

    @Override
    public void setLastName(String p0) {
        this.updated |= !Objects.equals(this.fLastName, p0);
        this.fLastName = p0;
    }

    @Override
    public String getLastName() {
        return this.fLastName;
    }

    @Override
    public void setNotBefore(Long p0) {
        this.updated |= !Objects.equals(this.fNotBefore, p0);
        this.fNotBefore = p0;
    }

    @Override
    public Long getNotBefore() {
        return this.fNotBefore;
    }

    @Override
    public void setRealmId(String p0) {
        this.updated |= !Objects.equals(this.fRealmId, p0);
        this.fRealmId = p0;
    }

    @Override
    public String getRealmId() {
        return this.fRealmId;
    }

    @Override
    public void removeRequiredAction(String p0) {
        if (this.fRequiredActions == null) {
            return;
        }
        boolean removed = this.fRequiredActions.remove(p0);
        this.updated |= removed;
    }

    @Override
    public Set<String> getRequiredActions() {
        return this.fRequiredActions;
    }

    @Override
    public void setRequiredActions(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        this.updated |= !Objects.equals(this.fRequiredActions, p0);
        this.fRequiredActions = p0;
    }

    @Override
    public void addRequiredAction(String p0) {
        if (UndefinedValuesUtils.isUndefined(p0)) {
            return;
        }
        if (this.fRequiredActions == null) {
            this.fRequiredActions = new HashSet<String>();
        }
        this.updated |= this.fRequiredActions.add(p0);
    }

    @Override
    public void setRolesMembership(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        this.updated |= !Objects.equals(this.fRolesMembership, p0);
        this.fRolesMembership = p0;
    }

    @Override
    public void addRolesMembership(String p0) {
        if (UndefinedValuesUtils.isUndefined(p0)) {
            return;
        }
        if (this.fRolesMembership == null) {
            this.fRolesMembership = new HashSet<String>();
        }
        this.updated |= this.fRolesMembership.add(p0);
    }

    @Override
    public Set<String> getRolesMembership() {
        return this.fRolesMembership;
    }

    @Override
    public void removeRolesMembership(String p0) {
        if (this.fRolesMembership == null) {
            return;
        }
        boolean removed = this.fRolesMembership.remove(p0);
        this.updated |= removed;
    }

    @Override
    public void setServiceAccountClientLink(String p0) {
        this.updated |= !Objects.equals(this.fServiceAccountClientLink, p0);
        this.fServiceAccountClientLink = p0;
    }

    @Override
    public String getServiceAccountClientLink() {
        return this.fServiceAccountClientLink;
    }

    @Override
    public void addUserConsent(MapUserConsentEntity p0) {
        if (UndefinedValuesUtils.isUndefined(p0 = this.deepClone(p0))) {
            return;
        }
        if (this.fUserConsents == null) {
            this.fUserConsents = new HashSet<MapUserConsentEntity>();
        }
        this.updated |= this.fUserConsents.add(p0);
    }

    @Override
    public void setUserConsents(Set<MapUserConsentEntity> p0) {
        Set<MapUserConsentEntity> set = p0 = p0 == null ? null : (Set<MapUserConsentEntity>)p0.stream().map(entry -> this.deepClone(entry)).collect(Collectors.toCollection(HashSet::new));
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        this.updated |= !Objects.equals(this.fUserConsents, p0);
        this.fUserConsents = p0;
    }

    @Override
    public Boolean removeUserConsent(String p0) {
        boolean removed = this.fUserConsents != null && this.fUserConsents.removeIf(o -> Objects.equals(o.getClientId(), p0));
        this.updated |= removed;
        return removed;
    }

    @Override
    public Set<MapUserConsentEntity> getUserConsents() {
        return this.fUserConsents;
    }

    @Override
    public Optional<MapUserConsentEntity> getUserConsent(String p0) {
        if (this.fUserConsents == null || this.fUserConsents.isEmpty()) {
            return Optional.empty();
        }
        return this.fUserConsents.stream().filter(o -> Objects.equals(o.getClientId(), p0)).findFirst();
    }

    @Override
    public Boolean removeUserConsent(MapUserConsentEntity p0) {
        if (this.fUserConsents == null) {
            return false;
        }
        boolean removed = this.fUserConsents.remove(p0);
        this.updated |= removed;
        return removed;
    }

    @Override
    public void setUsername(String p0) {
        this.updated |= !Objects.equals(this.fUsername, p0);
        this.fUsername = p0;
    }

    @Override
    public String getUsername() {
        return this.fUsername;
    }

    public static class Empty
    extends MapUserEntity.AbstractUserEntity
    implements MapUserEntity {
        public static final Empty INSTANCE = new Empty();

        @Override
        public void setId(String id) {
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public List<String> getAttribute(String name) {
            return null;
        }

        @Override
        public Map<String, List<String>> getAttributes() {
            return null;
        }

        @Override
        public void setAttributes(Map<String, List<String>> attributes) {
        }

        @Override
        public void removeAttribute(String name) {
        }

        @Override
        public void setAttribute(String name, List<String> value) {
        }

        @Override
        public void setCreatedTimestamp(Long createdTimestamp) {
        }

        @Override
        public Long getCreatedTimestamp() {
            return null;
        }

        @Override
        public Boolean removeCredential(MapUserCredentialEntity credentialEntity) {
            return null;
        }

        @Override
        public List<MapUserCredentialEntity> getCredentials() {
            return null;
        }

        @Override
        public void addCredential(MapUserCredentialEntity credentialEntity) {
        }

        @Override
        public void setCredentials(List<MapUserCredentialEntity> credentials) {
        }

        @Override
        public Optional<MapUserCredentialEntity> getCredential(String id) {
            return null;
        }

        @Override
        public Boolean removeCredential(String id) {
            return null;
        }

        @Override
        public String getEmail() {
            return null;
        }

        @Override
        public void setEmail(String email) {
        }

        @Override
        public void setEmailConstraint(String emailConstraint) {
        }

        @Override
        public String getEmailConstraint() {
            return null;
        }

        @Override
        public void setEmailVerified(Boolean emailVerified) {
        }

        @Override
        public Boolean isEmailVerified() {
            return null;
        }

        @Override
        public Boolean isEnabled() {
            return null;
        }

        @Override
        public void setEnabled(Boolean enabled) {
        }

        @Override
        public Set<MapUserFederatedIdentityEntity> getFederatedIdentities() {
            return null;
        }

        @Override
        public Optional<MapUserFederatedIdentityEntity> getFederatedIdentity(String identityProviderId) {
            return null;
        }

        @Override
        public void addFederatedIdentity(MapUserFederatedIdentityEntity federatedIdentity) {
        }

        @Override
        public Boolean removeFederatedIdentity(String identityProviderId) {
            return null;
        }

        @Override
        public void setFederatedIdentities(Set<MapUserFederatedIdentityEntity> federatedIdentities) {
        }

        @Override
        public Boolean removeFederatedIdentity(MapUserFederatedIdentityEntity providerId) {
            return null;
        }

        @Override
        public String getFederationLink() {
            return null;
        }

        @Override
        public void setFederationLink(String federationLink) {
        }

        @Override
        public String getFirstName() {
            return null;
        }

        @Override
        public void setFirstName(String firstName) {
        }

        @Override
        public void addGroupsMembership(String groupId) {
        }

        @Override
        public Set<String> getGroupsMembership() {
            return null;
        }

        @Override
        public void setGroupsMembership(Set<String> groupsMembership) {
        }

        @Override
        public void removeGroupsMembership(String groupId) {
        }

        @Override
        public void setLastName(String lastName) {
        }

        @Override
        public String getLastName() {
            return null;
        }

        @Override
        public void setNotBefore(Long notBefore) {
        }

        @Override
        public Long getNotBefore() {
            return null;
        }

        @Override
        public void setRealmId(String realmId) {
        }

        @Override
        public String getRealmId() {
            return null;
        }

        @Override
        public void removeRequiredAction(String requiredAction) {
        }

        @Override
        public Set<String> getRequiredActions() {
            return null;
        }

        @Override
        public void setRequiredActions(Set<String> requiredActions) {
        }

        @Override
        public void addRequiredAction(String requiredAction) {
        }

        @Override
        public void setRolesMembership(Set<String> rolesMembership) {
        }

        @Override
        public void addRolesMembership(String roleId) {
        }

        @Override
        public Set<String> getRolesMembership() {
            return null;
        }

        @Override
        public void removeRolesMembership(String roleId) {
        }

        @Override
        public void setServiceAccountClientLink(String serviceAccountClientLink) {
        }

        @Override
        public String getServiceAccountClientLink() {
            return null;
        }

        @Override
        public void addUserConsent(MapUserConsentEntity userConsentEntity) {
        }

        @Override
        public void setUserConsents(Set<MapUserConsentEntity> userConsentEntity) {
        }

        @Override
        public Boolean removeUserConsent(String clientId) {
            return null;
        }

        @Override
        public Set<MapUserConsentEntity> getUserConsents() {
            return null;
        }

        @Override
        public Optional<MapUserConsentEntity> getUserConsent(String clientId) {
            return null;
        }

        @Override
        public Boolean removeUserConsent(MapUserConsentEntity userConsentEntity) {
            return null;
        }

        @Override
        public void setUsername(String username) {
        }

        @Override
        public String getUsername() {
            return null;
        }

        @Override
        public boolean isUpdated() {
            return false;
        }
    }
}

