/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.hibernate.contributor;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.FunctionContributor;
import org.hibernate.dialect.CockroachDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeReference;
import org.hibernate.type.StandardBasicTypes;
import org.jboss.logging.Logger;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;

public class JpaMapFunctionContributor
implements FunctionContributor {
    private final Logger LOG = Logger.getLogger(JpaMapFunctionContributor.class);

    public void contributeFunctions(FunctionContributions fc) {
        fc.getFunctionRegistry().registerPattern("->>", "?1->>?2", this.getBasicType(fc, StandardBasicTypes.STRING));
        fc.getFunctionRegistry().registerPattern("->", "?1->?2", this.getJsonbBasicType(fc));
        fc.getFunctionRegistry().registerPattern("@>", "?1@>?2::jsonb", this.getBasicType(fc, StandardBasicTypes.BOOLEAN));
        this.contributeDbSpecificFunctions(fc);
    }

    private BasicType getJsonbBasicType(FunctionContributions fc) {
        return fc.getTypeConfiguration().getBasicTypeRegistry().resolve(JsonbType.class, 3001);
    }

    private BasicType getBasicType(FunctionContributions fc, BasicTypeReference<?> btr) {
        return fc.getTypeConfiguration().getBasicTypeRegistry().resolve(btr);
    }

    private void contributeDbSpecificFunctions(FunctionContributions fc) {
        Dialect dialect = fc.getDialect();
        if (dialect instanceof PostgreSQLDialect) {
            fc.getFunctionRegistry().registerPattern("kc_hash", "sha256(?1::bytea)", this.getBasicType(fc, StandardBasicTypes.BINARY));
        } else if (dialect instanceof CockroachDialect) {
            fc.getFunctionRegistry().registerPattern("kc_hash", "sha256(?1)", this.getBasicType(fc, StandardBasicTypes.STRING));
        } else {
            this.LOG.warnf("Dialect %s not recognized.", (Object)dialect);
        }
    }
}

