/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.clientScope.delegate;

import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.UUID;
import org.keycloak.models.map.clientscope.MapClientScopeEntity;
import org.keycloak.models.map.clientscope.MapClientScopeEntityFields;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.storage.jpa.JpaDelegateProvider;
import org.keycloak.models.map.storage.jpa.clientScope.entity.JpaClientScopeEntity;

public class JpaClientScopeDelegateProvider
extends JpaDelegateProvider<JpaClientScopeEntity>
implements DelegateProvider<MapClientScopeEntity> {
    private final EntityManager em;

    public JpaClientScopeDelegateProvider(JpaClientScopeEntity delegate, EntityManager em) {
        super(delegate);
        this.em = em;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MapClientScopeEntity getDelegate(boolean isRead, Enum<? extends EntityField<MapClientScopeEntity>> field, Object ... parameters) {
        if (((JpaClientScopeEntity)this.getDelegate()).isMetadataInitialized()) {
            return (MapClientScopeEntity)this.getDelegate();
        }
        if (isRead) {
            if (!(field instanceof MapClientScopeEntityFields)) throw new IllegalStateException("Not a valid client scope field: " + field);
            switch ((MapClientScopeEntityFields)field) {
                case ID: 
                case REALM_ID: 
                case NAME: {
                    return (MapClientScopeEntity)this.getDelegate();
                }
                case ATTRIBUTES: {
                    CriteriaBuilder cb = this.em.getCriteriaBuilder();
                    CriteriaQuery query = cb.createQuery(JpaClientScopeEntity.class);
                    Root root = query.from(JpaClientScopeEntity.class);
                    root.fetch("attributes", JoinType.LEFT);
                    query.select((Selection)root).where((Expression)cb.equal((Expression)root.get("id"), (Object)UUID.fromString(((JpaClientScopeEntity)this.getDelegate()).getId())));
                    this.setDelegate((JpaClientScopeEntity)this.em.createQuery(query).getSingleResult());
                    return (MapClientScopeEntity)this.getDelegate();
                }
                default: {
                    this.setDelegate((JpaClientScopeEntity)this.em.find(JpaClientScopeEntity.class, (Object)UUID.fromString(((JpaClientScopeEntity)this.getDelegate()).getId())));
                    return (MapClientScopeEntity)this.getDelegate();
                }
            }
        } else {
            this.setDelegate((JpaClientScopeEntity)this.em.find(JpaClientScopeEntity.class, (Object)UUID.fromString(((JpaClientScopeEntity)this.getDelegate()).getId())));
        }
        return (MapClientScopeEntity)this.getDelegate();
    }
}

