/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.transport.ice;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.Component;
import org.ice4j.ice.HostCandidate;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.MappingCandidateHarvester;
import org.ice4j.ice.harvest.MappingCandidateHarvesters;
import org.ice4j.ice.harvest.SinglePortUdpHarvester;
import org.ice4j.ice.harvest.TcpHarvester;
import org.ice4j.socket.MultiplexingDatagramSocket;
import org.ice4j.socket.SocketClosedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.ice.Harvesters;
import org.jitsi.videobridge.ice.IceConfig;
import org.jitsi.videobridge.ice.TransportUtils;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;
import org.jitsi.videobridge.transport.ice.IceProcessingStateTransition;
import org.jitsi.videobridge.transport.ice.IceStatistics;
import org.jitsi.videobridge.transport.ice.IceTransportKt;
import org.jitsi.xmpp.extensions.jingle.CandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceRtcpmuxPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u0000 C2\u00020\u0001:\u0004CDEFB1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020\u0005H\u0002J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u00020\u0005J\u0010\u00102\u001a\u00020,2\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020,2\u0006\u00103\u001a\u000204H\u0002J\u0006\u00106\u001a\u00020\u0005J\u001e\u00107\u001a\u00020,2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020&2\u0006\u0010;\u001a\u00020&J\u000e\u0010<\u001a\u00020,2\u0006\u0010=\u001a\u00020.J\u0006\u0010>\u001a\u00020,J\u0006\u0010?\u001a\u00020,J\u000e\u0010@\u001a\u00020,2\u0006\u0010A\u001a\u00020BR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\u0016R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u0012*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u0004\u0018\u00010 8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/jitsi/videobridge/transport/ice/IceTransport;", "", "id", "", "controlling", "", "useUniquePort", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "clock", "Ljava/time/Clock;", "(Ljava/lang/String;ZZLorg/jitsi/utils/logging2/Logger;Ljava/time/Clock;)V", "eventHandler", "Lorg/jitsi/videobridge/transport/ice/IceTransport$EventHandler;", "iceAgent", "Lorg/ice4j/ice/Agent;", "iceComponent", "Lorg/ice4j/ice/Component;", "kotlin.jvm.PlatformType", "iceConnected", "Ljava/util/concurrent/atomic/AtomicBoolean;", "iceFailed", "iceFailed$1", "icePassword", "getIcePassword", "()Ljava/lang/String;", "iceStateChangeListener", "Ljava/beans/PropertyChangeListener;", "iceStream", "Lorg/ice4j/ice/IceMediaStream;", "iceStreamPairChangedListener", "incomingDataHandler", "Lorg/jitsi/videobridge/transport/ice/IceTransport$IncomingDataHandler;", "logger", "packetStats", "Lorg/jitsi/videobridge/transport/ice/IceTransport$PacketStats;", "running", "addRemoteCandidates", "", "remoteCandidates", "", "Lorg/jitsi/xmpp/extensions/jingle/CandidatePacketExtension;", "iceAgentIsRunning", "describe", "", "pe", "Lorg/jitsi/xmpp/extensions/jingle/IceUdpTransportPacketExtension;", "getDebugState", "Lorg/jitsi/utils/OrderedJsonObject;", "hasFailed", "iceStateChanged", "ev", "Ljava/beans/PropertyChangeEvent;", "iceStreamPairChanged", "isConnected", "send", "data", "", "off", "length", "startConnectivityEstablishment", "transportPacketExtension", "startReadingData", "stop", "updateStatsOnInitialRtt", "rttMs", "", "Companion", "EventHandler", "IncomingDataHandler", "PacketStats", "jitsi-videobridge"})
public final class IceTransport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @JvmField
    @Nullable
    public IncomingDataHandler incomingDataHandler;
    @JvmField
    @Nullable
    public EventHandler eventHandler;
    @NotNull
    private final AtomicBoolean iceConnected;
    @NotNull
    private final AtomicBoolean iceFailed$1;
    @NotNull
    private final AtomicBoolean running;
    @NotNull
    private final PropertyChangeListener iceStateChangeListener;
    @NotNull
    private final PropertyChangeListener iceStreamPairChangedListener;
    @NotNull
    private final Agent iceAgent;
    private final IceMediaStream iceStream;
    private final Component iceComponent;
    @NotNull
    private final PacketStats packetStats;
    @NotNull
    private static final CounterMetric iceFailed = MetricsContainer.registerCounter$default(VideobridgeMetricsContainer.Companion.getInstance(), "ice_failed", "Number of times an ICE Agent failed to establish connectivity.", 0L, 4, null);
    @NotNull
    private static final CounterMetric iceSucceeded = MetricsContainer.registerCounter$default(VideobridgeMetricsContainer.Companion.getInstance(), "ice_succeeded", "Number of times an ICE Agent succeeded.", 0L, 4, null);
    @NotNull
    private static final CounterMetric iceSucceededTcp = MetricsContainer.registerCounter$default(VideobridgeMetricsContainer.Companion.getInstance(), "ice_succeeded_tcp", "Number of times an ICE Agent succeeded and the selected candidate was a TCP candidate.", 0L, 4, null);
    @NotNull
    private static final CounterMetric iceSucceededRelayed = MetricsContainer.registerCounter$default(VideobridgeMetricsContainer.Companion.getInstance(), "ice_succeeded_relayed", "Number of times an ICE Agent succeeded and the selected pair included a relayed candidate.", 0L, 4, null);

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public IceTransport(@NotNull String id, boolean controlling, boolean useUniquePort, @NotNull Logger parentLogger, @NotNull Clock clock) {
        void $this$iceStream_u24lambda_u2d4;
        Object it;
        Agent $this$iceAgent_u24lambda_u2d2;
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.iceConnected = new AtomicBoolean(false);
        this.iceFailed$1 = new AtomicBoolean(false);
        this.running = new AtomicBoolean(true);
        this.iceStateChangeListener = arg_0 -> IceTransport.iceStateChangeListener$lambda-0(this, arg_0);
        this.iceStreamPairChangedListener = arg_0 -> IceTransport.iceStreamPairChangedListener$lambda-1(this, arg_0);
        Object object = new Agent(IceConfig.config.getUfragPrefix(), this.logger);
        Agent agent = object;
        IceTransport iceTransport = this;
        boolean bl = false;
        if (useUniquePort) {
            $this$iceAgent_u24lambda_u2d2.setUseDynamicPorts(true);
        } else {
            Companion.appendHarvesters($this$iceAgent_u24lambda_u2d2);
        }
        $this$iceAgent_u24lambda_u2d2.setControlling(controlling);
        $this$iceAgent_u24lambda_u2d2.setPerformConsentFreshness(true);
        $this$iceAgent_u24lambda_u2d2.setNominationStrategy(IceConfig.config.getNominationStrategy());
        $this$iceAgent_u24lambda_u2d2.addStateChangeListener(this.iceStateChangeListener);
        $this$iceAgent_u24lambda_u2d2 = object;
        boolean bl2 = false;
        this.logger.addContext("local_ufrag", ((Agent)it).getLocalUfrag());
        iceTransport.iceAgent = object;
        it = object = this.iceAgent.createMediaStream("stream-" + id);
        iceTransport = this;
        boolean bl3 = false;
        $this$iceStream_u24lambda_u2d4.addPairChangeListener(this.iceStreamPairChangedListener);
        iceTransport.iceStream = object;
        this.iceComponent = this.iceAgent.createComponent(this.iceStream, IceConfig.config.getKeepAliveStrategy(), IceConfig.config.getUseComponentSocket());
        this.packetStats = new PacketStats();
    }

    public /* synthetic */ IceTransport(String string, boolean bl, boolean bl2, Logger logger, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(string, bl, bl2, logger, clock);
    }

    public final boolean hasFailed() {
        return this.iceFailed$1.get();
    }

    public final boolean isConnected() {
        return this.iceConnected.get();
    }

    @NotNull
    public final String getIcePassword() {
        String string = this.iceAgent.getLocalPassword();
        Intrinsics.checkNotNullExpressionValue(string, "iceAgent.localPassword");
        return string;
    }

    public final void startConnectivityEstablishment(@NotNull IceUdpTransportPacketExtension transportPacketExtension) {
        Logger logger;
        Intrinsics.checkNotNullParameter(transportPacketExtension, "transportPacketExtension");
        if (!this.running.get()) {
            this.logger.warn("Not starting connectivity establishment, transport is not running");
            return;
        }
        if (this.iceAgent.getState().isEstablished()) {
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger2 = $this$cdebug$iv;
                boolean bl = false;
                logger2.debug("Connection already established");
            }
            return;
        }
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("Starting ICE connectivity establishment");
        }
        this.iceStream.setRemoteUfrag(transportPacketExtension.getUfrag());
        this.iceStream.setRemotePassword(transportPacketExtension.getPassword());
        boolean iceAgentStateIsRunning = IceProcessingState.RUNNING == this.iceAgent.getState();
        List<CandidatePacketExtension> remoteCandidates = transportPacketExtension.getChildExtensionsOfType(CandidatePacketExtension.class);
        if (iceAgentStateIsRunning && remoteCandidates.isEmpty()) {
            Logger $this$cdebug$iv2 = this.logger;
            boolean $i$f$cdebug2 = false;
            if ($this$cdebug$iv2.isDebugEnabled()) {
                logger = $this$cdebug$iv2;
                boolean bl = false;
                logger.debug("Ignoring transport extensions with no candidates, the Agent is already running.");
            }
            return;
        }
        Intrinsics.checkNotNullExpressionValue(remoteCandidates, "remoteCandidates");
        int remoteCandidateCount = this.addRemoteCandidates(remoteCandidates, iceAgentStateIsRunning);
        if (iceAgentStateIsRunning) {
            if (remoteCandidateCount != 0) {
                this.iceComponent.updateRemoteCandidates();
            }
        } else if (remoteCandidateCount != 0) {
            if (this.iceComponent.getRemoteCandidateCount() > 0) {
                this.logger.info("Starting the agent with remote candidates.");
                this.iceAgent.startConnectivityEstablishment();
            }
        } else {
            IceMediaStream iceMediaStream = this.iceStream;
            Intrinsics.checkNotNullExpressionValue(iceMediaStream, "iceStream");
            if (IceTransportKt.access$remoteUfragAndPasswordKnown(iceMediaStream)) {
                this.logger.info("Starting the Agent without remote candidates.");
                this.iceAgent.startConnectivityEstablishment();
            } else {
                Logger $this$cdebug$iv3 = this.logger;
                boolean $i$f$cdebug3 = false;
                if ($this$cdebug$iv3.isDebugEnabled()) {
                    logger = $this$cdebug$iv3;
                    boolean bl = false;
                    logger.debug("Not starting ICE, no ufrag and pwd yet. " + transportPacketExtension.toXML());
                }
            }
        }
    }

    public final void startReadingData() {
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("Starting to read incoming data");
        }
        MultiplexingDatagramSocket socket = this.iceComponent.getSocket();
        byte[] receiveBuf = new byte[1500];
        DatagramPacket packet = new DatagramPacket(receiveBuf, 0, receiveBuf.length);
        Instant receivedTime = null;
        while (this.running.get()) {
            Unit unit;
            try {
                socket.receive(packet);
                Intrinsics.checkNotNullExpressionValue(this.clock.instant(), "clock.instant()");
            }
            catch (SocketClosedException e) {
                this.logger.info("Socket closed, stopping reader");
                break;
            }
            catch (IOException e) {
                this.logger.warn("Stopping reader", e);
                break;
            }
            this.packetStats.getNumPacketsReceived().increment();
            IncomingDataHandler incomingDataHandler = this.incomingDataHandler;
            if (incomingDataHandler != null) {
                incomingDataHandler.dataReceived(receiveBuf, packet.getOffset(), packet.getLength(), receivedTime);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) continue;
            IceTransport $this$startReadingData_u24lambda_u2d11 = this;
            boolean bl = false;
            Logger $this$cdebug$iv2 = $this$startReadingData_u24lambda_u2d11.logger;
            boolean $i$f$cdebug2 = false;
            if ($this$cdebug$iv2.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv2;
                boolean bl2 = false;
                logger.debug("Data handler is null, dropping data");
            }
            $this$startReadingData_u24lambda_u2d11.packetStats.getNumIncomingPacketsDroppedNoHandler().increment();
        }
        this.logger.info("No longer running, stopped reading packets");
    }

    public final void send(@NotNull byte[] data2, int off, int length) {
        Intrinsics.checkNotNullParameter(data2, "data");
        if (this.running.get()) {
            try {
                this.iceComponent.getSocket().send(new DatagramPacket(data2, off, length));
                this.packetStats.getNumPacketsSent().increment();
            }
            catch (IOException e) {
                this.logger.error("Error sending packet", e);
                throw new RuntimeException();
            }
        } else {
            this.packetStats.getNumOutgoingPacketsDroppedStopped().increment();
        }
    }

    public final void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.logger.info("Stopping");
            this.iceAgent.removeStateChangeListener(this.iceStateChangeListener);
            this.iceStream.removePairStateChangeListener(this.iceStreamPairChangedListener);
            this.iceAgent.free();
        }
    }

    @NotNull
    public final OrderedJsonObject getDebugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$getDebugState_u24lambda_u2d12 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        $this$getDebugState_u24lambda_u2d12.put("useComponentSocket", (Object)IceConfig.config.getUseComponentSocket());
        String string = IceConfig.config.getKeepAliveStrategy().toString();
        Intrinsics.checkNotNullExpressionValue(string, "config.keepAliveStrategy.toString()");
        $this$getDebugState_u24lambda_u2d12.put("keepAliveStrategy", string);
        String string2 = IceConfig.config.getNominationStrategy().toString();
        Intrinsics.checkNotNullExpressionValue(string2, "config.nominationStrategy.toString()");
        $this$getDebugState_u24lambda_u2d12.put("nominationStrategy", string2);
        $this$getDebugState_u24lambda_u2d12.put("advertisePrivateCandidates", (Object)IceConfig.config.getAdvertisePrivateCandidates());
        $this$getDebugState_u24lambda_u2d12.put("closed", (Object)(!this.running.get() ? 1 : 0));
        $this$getDebugState_u24lambda_u2d12.put("iceConnected", (Object)this.iceConnected.get());
        $this$getDebugState_u24lambda_u2d12.put("iceFailed", (Object)this.iceFailed$1.get());
        $this$getDebugState_u24lambda_u2d12.putAll(this.packetStats.toJson());
        return orderedJsonObject;
    }

    public final void describe(@NotNull IceUdpTransportPacketExtension pe) {
        List<LocalCandidate> list;
        Intrinsics.checkNotNullParameter(pe, "pe");
        if (!this.running.get()) {
            this.logger.warn("Not describing, transport is not running");
        }
        IceUdpTransportPacketExtension $this$describe_u24lambda_u2d15 = pe;
        boolean bl = false;
        $this$describe_u24lambda_u2d15.setPassword(this.iceAgent.getLocalPassword());
        $this$describe_u24lambda_u2d15.setUfrag(this.iceAgent.getLocalUfrag());
        List<LocalCandidate> list2 = list = this.iceComponent.getLocalCandidates();
        if (list2 != null) {
            Intrinsics.checkNotNullExpressionValue(list2, "localCandidates");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CandidatePacketExtension it;
                LocalCandidate cand = (LocalCandidate)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue(cand, "cand");
                if (IceTransportKt.access$toCandidatePacketExtension(cand) == null) continue;
                boolean bl3 = false;
                pe.addChildExtension(it);
            }
        }
        $this$describe_u24lambda_u2d15.addChildExtension(new IceRtcpmuxPacketExtension());
    }

    private final int addRemoteCandidates(List<? extends CandidatePacketExtension> remoteCandidates, boolean iceAgentIsRunning) {
        int remoteCandidateCount = 0;
        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)remoteCandidates);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RemoteCandidate remoteCandidate;
            CandidatePacketExtension candidate = (CandidatePacketExtension)element$iv;
            boolean bl = false;
            if (candidate.getGeneration() != this.iceAgent.getGeneration()) continue;
            if (IceTransportKt.access$ipNeedsResolution(candidate) && !IceConfig.config.getResolveRemoteCandidates()) {
                Logger $this$cdebug$iv = this.logger;
                boolean $i$f$cdebug = false;
                if (!$this$cdebug$iv.isDebugEnabled()) continue;
                Logger logger = $this$cdebug$iv;
                boolean bl2 = false;
                logger.debug("Ignoring remote candidate with non-literal address: " + candidate.getIP());
                continue;
            }
            Component component = this.iceStream.getComponent(candidate.getComponent());
            if (!TransportUtils.canReach(component, remoteCandidate = new RemoteCandidate(new TransportAddress(candidate.getIP(), candidate.getPort(), Transport.parse(candidate.getProtocol())), component, CandidateType.parse(candidate.getType().toString()), candidate.getFoundation(), candidate.getPriority(), null))) continue;
            if (iceAgentIsRunning) {
                component.addUpdateRemoteCandidates(remoteCandidate);
            } else {
                component.addRemoteCandidate(remoteCandidate);
            }
            ++remoteCandidateCount;
        }
        return remoteCandidateCount;
    }

    private final void iceStateChanged(PropertyChangeEvent ev) {
        Object object = ev.getOldValue();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.ice4j.ice.IceProcessingState");
        }
        IceProcessingState oldState = (IceProcessingState)((Object)object);
        Object object2 = ev.getNewValue();
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.ice4j.ice.IceProcessingState");
        }
        IceProcessingState newState = (IceProcessingState)((Object)object2);
        IceProcessingStateTransition transition = new IceProcessingStateTransition(oldState, newState);
        this.logger.info("ICE state changed old=" + oldState + " new=" + newState);
        if (transition.completed()) {
            if (this.iceConnected.compareAndSet(false, true)) {
                EventHandler eventHandler = this.eventHandler;
                if (eventHandler != null) {
                    eventHandler.connected();
                }
                Transport transport = this.iceComponent.getSelectedPair().getRemoteCandidate().getTransport();
                Intrinsics.checkNotNullExpressionValue((Object)transport, "iceComponent.selectedPai\u2026remoteCandidate.transport");
                if (IceTransportKt.access$isTcpType(transport)) {
                    iceSucceededTcp.inc();
                }
                if (this.iceComponent.getSelectedPair().getRemoteCandidate().getType() == CandidateType.RELAYED_CANDIDATE || this.iceComponent.getSelectedPair().getLocalCandidate().getType() == CandidateType.RELAYED_CANDIDATE) {
                    iceSucceededRelayed.inc();
                }
                iceSucceeded.inc();
            }
        } else if (transition.failed() && this.iceFailed$1.compareAndSet(false, true)) {
            EventHandler eventHandler = this.eventHandler;
            if (eventHandler != null) {
                eventHandler.failed();
            }
            iceFailed.inc();
        }
    }

    public final void updateStatsOnInitialRtt(double rttMs) {
        Object object;
        CandidatePair selectedPair;
        CandidatePair candidatePair = selectedPair = this.iceComponent.getSelectedPair();
        LocalCandidate localCandidate = candidatePair != null ? candidatePair.getLocalCandidate() : null;
        if (localCandidate == null) {
            return;
        }
        LocalCandidate localCandidate2 = localCandidate;
        if (localCandidate2 instanceof HostCandidate) {
            object = "host";
        } else {
            object = MappingCandidateHarvesters.findHarvesterForAddress(localCandidate2.getTransportAddress());
            if (object == null || (object = ((MappingCandidateHarvester)object).getName()) == null) {
                object = "other";
            }
        }
        String harvesterName = object;
        IceStatistics.Companion.getStats().add(harvesterName, rttMs);
    }

    private final void iceStreamPairChanged(PropertyChangeEvent ev) {
        block2: {
            if (!Intrinsics.areEqual("PairConsentFreshnessChanged", ev.getPropertyName())) break block2;
            Object object = ev.getNewValue();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
            }
            Instant time = Instant.ofEpochMilli((Long)object);
            EventHandler eventHandler = this.eventHandler;
            if (eventHandler != null) {
                Intrinsics.checkNotNullExpressionValue(time, "time");
                eventHandler.consentUpdated(time);
            }
        }
    }

    @JvmOverloads
    public IceTransport(@NotNull String id, boolean controlling, boolean useUniquePort, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this(id, controlling, useUniquePort, parentLogger, null, 16, null);
    }

    private static final void iceStateChangeListener$lambda-0(IceTransport this$0, PropertyChangeEvent ev) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullExpressionValue(ev, "ev");
        this$0.iceStateChanged(ev);
    }

    private static final void iceStreamPairChangedListener$lambda-1(IceTransport this$0, PropertyChangeEvent ev) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullExpressionValue(ev, "ev");
        this$0.iceStreamPairChanged(ev);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/videobridge/transport/ice/IceTransport$Companion;", "", "()V", "iceFailed", "Lorg/jitsi/metrics/CounterMetric;", "getIceFailed", "()Lorg/jitsi/metrics/CounterMetric;", "iceSucceeded", "getIceSucceeded", "iceSucceededRelayed", "getIceSucceededRelayed", "iceSucceededTcp", "getIceSucceededTcp", "appendHarvesters", "", "iceAgent", "Lorg/ice4j/ice/Agent;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public final void appendHarvesters(@NotNull Agent iceAgent) {
            block2: {
                Intrinsics.checkNotNullParameter(iceAgent, "iceAgent");
                Harvesters.initializeStaticConfiguration();
                TcpHarvester tcpHarvester = Harvesters.tcpHarvester;
                if (tcpHarvester != null) {
                    TcpHarvester it = tcpHarvester;
                    boolean bl = false;
                    iceAgent.addCandidateHarvester(it);
                }
                List<SinglePortUdpHarvester> list = Harvesters.singlePortHarvesters;
                if (list == null) break block2;
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CandidateHarvester p0 = (CandidateHarvester)element$iv;
                    boolean bl = false;
                    iceAgent.addCandidateHarvester(p0);
                }
            }
        }

        @NotNull
        public final CounterMetric getIceFailed() {
            return iceFailed;
        }

        @NotNull
        public final CounterMetric getIceSucceeded() {
            return iceSucceeded;
        }

        @NotNull
        public final CounterMetric getIceSucceededTcp() {
            return iceSucceededTcp;
        }

        @NotNull
        public final CounterMetric getIceSucceededRelayed() {
            return iceSucceededRelayed;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/videobridge/transport/ice/IceTransport$PacketStats;", "", "()V", "numIncomingPacketsDroppedNoHandler", "Ljava/util/concurrent/atomic/LongAdder;", "getNumIncomingPacketsDroppedNoHandler", "()Ljava/util/concurrent/atomic/LongAdder;", "numOutgoingPacketsDroppedStopped", "getNumOutgoingPacketsDroppedStopped", "numPacketsReceived", "getNumPacketsReceived", "numPacketsSent", "getNumPacketsSent", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "jitsi-videobridge"})
    private static final class PacketStats {
        @NotNull
        private final LongAdder numPacketsReceived = new LongAdder();
        @NotNull
        private final LongAdder numIncomingPacketsDroppedNoHandler = new LongAdder();
        @NotNull
        private final LongAdder numPacketsSent = new LongAdder();
        @NotNull
        private final LongAdder numOutgoingPacketsDroppedStopped = new LongAdder();

        @NotNull
        public final LongAdder getNumPacketsReceived() {
            return this.numPacketsReceived;
        }

        @NotNull
        public final LongAdder getNumIncomingPacketsDroppedNoHandler() {
            return this.numIncomingPacketsDroppedNoHandler;
        }

        @NotNull
        public final LongAdder getNumPacketsSent() {
            return this.numPacketsSent;
        }

        @NotNull
        public final LongAdder getNumOutgoingPacketsDroppedStopped() {
            return this.numOutgoingPacketsDroppedStopped;
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u2d0 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            $this$toJson_u24lambda_u2d0.put("num_packets_received", (Object)this.numPacketsReceived.sum());
            $this$toJson_u24lambda_u2d0.put("num_incoming_packets_dropped_no_handler", (Object)this.numIncomingPacketsDroppedNoHandler.sum());
            $this$toJson_u24lambda_u2d0.put("num_packets_sent", (Object)this.numPacketsSent.sum());
            $this$toJson_u24lambda_u2d0.put("num_outgoing_packets_dropped_stopped", (Object)this.numOutgoingPacketsDroppedStopped.sum());
            return orderedJsonObject;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b"}, d2={"Lorg/jitsi/videobridge/transport/ice/IceTransport$IncomingDataHandler;", "", "dataReceived", "", "data", "", "offset", "", "length", "receivedTime", "Ljava/time/Instant;", "jitsi-videobridge"})
    public static interface IncomingDataHandler {
        public void dataReceived(@NotNull byte[] var1, int var2, int var3, @NotNull Instant var4);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J\b\u0010\u0007\u001a\u00020\u0003H&\u00a8\u0006\b"}, d2={"Lorg/jitsi/videobridge/transport/ice/IceTransport$EventHandler;", "", "connected", "", "consentUpdated", "time", "Ljava/time/Instant;", "failed", "jitsi-videobridge"})
    public static interface EventHandler {
        public void connected();

        public void failed();

        public void consentUpdated(@NotNull Instant var1);
    }
}

