/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.IconAware;
import org.jdesktop.swingx.renderer.IconValues;
import org.jdesktop.swingx.renderer.MappedValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.zaproxy.zap.extension.spider.SpiderMessagesTableModel;
import org.zaproxy.zap.view.table.HistoryReferencesTable;

class SpiderMessagesTable
extends HistoryReferencesTable {
    private static final long serialVersionUID = -1910120966638329368L;
    private final ExtensionHistory extensionHistory;

    public SpiderMessagesTable(SpiderMessagesTableModel resultsModel) {
        super(resultsModel);
        this.setName("SpiderMessagesTable");
        this.setAutoCreateColumnsFromModel(false);
        this.getColumnExt(0).setCellRenderer(new DefaultTableRenderer((StringValue)new MappedValue(StringValues.EMPTY, IconValues.NONE), 0));
        this.getColumnExt(0).setHighlighters(new ProcessedCellItemIconHighlighter(0));
        this.getColumnExt(Constant.messages.getString("view.href.table.header.hrefid")).setVisible(false);
        this.getColumnExt(Constant.messages.getString("view.href.table.header.timestamp.response")).setVisible(false);
        this.getColumnExt(Constant.messages.getString("view.href.table.header.size.requestheader")).setVisible(false);
        this.getColumnExt(Constant.messages.getString("view.href.table.header.size.requestbody")).setVisible(false);
        this.setSortOrder(1, SortOrder.ASCENDING);
        this.extensionHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
    }

    @Override
    public void setModel(TableModel dataModel) {
        int sortedcolumnIndex = this.getSortedColumnIndex();
        SortOrder sortOrder = this.getSortOrder(sortedcolumnIndex);
        super.setModel(dataModel);
        if (sortedcolumnIndex != -1) {
            this.setSortOrder(sortedcolumnIndex, sortOrder);
        }
    }

    @Override
    protected HistoryReference getHistoryReferenceAtViewRow(int row) {
        HistoryReference historyReference = super.getHistoryReferenceAtViewRow(row);
        if (historyReference == null) {
            return null;
        }
        if (this.extensionHistory == null || this.extensionHistory.getHistoryReference(historyReference.getHistoryId()) == null) {
            return null;
        }
        return historyReference;
    }

    private static class ProcessedCellItemIconHighlighter
    extends AbstractHighlighter {
        private static final ImageIcon PROCESSED_ICON = new ImageIcon(SpiderMessagesTable.class.getResource("/resource/icon/16/152.png"));
        private static final ImageIcon NOT_PROCESSED_ICON = new ImageIcon(SpiderMessagesTable.class.getResource("/resource/icon/16/149.png"));
        private final int columnIndex;

        public ProcessedCellItemIconHighlighter(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        protected Component doHighlight(Component component, ComponentAdapter adapter) {
            SpiderMessagesTableModel.ProcessedCellItem cell = (SpiderMessagesTableModel.ProcessedCellItem)adapter.getValue(this.columnIndex);
            boolean processed = cell.isSuccessful();
            Icon icon = ProcessedCellItemIconHighlighter.getProcessedIcon(processed);
            if (component instanceof IconAware) {
                ((IconAware)((Object)component)).setIcon(icon);
            } else if (component instanceof JLabel) {
                ((JLabel)component).setIcon(icon);
            }
            if (component instanceof JLabel) {
                ((JLabel)component).setText(processed ? "" : cell.getLabel());
            }
            return component;
        }

        private static Icon getProcessedIcon(boolean processed) {
            return processed ? PROCESSED_ICON : NOT_PROCESSED_ICON;
        }

        @Override
        protected boolean canHighlight(Component component, ComponentAdapter adapter) {
            return component instanceof IconAware || component instanceof JLabel;
        }
    }
}

