/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.securityanalytics.model.Detector;

public class GetDetectorResponse
extends ActionResponse
implements ToXContentObject {
    private String id;
    private Long version;
    private RestStatus status;
    private Detector detector;

    public GetDetectorResponse(String id, Long version, RestStatus status, Detector detector) {
        this.id = id;
        this.version = version;
        this.status = status;
        this.detector = detector;
    }

    public GetDetectorResponse(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readLong(), (RestStatus)sin.readEnum(RestStatus.class), sin.readBoolean() ? Detector.readFrom(sin) : null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeLong(this.version.longValue());
        out.writeEnum((Enum)this.status);
        if (this.detector != null) {
            out.writeBoolean(true);
            this.detector.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("_id", this.id).field("_version", this.version);
        builder.startObject("detector").field("name", this.detector.getName()).field("detector_type", this.detector.getDetectorType()).field("enabled", this.detector.getEnabled()).field("schedule", (ToXContent)this.detector.getSchedule()).field("inputs", this.detector.getInputs()).field("last_update_time", (Object)this.detector.getLastUpdateTime()).field("enabled_time", (Object)this.detector.getEnabledTime()).endObject();
        return builder.endObject();
    }

    public String getId() {
        return this.id;
    }

    public Long getVersion() {
        return this.version;
    }

    public RestStatus getStatus() {
        return this.status;
    }

    public Detector getDetector() {
        return this.detector;
    }
}

