/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.greenrobot.eventbus.Subscribe;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.auth.AuthDomain;
import org.opensearch.security.auth.AuthFailureListener;
import org.opensearch.security.auth.AuthenticationBackend;
import org.opensearch.security.auth.AuthorizationBackend;
import org.opensearch.security.auth.HTTPAuthenticator;
import org.opensearch.security.auth.UserInjector;
import org.opensearch.security.auth.blocking.ClientBlockRegistry;
import org.opensearch.security.auth.internal.NoOpAuthenticationBackend;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.http.XFFResolver;
import org.opensearch.security.securityconf.DynamicConfigModel;
import org.opensearch.security.ssl.util.Utils;
import org.opensearch.security.user.AuthCredentials;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;

public class BackendRegistry {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private SortedSet<AuthDomain> restAuthDomains;
    private Set<AuthorizationBackend> restAuthorizers;
    private List<AuthFailureListener> ipAuthFailureListeners;
    private Multimap<String, AuthFailureListener> authBackendFailureListeners;
    private List<ClientBlockRegistry<InetAddress>> ipClientBlockRegistries;
    private Multimap<String, ClientBlockRegistry<String>> authBackendClientBlockRegistries;
    private volatile boolean initialized;
    private volatile boolean injectedUserEnabled = false;
    private final AdminDNs adminDns;
    private final XFFResolver xffResolver;
    private volatile boolean anonymousAuthEnabled = false;
    private final Settings opensearchSettings;
    private final AuditLog auditLog;
    private final ThreadPool threadPool;
    private final UserInjector userInjector;
    private final int ttlInMin;
    private Cache<AuthCredentials, User> userCache;
    private Cache<String, User> restImpersonationCache;
    private Cache<User, Set<String>> restRoleCache;

    private void createCaches() {
        this.userCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<AuthCredentials, User>(){

            public void onRemoval(RemovalNotification<AuthCredentials, User> notification) {
                BackendRegistry.this.log.debug("Clear user cache for {} due to {}", (Object)((AuthCredentials)notification.getKey()).getUsername(), (Object)notification.getCause());
            }
        }).build();
        this.restImpersonationCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<String, User>(){

            public void onRemoval(RemovalNotification<String, User> notification) {
                BackendRegistry.this.log.debug("Clear user cache for {} due to {}", notification.getKey(), (Object)notification.getCause());
            }
        }).build();
        this.restRoleCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttlInMin, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<User, Set<String>>(){

            public void onRemoval(RemovalNotification<User, Set<String>> notification) {
                BackendRegistry.this.log.debug("Clear user cache for {} due to {}", notification.getKey(), (Object)notification.getCause());
            }
        }).build();
    }

    public BackendRegistry(Settings settings, AdminDNs adminDns, XFFResolver xffResolver, AuditLog auditLog, ThreadPool threadPool) {
        this.adminDns = adminDns;
        this.opensearchSettings = settings;
        this.xffResolver = xffResolver;
        this.auditLog = auditLog;
        this.threadPool = threadPool;
        this.userInjector = new UserInjector(settings, threadPool, auditLog, xffResolver);
        this.ttlInMin = settings.getAsInt("plugins.security.cache.ttl_minutes", Integer.valueOf(60));
        this.injectedUserEnabled = this.opensearchSettings.getAsBoolean("plugins.security.unsupported.inject_user.enabled", Boolean.valueOf(false));
        this.createCaches();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void invalidateCache() {
        this.userCache.invalidateAll();
        this.restImpersonationCache.invalidateAll();
        this.restRoleCache.invalidateAll();
    }

    @Subscribe
    public void onDynamicConfigModelChanged(DynamicConfigModel dcm) {
        this.invalidateCache();
        this.anonymousAuthEnabled = dcm.isAnonymousAuthenticationEnabled() && this.opensearchSettings.getAsBoolean("plugins.security.compliance.disable_anonymous_authentication", Boolean.valueOf(false)) == false;
        this.restAuthDomains = Collections.unmodifiableSortedSet(dcm.getRestAuthDomains());
        this.restAuthorizers = Collections.unmodifiableSet(dcm.getRestAuthorizers());
        this.ipAuthFailureListeners = dcm.getIpAuthFailureListeners();
        this.authBackendFailureListeners = dcm.getAuthBackendFailureListeners();
        this.ipClientBlockRegistries = dcm.getIpClientBlockRegistries();
        this.authBackendClientBlockRegistries = dcm.getAuthBackendClientBlockRegistries();
        this.initialized = !this.restAuthDomains.isEmpty() || this.anonymousAuthEnabled || this.injectedUserEnabled;
    }

    public boolean authenticate(RestRequest request, RestChannel channel, org.opensearch.common.util.concurrent.ThreadContext threadContext) {
        boolean isDebugEnabled = this.log.isDebugEnabled();
        if (request.getHttpChannel().getRemoteAddress() instanceof InetSocketAddress && this.isBlocked(request.getHttpChannel().getRemoteAddress().getAddress())) {
            if (isDebugEnabled) {
                this.log.debug("Rejecting REST request because of blocked address: {}", (Object)request.getHttpChannel().getRemoteAddress());
            }
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.UNAUTHORIZED, "Authentication finally failed"));
            return false;
        }
        String sslPrincipal = (String)this.threadPool.getThreadContext().getTransient("_opendistro_security_ssl_principal");
        if (this.adminDns.isAdminDN(sslPrincipal)) {
            this.threadPool.getThreadContext().putTransient("_opendistro_security_user", (Object)new User(sslPrincipal));
            this.auditLog.logSucceededLogin(sslPrincipal, true, null, request);
            return true;
        }
        if (this.userInjector.injectUser(request)) {
            return true;
        }
        if (!this.isInitialized()) {
            this.log.error("Not yet initialized (you may need to run securityadmin)");
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.SERVICE_UNAVAILABLE, "OpenSearch Security not initialized."));
            return false;
        }
        TransportAddress remoteAddress = this.xffResolver.resolve(request);
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (isTraceEnabled) {
            this.log.trace("Rest authentication request from {} [original: {}]", (Object)remoteAddress, (Object)request.getHttpChannel().getRemoteAddress());
        }
        threadContext.putTransient("_opendistro_security_remote_address", (Object)remoteAddress);
        boolean authenticated = false;
        User authenticatedUser = null;
        AuthCredentials authCredenetials = null;
        HTTPAuthenticator firstChallengingHttpAuthenticator = null;
        for (AuthDomain authDomain : this.restAuthDomains) {
            AuthCredentials ac;
            if (isDebugEnabled) {
                this.log.debug("Check authdomain for rest {}/{} or {} in total", (Object)authDomain.getBackend().getType(), (Object)authDomain.getOrder(), (Object)this.restAuthDomains.size());
            }
            HTTPAuthenticator httpAuthenticator = authDomain.getHttpAuthenticator();
            if (authDomain.isChallenge() && firstChallengingHttpAuthenticator == null) {
                firstChallengingHttpAuthenticator = httpAuthenticator;
            }
            if (isTraceEnabled) {
                this.log.trace("Try to extract auth creds from {} http authenticator", (Object)httpAuthenticator.getType());
            }
            try {
                ac = httpAuthenticator.extractCredentials(request, threadContext);
            }
            catch (Exception e1) {
                if (!isDebugEnabled) continue;
                this.log.debug("'{}' extracting credentials from {} http authenticator", (Object)e1.toString(), (Object)httpAuthenticator.getType(), (Object)e1);
                continue;
            }
            if (ac != null && this.isBlocked(authDomain.getBackend().getClass().getName(), ac.getUsername())) {
                if (!isDebugEnabled) continue;
                this.log.debug("Rejecting REST request because of blocked user: {}, authDomain: {}", (Object)ac.getUsername(), (Object)authDomain);
                continue;
            }
            authCredenetials = ac;
            if (ac == null) {
                if (this.anonymousAuthEnabled) continue;
                if (authDomain.isChallenge() && httpAuthenticator.reRequestAuthentication(channel, null)) {
                    this.auditLog.logFailedLogin("<NONE>", false, null, request);
                    this.log.warn("No 'Authorization' header, send 401 and 'WWW-Authenticate Basic'");
                    return false;
                }
                if (!isTraceEnabled) continue;
                this.log.trace("No 'Authorization' header, send 403");
                continue;
            }
            ThreadContext.put((String)"user", (String)ac.getUsername());
            if (!ac.isComplete()) {
                if (!httpAuthenticator.reRequestAuthentication(channel, ac)) continue;
                return false;
            }
            authenticatedUser = this.authcz(this.userCache, this.restRoleCache, ac, authDomain.getBackend(), this.restAuthorizers);
            if (authenticatedUser == null) {
                if (isDebugEnabled) {
                    this.log.debug("Cannot authenticate rest user {} (or add roles) with authdomain {}/{} of {}, try next", (Object)ac.getUsername(), (Object)authDomain.getBackend().getType(), (Object)authDomain.getOrder(), this.restAuthDomains);
                }
                for (AuthFailureListener authFailureListener : this.authBackendFailureListeners.get((Object)authDomain.getBackend().getClass().getName())) {
                    authFailureListener.onAuthFailure(request.getHttpChannel().getRemoteAddress() instanceof InetSocketAddress ? request.getHttpChannel().getRemoteAddress().getAddress() : null, ac, request);
                }
                continue;
            }
            if (this.adminDns.isAdmin(authenticatedUser)) {
                this.log.error("Cannot authenticate rest user because admin user is not permitted to login via HTTP");
                this.auditLog.logFailedLogin(authenticatedUser.getName(), true, null, request);
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Cannot authenticate user because admin user is not permitted to login via HTTP"));
                return false;
            }
            String tenant = Utils.coalesce(request.header("securitytenant"), request.header("security_tenant"));
            if (isDebugEnabled) {
                this.log.debug("Rest user '{}' is authenticated", (Object)authenticatedUser);
                this.log.debug("securitytenant '{}'", (Object)tenant);
            }
            authenticatedUser.setRequestedTenant(tenant);
            authenticated = true;
            break;
        }
        if (!authenticated) {
            if (isDebugEnabled) {
                this.log.debug("User still not authenticated after checking {} auth domains", (Object)this.restAuthDomains.size());
            }
            if (authCredenetials == null && this.anonymousAuthEnabled) {
                String tenant = Utils.coalesce(request.header("securitytenant"), request.header("security_tenant"));
                User anonymousUser = new User(User.ANONYMOUS.getName(), new HashSet<String>(User.ANONYMOUS.getRoles()), null);
                anonymousUser.setRequestedTenant(tenant);
                threadContext.putTransient("_opendistro_security_user", (Object)anonymousUser);
                this.auditLog.logSucceededLogin(anonymousUser.getName(), false, null, request);
                if (isDebugEnabled) {
                    this.log.debug("Anonymous User is authenticated");
                }
                return true;
            }
            if (firstChallengingHttpAuthenticator != null) {
                if (isDebugEnabled) {
                    this.log.debug("Rerequest with {}", firstChallengingHttpAuthenticator.getClass());
                }
                if (firstChallengingHttpAuthenticator.reRequestAuthentication(channel, null)) {
                    if (isDebugEnabled) {
                        this.log.debug("Rerequest {} failed", firstChallengingHttpAuthenticator.getClass());
                    }
                    this.log.warn("Authentication finally failed for {} from {}", (Object)(authCredenetials == null ? null : authCredenetials.getUsername()), (Object)remoteAddress);
                    this.auditLog.logFailedLogin(authCredenetials == null ? null : authCredenetials.getUsername(), false, null, request);
                    return false;
                }
            }
            this.log.warn("Authentication finally failed for {} from {}", (Object)(authCredenetials == null ? null : authCredenetials.getUsername()), (Object)remoteAddress);
            this.auditLog.logFailedLogin(authCredenetials == null ? null : authCredenetials.getUsername(), false, null, request);
            this.notifyIpAuthFailureListeners(request, authCredenetials);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.UNAUTHORIZED, "Authentication finally failed"));
            return false;
        }
        User impersonatedUser = this.impersonate(request, authenticatedUser);
        threadContext.putTransient("_opendistro_security_user", (Object)(impersonatedUser == null ? authenticatedUser : impersonatedUser));
        this.auditLog.logSucceededLogin((impersonatedUser == null ? authenticatedUser : impersonatedUser).getName(), false, authenticatedUser.getName(), request);
        return authenticated;
    }

    private void notifyIpAuthFailureListeners(RestRequest request, AuthCredentials authCredentials) {
        this.notifyIpAuthFailureListeners(request.getHttpChannel().getRemoteAddress() instanceof InetSocketAddress ? request.getHttpChannel().getRemoteAddress().getAddress() : null, authCredentials, request);
    }

    private void notifyIpAuthFailureListeners(InetAddress remoteAddress, AuthCredentials authCredentials, Object request) {
        for (AuthFailureListener authFailureListener : this.ipAuthFailureListeners) {
            authFailureListener.onAuthFailure(remoteAddress, authCredentials, request);
        }
    }

    private User checkExistsAndAuthz(Cache<String, User> cache, final User user, final AuthenticationBackend authenticationBackend, final Set<AuthorizationBackend> authorizers) {
        if (user == null) {
            return null;
        }
        final boolean isDebugEnabled = this.log.isDebugEnabled();
        final boolean isTraceEnabled = this.log.isTraceEnabled();
        try {
            return (User)cache.get((Object)user.getName(), (Callable)new Callable<User>(){

                @Override
                public User call() throws Exception {
                    if (isTraceEnabled) {
                        BackendRegistry.this.log.trace("Credentials for user {} not cached, return from {} backend directly", (Object)user.getName(), (Object)authenticationBackend.getType());
                    }
                    if (authenticationBackend.exists(user)) {
                        BackendRegistry.this.authz(user, null, authorizers);
                        return user;
                    }
                    if (isDebugEnabled) {
                        BackendRegistry.this.log.debug("User {} does not exist in {}", (Object)user.getName(), (Object)authenticationBackend.getType());
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                this.log.debug("Can not check and authorize {} due to ", (Object)user.getName(), (Object)e);
            }
            return null;
        }
    }

    private void authz(User authenticatedUser, Cache<User, Set<String>> roleCache, Set<AuthorizationBackend> authorizers) {
        Set cachedBackendRoles;
        if (authenticatedUser == null) {
            return;
        }
        if (roleCache != null && (cachedBackendRoles = (Set)roleCache.getIfPresent((Object)authenticatedUser)) != null) {
            authenticatedUser.addRoles(new HashSet<String>(cachedBackendRoles));
            return;
        }
        if (authorizers == null || authorizers.isEmpty()) {
            return;
        }
        boolean isTraceEnabled = this.log.isTraceEnabled();
        for (AuthorizationBackend ab : authorizers) {
            try {
                if (isTraceEnabled) {
                    this.log.trace("Backend roles for {} not cached, return from {} backend directly", (Object)authenticatedUser.getName(), (Object)ab.getType());
                }
                ab.fillRoles(authenticatedUser, new AuthCredentials(authenticatedUser.getName(), new String[0]));
            }
            catch (Exception e) {
                this.log.error("Cannot retrieve roles for {} from {} due to {}", (Object)authenticatedUser, (Object)ab.getType(), (Object)e.toString(), (Object)e);
            }
        }
        if (roleCache != null) {
            roleCache.put((Object)authenticatedUser, new HashSet<String>(authenticatedUser.getRoles()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User authcz(Cache<AuthCredentials, User> cache, final Cache<User, Set<String>> roleCache, final AuthCredentials ac, final AuthenticationBackend authBackend, final Set<AuthorizationBackend> authorizers) {
        if (ac == null) {
            return null;
        }
        try {
            if (authBackend.getClass() == NoOpAuthenticationBackend.class && authorizers.isEmpty()) {
                User user = authBackend.authenticate(ac);
                return user;
            }
            User user = (User)cache.get((Object)ac, (Callable)new Callable<User>(){

                @Override
                public User call() throws Exception {
                    if (BackendRegistry.this.log.isTraceEnabled()) {
                        BackendRegistry.this.log.trace("Credentials for user {} not cached, return from {} backend directly", (Object)ac.getUsername(), (Object)authBackend.getType());
                    }
                    User authenticatedUser = authBackend.authenticate(ac);
                    BackendRegistry.this.authz(authenticatedUser, (Cache<User, Set<String>>)roleCache, authorizers);
                    return authenticatedUser;
                }
            });
            return user;
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Can not authenticate {} due to exception", (Object)ac.getUsername(), (Object)e);
            }
            User user = null;
            return user;
        }
        finally {
            ac.clearSecrets();
        }
    }

    private User impersonate(RestRequest request, User originalUser) throws OpenSearchSecurityException {
        String impersonatedUserHeader = request.header("opendistro_security_impersonate_as");
        if (Strings.isNullOrEmpty((String)impersonatedUserHeader) || originalUser == null) {
            return null;
        }
        if (!this.isInitialized()) {
            throw new OpenSearchSecurityException("Could not check for impersonation because OpenSearch Security is not yet initialized", new Object[0]);
        }
        if (this.adminDns.isAdminDN(impersonatedUserHeader)) {
            throw new OpenSearchSecurityException("It is not allowed to impersonate as an adminuser  '" + impersonatedUserHeader + "'", RestStatus.FORBIDDEN, new Object[0]);
        }
        if (!this.adminDns.isRestImpersonationAllowed(originalUser.getName(), impersonatedUserHeader)) {
            throw new OpenSearchSecurityException("'" + originalUser.getName() + "' is not allowed to impersonate as '" + impersonatedUserHeader + "'", RestStatus.FORBIDDEN, new Object[0]);
        }
        boolean isDebugEnabled = this.log.isDebugEnabled();
        for (AuthDomain authDomain : this.restAuthDomains) {
            AuthenticationBackend authenticationBackend = authDomain.getBackend();
            User impersonatedUser = this.checkExistsAndAuthz(this.restImpersonationCache, new User(impersonatedUserHeader), authenticationBackend, this.restAuthorizers);
            if (impersonatedUser == null) {
                this.log.debug("Unable to impersonate rest user from '{}' to '{}' because the impersonated user does not exists in {}, try next ...", (Object)originalUser.getName(), (Object)impersonatedUserHeader, (Object)authenticationBackend.getType());
                continue;
            }
            if (isDebugEnabled) {
                this.log.debug("Impersonate rest user from '{}' to '{}'", (Object)originalUser.toStringWithAttributes(), (Object)impersonatedUser.toStringWithAttributes());
            }
            impersonatedUser.setRequestedTenant(originalUser.getRequestedTenant());
            return impersonatedUser;
        }
        this.log.debug("Unable to impersonate rest user from '{}' to '{}' because the impersonated user does not exists", (Object)originalUser.getName(), (Object)impersonatedUserHeader);
        throw new OpenSearchSecurityException("No such user:" + impersonatedUserHeader, RestStatus.FORBIDDEN, new Object[0]);
    }

    private boolean isBlocked(InetAddress address) {
        if (this.ipClientBlockRegistries == null || this.ipClientBlockRegistries.isEmpty()) {
            return false;
        }
        for (ClientBlockRegistry<InetAddress> clientBlockRegistry : this.ipClientBlockRegistries) {
            if (!clientBlockRegistry.isBlocked(address)) continue;
            return true;
        }
        return false;
    }

    private boolean isBlocked(String authBackend, String userName) {
        if (this.authBackendClientBlockRegistries == null) {
            return false;
        }
        Collection clientBlockRegistries = this.authBackendClientBlockRegistries.get((Object)authBackend);
        if (clientBlockRegistries.isEmpty()) {
            return false;
        }
        for (ClientBlockRegistry clientBlockRegistry : clientBlockRegistries) {
            if (!clientBlockRegistry.isBlocked(userName)) continue;
            return true;
        }
        return false;
    }
}

