/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.ad.ratelimit.ResultWriteRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class ADResultBulkRequest
extends ActionRequest
implements Writeable {
    private final List<ResultWriteRequest> anomalyResults;
    static final String NO_REQUESTS_ADDED_ERR = "no requests added";

    public ADResultBulkRequest() {
        this.anomalyResults = new ArrayList<ResultWriteRequest>();
    }

    public ADResultBulkRequest(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.anomalyResults = new ArrayList<ResultWriteRequest>(size);
        for (int i = 0; i < size; ++i) {
            this.anomalyResults.add(new ResultWriteRequest(in));
        }
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.anomalyResults.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)NO_REQUESTS_ADDED_ERR, validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.anomalyResults.size());
        for (ResultWriteRequest result : this.anomalyResults) {
            result.writeTo(out);
        }
    }

    public List<ResultWriteRequest> getAnomalyResults() {
        return this.anomalyResults;
    }

    public void add(ResultWriteRequest resultWriteRequest) {
        this.anomalyResults.add(resultWriteRequest);
    }

    public int numberOfActions() {
        return this.anomalyResults.size();
    }
}

