/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.JakartaJsonArray;
import com.github.wnameless.json.base.JakartaJsonValue;
import com.github.wnameless.json.base.JsonObjectCore;
import com.github.wnameless.json.base.JsonSource;
import com.github.wnameless.json.base.TransformIterator;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public final class JakartaJsonObject
implements JsonObjectCore<JakartaJsonValue> {
    private JsonObject jsonObject;

    public JakartaJsonObject(JsonObject jsonObject) {
        if (jsonObject == null) {
            throw new NullPointerException();
        }
        this.jsonObject = jsonObject;
    }

    @Override
    public void set(String name, JsonSource jsonValue) {
        this.jsonObject = Json.createObjectBuilder((JsonObject)this.jsonObject).add(name, (JsonValue)jsonValue.getSource()).build();
    }

    @Override
    public boolean remove(String name) {
        boolean isRemovable = this.jsonObject.containsKey((Object)name);
        this.jsonObject = Json.createObjectBuilder((JsonObject)this.jsonObject).remove(name).build();
        return isRemovable;
    }

    @Override
    public boolean contains(String name) {
        return this.jsonObject.containsKey((Object)name);
    }

    @Override
    public JakartaJsonValue get(String name) {
        JsonValue value = (JsonValue)this.jsonObject.get((Object)name);
        return value == null ? null : new JakartaJsonValue(value);
    }

    @Override
    public int size() {
        return this.jsonObject.size();
    }

    @Override
    public Iterator<String> names() {
        return this.jsonObject.keySet().iterator();
    }

    @Override
    public Iterator<Map.Entry<String, JakartaJsonValue>> iterator() {
        return new TransformIterator<Map.Entry, Map.Entry>(this.jsonObject.entrySet().iterator(), member -> new AbstractMap.SimpleImmutableEntry<String, JakartaJsonValue>((String)member.getKey(), new JakartaJsonValue((JsonValue)member.getValue())));
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean asBoolean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int asInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long asLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger asBigInteger() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double asDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JakartaJsonObject asObject() {
        return this;
    }

    @Override
    public JakartaJsonArray asArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JakartaJsonValue asValue() {
        return new JakartaJsonValue((JsonValue)this.jsonObject);
    }

    @Override
    public Object getSource() {
        return this.jsonObject;
    }

    @Override
    public String toJson() {
        return this.toString();
    }

    public int hashCode() {
        return this.jsonObject.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JakartaJsonObject)) {
            return false;
        }
        return Objects.equals(this.jsonObject, ((JakartaJsonObject)o).jsonObject);
    }

    public String toString() {
        return this.jsonObject.toString();
    }
}

