/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.util;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import lombok.Generated;
import org.opensearch.knn.index.KNNMethod;
import org.opensearch.knn.index.KNNMethodContext;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.util.AbstractKNNLibrary;

abstract class NativeLibrary
extends AbstractKNNLibrary {
    private final Map<SpaceType, Function<Float, Float>> scoreTranslation;
    private final String extension;
    private final AtomicBoolean initialized;

    NativeLibrary(Map<String, KNNMethod> methods, Map<SpaceType, Function<Float, Float>> scoreTranslation, String version, String extension) {
        super(methods, version);
        this.scoreTranslation = scoreTranslation;
        this.extension = extension;
        this.initialized = new AtomicBoolean(false);
    }

    @Override
    public String getCompoundExtension() {
        return this.getExtension() + "c";
    }

    @Override
    public float score(float rawScore, SpaceType spaceType) {
        if (this.scoreTranslation.containsKey((Object)spaceType)) {
            return this.scoreTranslation.get((Object)spaceType).apply(Float.valueOf(rawScore)).floatValue();
        }
        return spaceType.scoreTranslation(rawScore);
    }

    @Override
    public int estimateOverheadInKB(KNNMethodContext knnMethodContext, int dimension) {
        String methodName = knnMethodContext.getMethodComponent().getName();
        return this.getMethod(methodName).estimateOverheadInKB(knnMethodContext, dimension);
    }

    @Override
    public Boolean isInitialized() {
        return this.initialized.get();
    }

    @Override
    public void setInitialized(Boolean isInitialized) {
        Objects.requireNonNull(isInitialized, "isInitialized must not be null");
        this.initialized.set(isInitialized);
    }

    @Override
    @Generated
    public String getExtension() {
        return this.extension;
    }
}

