<?php

/**
 * ⚠️ Editing not allowed except for 'en' language.
 *
 * @see https://github.com/monicahq/monica/blob/main/docs/contribute/translate.md for translations.
 */

return [
    'sidebar_settings' => 'Hesap ayarları',
    'sidebar_personalization' => 'Kişiselleştirme',
    'sidebar_settings_storage' => 'Saklama alanı',
    'sidebar_settings_export' => 'Verileri dışa aktar',
    'sidebar_settings_users' => 'Kullanıcılar',
    'sidebar_settings_subscriptions' => 'Abonelik',
    'sidebar_settings_import' => 'Verileri içe aktar',
    'sidebar_settings_tags' => 'Etiket Yönetimi',
    'sidebar_settings_api' => 'API',
    'sidebar_settings_dav' => 'DAV Kaynakları',
    'sidebar_settings_security' => 'Güvenlik',
    'sidebar_settings_auditlogs' => 'İnceleme günlüğü',

    'title_general' => 'Genel Bilgiler',
    'title_i18n' => 'Uluslararası ayarlar',
    'title_layout' => 'Görünüm',

    'me_title' => 'Bir kişi olarak ben',
    'me_help' => 'Bu hesap Monica\'da <em>sizi</em> temsil eden kişidir',
    'me_select' => 'Bir kişi seçin',
    'me_no_contact' => 'Henüz bir kişi seçilmedi.',
    'me_select_click' => 'Bir kişi seçmek için buraya tıklayınız.',
    'me_remove_contact' => 'İlişkiyi Kaldır',
    'me_choose' => 'Kendinizi seçin',
    'me_choose_placeholder' => 'Kendinizi seçin',

    'export_title' => 'Hesap bilgilerini dışarı aktar',
    'export_be_patient' => 'Click the button to start the export. It might take several minutes to process the export – please be patient and do not spam the button.',
    'export_title_sql' => 'Export to SQL',
    'export_sql_explanation' => 'Exporting your data in SQL format allows you to take your data and import it to your own Monica instance. This is only valuable if you do have your own server.',
    'export_sql_cta' => 'Export to SQL',
    'export_sql_link_instructions' => 'Note: <a href=":url">read the instructions</a> to learn more about importing this file to your instance.',
    'export_title_json' => 'Export to Json',
    'export_submitted' => 'Your export has been submitted, it will be available in a few moment…',
    'export_json_explanation' => 'Exporting your data in Json format for backup.',
    'export_json_beta' => 'Json export is in preview mode. Tell us what you think about it:',
    'export_json_cta' => 'Export to Json',
    'export_header_type' => 'Type',
    'export_header_timestamp' => 'Creation date',
    'export_header_status' => 'Status',
    'export_header_actions' => 'Actions',
    'export_last_title' => 'Last exports',
    'export_empty_title' => 'No exports yet',
    'export_type_json' => 'Json export',
    'export_type_sql' => 'SQL export',
    'export_status_todo' => 'Submitted',
    'export_status_doing' => 'Doing',
    'export_status_done' => 'Done',
    'export_status_failed' => 'Failed',
    'export_not_done' => 'Download impossible, this export is not done yet.',

    'firstname' => 'Ad',
    'lastname' => 'Soyad',
    'name_order' => 'İsim gösterimi',
    'name_order_firstname_lastname' => '<First name> <Last name> – John Doe',
    'name_order_lastname_firstname' => '<Last name> <First name> – Doe John',
    'name_order_firstname_lastname_nickname' => '<First name> <Last name> (<Nickname>) – John Doe (Rambo)',
    'name_order_firstname_nickname_lastname' => '<First name> (<Nickname>) <Last name> – John (Rambo) Doe',
    'name_order_lastname_firstname_nickname' => '<Last name> <First name> (<Nickname>) – Doe John (Rambo)',
    'name_order_lastname_nickname_firstname' => '<Last name> (<Nickname>) <First name> – Doe (Rambo) John',
    'name_order_nickname_firstname_lastname' => '<Nickname> (<First name> <Last name>) – Rambo (John Doe)',
    'name_order_nickname_lastname_firstname' => '<Nickname> (<Last name> <First name>) – Rambo (Doe John)',
    'name_order_nickname' => '<Nickname> – Rambo',
    'currency' => 'Para Birimi',
    'name' => 'Adınız: :name',
    'email' => 'E-posta adresi',
    'email_placeholder' => 'E-posta girin',
    'email_help' => 'This is the email used to login, and this is where Monica will send your reminders.',
    'timezone' => 'Zaman Dilimi',
    'temperature_scale' => 'Sıcaklık ölçeği',
    'temperature_scale_fahrenheit' => 'Fahrenheit (°F)',
    'temperature_scale_celsius' => 'Celsius (°C)',
    'layout' => 'Görünüm',
    'layout_small' => 'En fazla 1200 piksel genişliğinde',
    'layout_big' => 'Tarayıcının tam genişliği',
    'save' => 'Tercihleri güncelle',
    'delete_title' => 'Hesabınızı silin',
    'delete_desc' => 'Do you wish to delete your account? Deletion is permanent and all of your data will be erased permanently. If you have a subscription, it will be cancelled immediately.',
    'delete_other_desc' => 'Your data in the main database will be deleted immediately. As described in our privacy policy, we carry out securely encrypted backups of the database every day.  These backups are kept for 30 days after which they are completely deleted. We cannot delete specific data from the backups we hold any earlier than this.  All of your data will be completely deleted no later than 31 days after your account’s deletion.',
    'reset_desc' => 'Do you wish to reset your account? This will remove all your contacts, and all of the data associated with them. Your account will not be deleted.',
    'reset_title' => 'Hesabınızı sıfırlayın',
    'reset_cta' => 'Hesabı sıfırla',
    'reset_notice' => 'Are you sure to reset your account? This is permanent and cannot be undone.',
    'reset_success' => 'Your account has been reset successfully.',
    'delete_notice' => 'Are you sure you want to delete your account? This is permanent and cannot be undone. All of your data will be deleted and will not be recoverable.',
    'delete_cta' => 'Hesabı sil',
    'settings_success' => 'Tercihler güncellendi!',
    'locale' => 'Uygulamada kullanılacak dil',
    'locale_help' => 'Monica\'yı çevirmeye yardım etmek veya yeni bir dil eklemek ister misiniz? Lütfen <a href=":url" target="_blank" lang="en">daha fazla bilgi için bu linki</a> takip edin.',
    'locale_ar' => 'Arapça',
    'locale_cs' => 'Çekçe',
    'locale_de' => 'Almanca',
    'locale_el' => 'Greek',
    'locale_en' => 'İngilizce',
    'locale_en-GB' => 'İngilizce (Birleşik Krallık)',
    'locale_es' => 'İspanyolca',
    'locale_fr' => 'Fransızca',
    'locale_he' => 'İbranice',
    'locale_hr' => 'Hırvatca',
    'locale_id' => 'Indonesian',
    'locale_it' => 'İtalyanca',
    'locale_ja' => 'Japonca',
    'locale_nl' => 'Flemenkçe',
    'locale_pt' => 'Portekizce',
    'locale_pt-BR' => 'Portuguese, Brazil',
    'locale_ru' => 'Rusça',
    'locale_sv' => 'İsveççe',
    'locale_vi' => 'Vietnamese',
    'locale_zh' => 'Çince (Basitleştirilmiş)',
    'locale_zh-TW' => 'Geleneksel Çince',
    'locale_tr' => 'Türkçe',

    'security_title' => 'Güvenlik',
    'security_help' => 'Hesabınız için güvenlik unsurlarını değiştirin.',
    'password_change' => 'Change your password',
    'password_current' => 'Geçerli şifre',
    'password_current_placeholder' => 'Geçerli şifrenizi giriniz',
    'password_new1' => 'Yeni şifre',
    'password_new1_placeholder' => 'Enter your new password',
    'password_new2' => 'Confirm your new password',
    'password_new2_placeholder' => 'Retype your new password',
    'password_btn' => 'Şifreyi Değiştir',
    '2fa_title' => 'İki Aşamalı Kimlik Doğrulaması',
    '2fa_otp_title' => 'İki Aşamalı Kimlik Doğrulaması mobil uygulama',
    '2fa_enable_title' => 'İki aşamalı kimlik doğrulamasını etkinleştir',
    '2fa_enable_description' => 'Enable Two Factor Authentication to increase the security of your account.',
    '2fa_enable_otp' => 'Open up your Two Factor Authentication mobile app and scan the following QR barcode:',
    '2fa_enable_otp_help' => 'If your Two Factor Authentication mobile app does not support QR barcodes, enter in the following code:',
    '2fa_enable_otp_validate' => 'Please validate the new device you’ve just set up:',
    '2fa_enable_success' => 'İki aşamalı kimlik doğrulaması etkinleştirildi',
    '2fa_enable_error' => 'İki Adımlı Kimlik Doğrulamayı etkinleştirmeye çalışırken hata oluştu',
    '2fa_enable_error_already_set' => 'İki aşamalı kimlik doğrulaması zaten etkinleştirildi',
    '2fa_disable_title' => 'İki Aşamalı Kimlik Doğrulamasını devre dışı bırak',
    '2fa_disable_description' => 'Disable Two Factor Authentication for your account. Be careful, your account will be much less secure!',
    '2fa_disable_success' => 'İki Adımlı Kimlik Doğrulaması devre dışı',
    '2fa_disable_error' => 'İki Adımlı Kimlik Doğrulamayı devre dışı bırakmaya çalışırken hata oluştu',

    'webauthn_title' => 'Güvenlik anahtarı — WebAuthn protokolü',
    'webauthn_enable_description' => 'Yeni bir güvenlik anahtarı ekleyin',
    'webauthn_key_name_help' => 'Anahtarınıza bir isim verin.',
    'webauthn_key_name' => 'Anahtar adı:',
    'webauthn_success' => 'Anahtarınız algılandı ve doğrulandı.',
    'webauthn_last_use' => 'Son kullanım: {timestamp}',
    'webauthn_delete_confirmation' => 'Bu anahtarı silmek istediğinizden emin misiniz?',
    'webauthn_delete_success' => 'Anahtar silindi',
    'webauthn_insertKey' => 'Güvenlik anahtarınızı girin.',
    'webauthn_buttonAdvise' => 'Güvenlik anahtarında bir düğme varsa, ona basın.',
    'webauthn_noButtonAdvise' => 'Eğer yoksa, çıkarın ve tekrar takın.',
    'webauthn_not_supported' => 'Tarayıcınız şu anda WebAuthn\'u desteklememektedir.',
    'webauthn_not_secured' => 'WebAuthn yalnızca güvenli bağlantıları desteklemektedir. Lütfen bu sayfayı https şeması ile yükleyin.',
    'webauthn_error_already_used' => 'Bu anahtar zaten kayıtlı. Tekrar kaydetmek gerekli değil.',
    'webauthn_error_not_allowed' => 'İşlem zaman aşımına uğradı veya izin verilmedi.',

    'recovery_title' => 'Kurtarma kodları',
    'recovery_show' => 'Kurtarma kodlarını göster',
    'recovery_copy_help' => 'Kodları panonuza kopyalayın',
    'recovery_help_intro' => 'Bunlar sizin kurtarma kodlarınız:',
    'recovery_help_information' => 'Her kurtarma kodunu bir kez kullanabilirsiniz.',
    'recovery_clipboard' => 'Codes copied to the clipboard.',
    'recovery_generate' => 'Generate new codes…',
    'recovery_generate_help' => 'Generating new codes will invalidate previously generated codes.',
    'recovery_already_used_help' => 'This code has already been used.',

    'users_list_title' => 'Hesabınıza erişim hakkı olan kullanıcılar',
    'users_list_add_user' => 'Yeni kullanıcı davet et',
    'users_list_you' => 'Sizin Listeniz',
    'users_list_invitations_title' => 'Bekleyen davetler',
    'users_list_invitations_explanation' => 'Birlikte çalışmak için Monica\'ya katılmaya davet ettiğiniz kişiler aşağıdadır.',
    'users_list_invitations_invited_by' => 'davet eden :name',
    'users_list_invitations_sent_date' => ':date tarihinde gönderildi',
    'users_blank_title' => 'Bu hesaba erişim sağlayan tek kişi sensin.',
    'users_blank_add_title' => 'Birini davet etmek ister misin?',
    'users_blank_description' => 'Bu kullanıcı senin sahil olduğun erişime sahip olacak, ve kişi bilgilerini ekleme, düzenleme veya silme yetkisine sahip olacak.',
    'users_blank_cta' => 'Birini davet et',
    'users_add_title' => 'Invite a new user to your account by email',
    'users_add_description' => 'This person will have the same access as you do, including inviting or deleting other users, including you. Make sure you trust this person before giving them access.',
    'users_add_email_field' => 'Davet etmek istediğiniz kişinin e-posta adresini girin',
    'users_add_confirmation' => 'I confirm that I want to invite this user to my account. I understand that this person will have access to ALL of my data and see exactly what I see.',
    'users_add_cta' => 'E-postayla kullanıcı davet et',
    'users_accept_title' => 'Daveti kabul et ve yeni bir hesap oluştur',
    'users_error_please_confirm' => 'Lütfen davet işlemine devam etmeden önce bu kullanıcıyı davet etmek istediğinizi onaylayın',
    'users_error_email_already_taken' => 'Bu e-posta adresi zaten alınmış. Lütfen başka bir tane seçin',
    'users_error_already_invited' => 'Bu kullanıcıyı zaten davet ettiniz. Lütfen başka bir e-posta adresi seçin.',
    'users_error_email_not_similar' => 'Bu, sizi davet eden kişinin e-posta adresi değil.',
    'users_invitation_deleted_confirmation_message' => 'Davet başarıyla silindi',
    'users_invitations_delete_confirmation' => 'Bu daveti silmek istediğinizden emin misiniz?',
    'users_list_delete_confirmation' => 'Bu kullanıcıyı hesabınızdan silmek istediğinizden emin misiniz?',
    'users_invitation_need_subscription' => 'Daha fazla kullanıcı eklemek için abonelik gerekmektedir.',

    'subscriptions_account_current_plan' => 'Geçerli planınız',
    'subscriptions_account_current_legacy' => 'Current plan, not selectable anymore:',
    'subscriptions_account_current_paid_plan' => ':name planındasınız. Abone olduğunuz için çok teşekkürler.',

    'subscriptions_account_next_billing_title' => 'Next bill',
    'subscriptions_account_next_billing' => 'Aboneliğiniz <strong>:date</strong> tarihinde otomatik olarak yenilenecektir.',
    'subscriptions_account_bill_monthly' => 'We’ll bill you <strong>:price</strong> for another <strong>month</strong>.',
    'subscriptions_account_bill_annual' => 'We’ll bill you <strong>:price</strong> for another <strong>year</strong>.',
    'subscriptions_account_change' => 'Change plan',

    'subscriptions_account_cancel_title' => 'Cancel subscription',
    'subscriptions_account_cancel_action' => 'Cancel subscription',
    'subscriptions_account_cancel' => 'İstediğiniz zaman <a href=":url">aboneliğinizi iptal edebilirsiniz</a>.',
    'subscriptions_account_free_plan' => 'Ücretsiz plandasınız.',
    'subscriptions_account_free_plan_upgrade' => 'Hesabınızı :name planına yükseltebilirsiniz, aylık $:price mal olacaktır. Avantajları şunlardır:',
    'subscriptions_account_free_plan_benefits_users' => 'Sınırsız sayıda kullanıcı',
    'subscriptions_account_free_plan_benefits_reminders' => 'E-posta yoluyla hatırlatmalar',
    'subscriptions_account_free_plan_benefits_import_data_vcard' => 'Kişilerinizi vCard ile içe aktarın',
    'subscriptions_account_free_plan_benefits_support' => 'Support the project in the long run, so we can introduce more great features.',
    'subscriptions_account_upgrade' => 'Hesabınızı yükseltin',
    'subscriptions_account_upgrade_title' => 'Monica\'yı bugün yükseltin ve daha anlamlı ilişkilere sahip olun.',
    'subscriptions_account_upgrade_choice' => 'Aşağıdaki planlardan birini seçin ve Monica\'larını yükselten :customers üzerinde kişinin arasına katılın.',
    'subscriptions_account_update_title' => 'Update Monica subscription',
    'subscriptions_account_update_description' => 'You can change your subscription’s frequency here.',
    'subscriptions_account_update_information' => 'You will be billed immediately for the new amount. Your subscription will extend to the new period, depending on your choice.',
    'subscriptions_account_invoices' => 'Faturalar',
    'subscriptions_account_invoices_download' => 'İndir',
    'subscriptions_account_invoices_subscription' => ':startDate ile :endDate arasında abonelik',
    'subscriptions_account_payment' => 'Size en uygun ödeme seçeneği hangisi?',
    'subscriptions_account_confirm_payment' => 'Ödemeniz şu anda tamamlanmamış durumda, lütfen <a href=":url">ödemenizi doğrulayın</a>.',
    'subscriptions_downgrade_title' => 'Hesabınızı ücretsiz plana düşürün',
    'subscriptions_downgrade_limitations' => 'Ücretsiz planın limitleri vardır. Paketi düşürebilmek için aşağıdaki kontrol listesini onaylanman gerekiyor:',
    'subscriptions_downgrade_rule_users' => 'Hesabında sadece 1 kişi bulundurmalısın',
    'subscriptions_downgrade_rule_users_constraint' => 'Şu an hesabında <a href=":url">1 kişi</a> var.|Şu an hesabında <a href=":url">:count kişi</a> var.',
    'subscriptions_downgrade_rule_invitations' => 'You must not have any pending invitations',
    'subscriptions_downgrade_rule_invitations_constraint' => 'You currently have <a href=":url">1 pending invitation</a>.|You currently have <a href=":url">:count pending invitations</a>.',
    'subscriptions_downgrade_rule_contacts' => ':number adetten fazla aktif kişiye sahip olmamalısınız',
    'subscriptions_downgrade_rule_contacts_constraint' => 'Şu anda <a href=":url">:count adet kişiniz</a> bulunmaktadır.',
    'subscriptions_downgrade_rule_contacts_archive' => 'We can also <a href=":url">archive all your contacts for you</a> – that would clear this rule and let you proceed with your account’s downgrade process.',
    'subscriptions_downgrade_cta' => 'Düşür',
    'subscriptions_downgrade_success' => 'Ücretsiz plana geri döndün!',
    'subscriptions_downgrade_thanks' => 'Thanks so much for trying the paid plan. We keep adding new features on Monica all the time – so you might want to come back in the future to see if you might be interested in taking a subscription again.',
    'subscriptions_back' => 'Ayarlara geri dön',
    'subscriptions_upgrade_title' => 'Hesabınızı yükseltin',
    'subscriptions_upgrade_choose' => ':plan planını seçtin.',
    'subscriptions_upgrade_infos' => 'Daha mutlu olamazdık. Ödeme bilgilerinizi aşağıya girin.',
    'subscriptions_upgrade_name' => 'Kart üzerindeki isim',
    'subscriptions_upgrade_zip' => 'Posta Kodu',
    'subscriptions_upgrade_credit' => 'Kredi kartı veya banka kartı',
    'subscriptions_upgrade_submit' => '{amount} öde',
    'subscriptions_upgrade_charge' => 'We’ll charge your card :price now. The next charge will be on :date. If you ever change your mind, you can cancel at any time, no questions asked.',
    'subscriptions_upgrade_charge_handled' => 'Ödeme <a href=":url">Stripe</a> tarafından gerçekleştirilmektedir. Hiçbir kart bilgisi sunucumuza ulaşmamaktadır.',
    'subscriptions_upgrade_success' => 'Teşekkürler! Artık bir abonesin.',
    'subscriptions_upgrade_thanks' => 'Dünyayı daha iyi bir yer yapmaya çalışan insanların topluluğuna hoş geldiniz.',

    'subscriptions_payment_confirm_title' => ':amount miktarındaki ödemenizi onaylayın',
    'subscriptions_payment_confirm_information' => 'Ödemenizi işleme koymak için ek onay gerekmektedir. Lütfen aşağıda ödeme ayrıntılarınızı doldurarak ödemenizi onaylayın.',
    'subscriptions_payment_succeeded_title' => 'Ödeme Başarılı',
    'subscriptions_payment_succeeded' => 'Bu ödeme zaten başarıyla onaylandı.',
    'subscriptions_payment_cancelled_title' => 'Ödeme İptal Edildi',
    'subscriptions_payment_cancelled' => 'Bu ödeme iptal edildi.',
    'subscriptions_payment_error_name' => 'Lütfen isminizi girin.',
    'subscriptions_payment_success' => 'Ödeme başarılı oldu.',

    'subscriptions_pdf_title' => ':name aylık aboneliğiniz',
    'subscriptions_plan_frequency_year' => ':amount / year',
    'subscriptions_plan_frequency_month' => ':amount / month',
    'subscriptions_plan_choose' => 'Bu planı seç',
    'subscriptions_plan_year_title' => 'Yıllık ödeme',
    'subscriptions_plan_year_bonus' => 'Bir yıl boyunca gönül rahatlığı',
    'subscriptions_plan_month_title' => 'Aylık ödeme',
    'subscriptions_plan_month_bonus' => 'İstediğin zaman iptal et',
    'subscriptions_plan_include1' => 'Yükseltmen ile birlikte gelen ayrıcalıklar:',
    'subscriptions_plan_include2' => 'Sınırsız sayıda kişiler • Sınırsız sayıda kullanıcı • E-postayla bilgilendirme • vCard ile içe aktarım • Kişiler sayfasını kişiselleştirebilme',
    'subscriptions_plan_include3' => 'Kârların %100\'ü bu harika açık kaynaklı projenin geliştirilmesine gidiyor.',
    'subscriptions_help_title' => 'Merak edebileceğin bazı ek detaylar',
    'subscriptions_help_opensource_title' => 'Açık kaynaklı proje de nedir?',
    'subscriptions_help_opensource_desc' => 'Monica is an open source project.  This means it is built by a community who wants to build a great tool for the greater good. Being open source means the code is publicly available on GitHub, and everyone can inspect it, modify it or enhance it. All the money we raise is dedicated to building better features, paying for more powerful servers, and paying other costs. Thanks for your help. We couldn’t do it without you.',
    'subscriptions_help_limits_title' => 'Is there a limit to the number of contacts we can have on the free plan?',
    'subscriptions_help_limits_plan' => 'Evet. Ücretsiz plan :number adet kişiyi yönetmenize izin vermektedir.',
    'subscriptions_help_discounts_title' => 'Kâr amacı gütmeyen kurumlara ve eğitim hizmetlerine indiriminiz var mı?',
    'subscriptions_help_discounts_desc' => 'Evet var! Monica öğrencilere ve kâr amacı gütmeyen kuruluşlara ücretsizdir. Sadece durumunuz ile ilgili bir kanıt ile birlikte <a href=":support">destek</a> ile iletişime geçin ve hesabınıza bu özel duruma uygun hale getirelim.',
    'subscriptions_help_change_title' => 'Ya fikrimi değiştirirsem?',
    'subscriptions_help_change_desc' => 'You can cancel anytime, no questions asked, and all by yourself – no need to contact support. However, you will not be refunded for the current period.',

    'stripe_error_card' => 'Kartın reddedildi. Reddedilme mesajı: :message',
    'stripe_error_api_connection' => 'Stripe ile ağ iletişimi başarısız oldu. Daha sonra tekrar deneyin.',
    'stripe_error_rate_limit' => 'Şu anda Stripe için çok fazla istek var. Daha sonra tekrar deneyin.',
    'stripe_error_invalid_request' => 'Parametreler geçersiz. Daha sonra tekrar deneyin.',
    'stripe_error_authentication' => 'Stripe ile yanlış kimlik doğrulaması',

    'import_title' => 'Hesabınızdaki kişileri içe aktarın',
    'import_cta' => 'Kişileri karşıya yükle',
    'import_stat' => 'Şimdiye kadar :number dosyayı içe aktardınız.',
    'import_result_stat' => 'vCard :total_contacts kişi ile karşıya yüklendi (:total_imported içe aktarıldı, :total_skipped atlandı)',
    'import_view_report' => 'Raporu görüntüle',
    'import_in_progress' => 'İçe aktarma devam ediyor. Sayfayı bir dakika içinde yeniden yükleyin.',
    'import_upload_title' => 'Kişilerinizi bir vCard dosyasından içe aktarın',
    'import_upload_rules_desc' => 'Ancak bazı kurallarımız var:',
    'import_upload_rule_format' => '<code>.vcard</code> ve <code>.vcf</code> dosyalarını destekliyoruz.',
    'import_upload_rule_vcard' => 'We support the vCard 3.0 format, which is the default format for macOS’s Contacts.app and Google Contacts.',
    'import_upload_rule_instructions' => 'Export instructions for <a href=":url1" target="_blank" rel="noopener noreferrer">macOS Contacts.app</a> and <a href=":url2" target="_blank" rel="noopener noreferrer">Google Contacts</a>.',
    'import_upload_rule_multiple' => 'If your contacts have multiple email addresses or phone numbers, only the first entry will be saved.',
    'import_upload_rule_limit' => 'Files are limited to 10 MB.',
    'import_upload_rule_time' => 'It might take up to a minute to upload the contacts and process them. Please be patient.',
    'import_upload_rule_cant_revert' => 'Please make sure data is accurate before uploading, as you can’t undo the upload.',
    'import_upload_form_file' => '<code>.vcf</code> veya <code>.vCard</code> dosyanız:',
    'import_upload_behaviour' => 'İçe aktarma davranışı:',
    'import_upload_behaviour_add' => 'Add new contacts and skip existing',
    'import_upload_behaviour_replace' => 'Mevcut kişileri değiştir',
    'import_upload_behaviour_help' => 'Replacing will replace all data found in the vCard, but will keep existing contact fields.',
    'import_report_title' => 'İçe aktarma raporu',
    'import_report_date' => 'İçe aktarma tarihi',
    'import_report_type' => 'İçe aktarma türü',
    'import_report_number_contacts' => 'Dosyadaki kişi sayısı',
    'import_report_number_contacts_imported' => 'İçe aktarılan kişi sayısı',
    'import_report_number_contacts_skipped' => 'Atlanan kişi sayısı',
    'import_report_status_imported' => 'İçe aktarıldı',
    'import_report_status_skipped' => 'Atlandı',
    'import_vcard_parse_error' => 'vCard girdisini ayrıştırırken hata',
    'import_vcard_contact_exist' => 'Kişi zaten mevcut',
    'import_vcard_contact_no_firstname' => 'İlk isim yok (zorunlu)',
    'import_vcard_file_not_found' => 'Dosya bulunamadı',
    'import_vcard_unknown_entry' => 'Bilinmeyen kişi adı',
    'import_vcard_file_no_entries' => 'Dosya herhangi bir girdi içermiyor',
    'import_blank_title' => 'Henüz herhangi bir kişiyi içe aktarmadınız.',
    'import_blank_question' => 'Şimdi kişileri içe aktarmak ister misiniz?',
    'import_blank_description' => 'Google Kişiler\'den veya Kişi yöneticinizden alabileceğiniz vCard dosyalarını içe aktarabiliriz.',
    'import_blank_cta' => 'vCard İçe Aktarım',
    'import_need_subscription' => 'Verileri içe aktarmak abonelik gerektirir.',

    'tags_list_title' => 'Etiketler',
    'tags_list_description' => 'Etiketler ayarlayarak kişilerinizi düzenleyebilirsiniz. Etiketler klasörler gibi çalışır, ancak bir kişiye birden fazla etiket ekleyebilirsiniz. Yeni bir etiket eklemek için, kişinin üzerine ekleyin.',
    'tags_list_contact_number' => ':count bağlantı',
    'tags_list_delete_success' => 'Etiket başarıyla silindi',
    'tags_list_delete_confirmation' => 'Etiketi silmek istediğinizden emin misiniz? Bağlantılar silinmeyecek, sadece etiket silinecektir.',
    'tags_blank_title' => 'Etiketler, kişilerinizi sınıflandırmanın harika bir yoludur.',
    'tags_blank_description' => 'Tags work like folders, but you can add more than one tag to a contact. Go to a contact and tag a friend, right below the name. Once a contact is tagged, come back here to manage all the tags in your account.',

    'api_title' => 'API erişimi',
    'api_description' => 'API, Monica’nın verilerini harici bir uygulamadan, örneğin bir mobil uygulama gibi, yönetmek için kullanılabilir.',
    'api_help' => 'API\'yi kullanmak için, bir belirteç zorunludur. Bir kişisel erişim belirteci (Taşıyıcı kimlik doğrulaması) oluşturabilir veya sizin için oluşturması için bir OAuth istemcisine yetki verebilirsiniz. <a href=":url">API dokümantasyonuna</a> bakın.',
    'api_endpoint' => 'Bu Monica örneğinin API uç noktası:',

    'api_personal_access_tokens' => 'Kişisel erişim belirteçleri',
    'api_pao_description' => 'Bu belirteci güvendiğiniz bir kaynağa verdiğinizden emin olun - çünkü tüm verilerinize erişmenize izin verir.',
    'api_token_title' => 'Kişisel Erişim Belirteçleri',
    'api_token_create_new' => 'Yeni Belirteç Oluştur',
    'api_token_not_created' => 'Herhangi bir kişisel erişim belirteci oluşturmadınız.',
    'api_token_name' => 'Belirteç adı',
    'api_token_expire' => '{date} tarihinde süresi doluyor',
    'api_token_delete' => 'Sil',
    'api_token_create' => 'Belirteç Oluştur',
    'api_token_scopes' => 'Kapsamlar',
    'api_token_help' => 'İşte yeni kişisel erişim belirteciniz. Bundan başka gösterilmeyecek, bu yüzden kaybetmeyin! Artık API isteğinde bulunmak için bu belirteci kullanabilirsiniz.',

    'api_oauth_clients' => 'OAuth istemcileriniz',
    'api_oauth_clients_desc' => 'Bu bölüm kendi OAuth istemcilerinizi kaydetmenize izin verir.',
    'api_oauth_clients_desc2' => 'Yeni bir belirteç istemek için bu istemci kimliğini kullanın ve yetkilendirme kodlarını erişim belirteçlerine çevirin. Daha fazla bilgi için <a href="{url}">Laravel Passport dokümantasyonuna</a> bakın.',
    'api_oauth_title' => 'OAuth İstemcileri',
    'api_oauth_create_new' => 'Yeni İstemci Oluştur',
    'api_oauth_edit' => 'İstemci Düzenle',
    'api_oauth_not_created' => 'Herhangi bir OAuth istemcisi oluşturmadınız.',
    'api_oauth_clientid' => 'İstemci Kimliği',
    'api_oauth_name' => 'Ad',
    'api_oauth_name_help' => 'Kullanıcılarınızın tanıyacağı ve güveneceği bir şey.',
    'api_oauth_secret' => 'Gizli',
    'api_oauth_create' => 'İstemci Oluştur',
    'api_oauth_redirecturl' => 'Yönlendirme URL\'si',
    'api_oauth_redirecturl_help' => 'Uygulamanızın yetkilendirme geri çağırma URL\'si.',

    'api_authorized_clients' => 'Yetkilendirilmiş istemcilerin listesi',
    'api_authorized_clients_desc' => 'Bu bölüm, uygulama verilerinize erişmek için yetkilendirdiğiniz tüm istemcileri listeler. Bu yetkilendirmeyi istediğiniz zaman iptal edebilirsiniz.',
    'api_authorized_clients_title' => 'Yetkilendirilmiş Uygulamalar',
    'api_authorized_clients_none' => 'Henüz yetkilendirilmiş bir istemci yok.',
    'api_authorized_clients_name' => 'Ad',
    'api_authorized_clients_scopes' => 'Kapsamlar',

    'personalization_tab_title' => 'Hesabınızı kişiselleştirin',

    'personalization_title' => 'Here you will find different settings to configure your account. These features are intended for “power users” who want maximum control over Monica.',
    'personalization_contact_field_type_title' => 'Kişi alanı türleri',
    'personalization_contact_field_type_add' => 'Yeni alan türü ekle',
    'personalization_contact_field_type_description' => 'You can configure all the different types of contact fields that you can associate to all your contacts. For example, if a new social network appears in the future, you will be able to add this new way of communicating with your contacts right here.',
    'personalization_contact_field_type_table_name' => 'İsim',
    'personalization_contact_field_type_table_protocol' => 'Protokol',
    'personalization_contact_field_type_table_actions' => 'Eylemler',
    'personalization_contact_field_type_modal_title' => 'Yeni bir kişi alanı türü ekle',
    'personalization_contact_field_type_modal_edit_title' => 'Mevcut bir kişi alanı türünü düzenle',
    'personalization_contact_field_type_modal_delete_title' => 'Mevcut bir kişi alanı türünü sil',
    'personalization_contact_field_type_modal_delete_description' => 'Are you sure you want to delete this contact field type? Deleting this type of contact field will delete ALL the data with this type for all of your contacts.',
    'personalization_contact_field_type_modal_name' => 'İsim',
    'personalization_contact_field_type_modal_protocol' => 'Protokol (isteğe bağlı)',
    'personalization_contact_field_type_modal_protocol_help' => 'Her yeni kişi alanı türü tıklanabilir. Bir protokol ayarlanmışsa, ayarlanan eylemi tetiklemek için onu kullanırız.',
    'personalization_contact_field_type_modal_icon' => 'Simge (isteğe bağlı)',
    'personalization_contact_field_type_modal_icon_help' => 'Bir simgeyi bu kişi alanı türüyle ilişkilendirebilirsiniz. Bir Font Awesome simgesine bir referans eklemeniz gerekmektedir.',
    'personalization_contact_field_type_delete_success' => 'The contact field type has been successfully deleted.',
    'personalization_contact_field_type_add_success' => 'Kişi alanı türü başarıyla eklendi.',
    'personalization_contact_field_type_edit_success' => 'Kişi alanı türü başarıyla güncellendi.',

    'personalization_genders_title' => 'Cinsiyet türleri',
    'personalization_genders_add' => 'Yeni cinsiyet türü ekle',
    'personalization_genders_desc' => 'İhtiyacınız olan sayıda cinsiyet tanımlayabilirsiniz. Hesabınızda en az bir cinsiyet türü olmalıdır.',
    'personalization_genders_modal_add' => 'Cinsiyet türü ekle',
    'personalization_genders_modal_edit' => 'Cinsiyet türünü düzenle',
    'personalization_genders_modal_name' => 'İsim',
    'personalization_genders_modal_name_help' => 'İletişim sayfasında gösterilecek olan cinsiyetin ismi.',
    'personalization_genders_modal_sex' => 'Cinsiyet',
    'personalization_genders_modal_sex_help' => 'İlişkileri tanımlamak için ve vCard içe/dışa aktarma işlemi sırasında kullanılır.',
    'personalization_genders_modal_default' => 'Yeni bağlantılar için genel cinsiyeti seçiniz',
    'personalization_genders_modal_delete' => 'Cinsiyet türünü sil',
    'personalization_genders_modal_delete_desc' => 'Are you sure you want to delete the gender “{name}”?',
    'personalization_genders_modal_delete_question' => 'You currently have {count} contact with this gender. If you delete this gender, what gender should this contact have?|You currently have {count} contacts with this gender. If you delete this gender, what gender should these contacts have?',
    'personalization_genders_modal_delete_question_default' => 'This gender is the default one. If you delete this gender, which one will be the new default?',
    'personalization_genders_modal_error' => 'Please choose a gender from the list.',
    'personalization_genders_list_contact_number' => '{count} kişi',
    'personalization_genders_table_name' => 'İsim',
    'personalization_genders_table_sex' => 'Cinsiyet',
    'personalization_genders_table_default' => 'Varsayılan',
    'personalization_genders_default' => 'Varsayılan cinsiyet',
    'personalization_genders_make_default' => 'Varsayılan cinsiyeti değiştir',
    'personalization_genders_select_default' => 'Varsayılan cinsiyeti seç',
    'personalization_genders_m' => 'Erkek',
    'personalization_genders_f' => 'Kadın',
    'personalization_genders_o' => 'Diğer',
    'personalization_genders_u' => 'Bilinmeyen',
    'personalization_genders_n' => 'Hiçbiri veya hiçbirine uygun değil',

    'personalization_reminder_rule_save' => 'Değişiklik kaydedildi',
    'personalization_reminder_rule_title' => 'Hatırlatma kuralları',
    'personalization_reminder_rule_line' => '{count} gün önce',
    'personalization_reminder_rule_desc' => 'For every reminder that you set, Monica can send you an email a number of days before the event happens.  You can adjust these notification settings here. These notifications only apply to monthly and yearly reminders.',

    'personalization_module_save' => 'Değişiklik kaydedildi',
    'personalization_module_title' => 'Özellikler',
    'personalization_module_desc' => 'You may not need all of Monica’s features. Below you can toggle specific features that are used on a contact sheet. This change will affect ALL your contacts. Turning off a feature does not delete any data, it simply hides the feature.',

    'personalisation_paid_upgrade' => 'Bu Ücretli bir abonelik gerektiren premium bir özelliktir. <a href=":url">Ayarlar > Abonelik</a> bölümünü ziyaret ederek hesabınızı yükseltin.',
    'personalisation_paid_upgrade_vue' => 'Bu Ücretli bir abonelik gerektiren premium bir özelliktir. <a href="{url}">Ayarlar > Abonelik</a> bölümünü ziyaret ederek hesabınızı yükseltin.',

    'reminder_time_to_send' => 'Time of the day reminders will be sent',
    'reminder_time_to_send_help' => 'Your next reminder is scheduled to be sent on <span title="{dateTimeUtc}" class="reminder-info">{dateTime}</span>.',

    'personalization_activity_type_category_title' => 'Aktivite türü kategorileri',
    'personalization_activity_type_category_add' => 'Yeni bir aktivite türü kategorisi ekle',
    'personalization_activity_type_category_table_name' => 'Ad',
    'personalization_activity_type_category_description' => 'An activity with one of your contacts can have a type and a category type. Your account comes with a set of predefined category types by default, but you can customize these here.',
    'personalization_activity_type_category_table_actions' => 'Eylemler',
    'personalization_activity_type_category_modal_add' => 'Yeni bir etkinlik türü kategorisi ekle',
    'personalization_activity_type_category_modal_edit' => 'Bir etkinlik türü kategorisini düzenle',
    'personalization_activity_type_category_modal_question' => 'What should we name this new category?',
    'personalization_activity_type_add_button' => 'Yeni bir aktivite türü ekle',
    'personalization_activity_type_modal_add' => 'Yeni bir aktivite türü ekle',
    'personalization_activity_type_modal_question' => 'What should we name this new activity type?',
    'personalization_activity_type_modal_edit' => 'Bir aktivite türünü düzenle',
    'personalization_activity_type_category_modal_delete' => 'Bir aktivite türü kategorisini sil',
    'personalization_activity_type_category_modal_delete_desc' => 'Are you sure you want to delete this category? Deleting it will delete all associated activity types. Activities that belong to this category will not be affected by this deletion.',
    'personalization_activity_type_modal_delete' => 'Bir aktivite türünü sil',
    'personalization_activity_type_modal_delete_desc' => 'Bu aktivite türünü silmek istediğinize emin misiniz? Bu kategoriye ait aktiviteler bu silme işleminden etkilenmeyecektir.',
    'personalization_activity_type_modal_delete_error' => 'Bu aktivite türünü bulamıyoruz.',
    'personalization_activity_type_category_modal_delete_error' => 'Bu aktivite türü kategorisini bulamıyoruz.',

    'personalization_life_event_category_title' => 'Life event categories',
    'personalization_live_event_category_table_name' => 'İsim',
    'personalization_life_event_category_description' => 'A life event can have a type and a category. Your account comes with a set of predefined categories and types by default, but you can customize life event types here.',
    'personalization_live_event_category_table_actions' => 'Eylemler',
    'personalization_life_event_type_add_button' => 'Add a new life event type',
    'personalization_life_event_type_modal_add' => 'Add a new life event type',
    'personalization_life_event_type_modal_question' => 'What should we name this new life event type?',
    'personalization_life_event_type_modal_edit' => 'Edit a life event type',
    'personalization_life_event_type_modal_delete' => 'Delete a life event type',
    'personalization_life_event_type_modal_delete_desc' => 'Are you sure you want to delete this life event type? Life events that belong to this type will be deleted by performing this action.',
    'personalization_life_event_type_modal_delete_error' => 'We can’t find this life event type.',

    'personalization_life_event_category_work_education' => 'İş ve eğitim',
    'personalization_life_event_category_family_relationships' => 'Aile & ilişkiler',
    'personalization_life_event_category_home_living' => 'Ev & yaşam',
    'personalization_life_event_category_travel_experiences' => 'Seyahat & deneyimler',
    'personalization_life_event_category_health_wellness' => 'Sağlık & Fitness',

    'personalization_life_event_type_new_job' => 'Yeni iş',
    'personalization_life_event_type_retirement' => 'Emeklilik',
    'personalization_life_event_type_new_school' => 'Yeni okul',
    'personalization_life_event_type_study_abroad' => 'Yurtdışında Eğitim',
    'personalization_life_event_type_volunteer_work' => 'Gönüllü çalışma',
    'personalization_life_event_type_published_book_or_paper' => 'Kitap ya da makale yayını',
    'personalization_life_event_type_military_service' => 'Askerlik hizmeti',
    'personalization_life_event_type_first_met' => 'İlk buluşma',
    'personalization_life_event_type_new_relationship' => 'Yeni ilişki',
    'personalization_life_event_type_engagement' => 'Nişanlanma',
    'personalization_life_event_type_marriage' => 'Evlilik',
    'personalization_life_event_type_anniversary' => 'Yıldönümü',
    'personalization_life_event_type_expecting_a_baby' => 'Bebek bekleme',
    'personalization_life_event_type_new_child' => 'Yeni çocuk',
    'personalization_life_event_type_new_family_member' => 'Yeni aile üyesi',
    'personalization_life_event_type_new_pet' => 'Yeni evcil hayvan',
    'personalization_life_event_type_end_of_relationship' => 'İlişkiyi sonlandırma',
    'personalization_life_event_type_loss_of_a_loved_one' => 'Sevdiğin birini kaybetme',
    'personalization_life_event_type_moved' => 'Taşındı',
    'personalization_life_event_type_bought_a_home' => 'Ev alma',
    'personalization_life_event_type_home_improvement' => 'Evi geliştirme',
    'personalization_life_event_type_holidays' => 'Tatiller',
    'personalization_life_event_type_new_vehicle' => 'Yeni araç',
    'personalization_life_event_type_new_roommate' => 'Yeni oda arkadaşı',
    'personalization_life_event_type_overcame_an_illness' => 'Bir hastalığı yen',
    'personalization_life_event_type_quit_a_habit' => 'Bir alışkanlığı bırak',
    'personalization_life_event_type_new_eating_habits' => 'Yeni yemek alışkanlıkları',
    'personalization_life_event_type_weight_loss' => 'Kilo verme',
    'personalization_life_event_type_wear_glass_or_contact' => 'Started wearing glasses or contacts',
    'personalization_life_event_type_broken_bone' => 'Broke a bone',
    'personalization_life_event_type_removed_braces' => 'Had braces removed',
    'personalization_life_event_type_surgery' => 'Had surgery',
    'personalization_life_event_type_dentist' => 'Had dental treatment',
    'personalization_life_event_type_new_sport' => 'Started playing a new sport',
    'personalization_life_event_type_new_hobby' => 'Took up a new hobby',
    'personalization_life_event_type_new_instrument' => 'Started learning a new instrument',
    'personalization_life_event_type_new_language' => 'Started learning a new language',
    'personalization_life_event_type_tattoo_or_piercing' => 'Dövme veya piercing',
    'personalization_life_event_type_new_license' => 'Yeni lisans',
    'personalization_life_event_type_travel' => 'Seyahat',
    'personalization_life_event_type_achievement_or_award' => 'Başarılar ya da Ödüller',
    'personalization_life_event_type_changed_beliefs' => 'Değişen inançlar',
    'personalization_life_event_type_first_word' => 'İlk kelime',
    'personalization_life_event_type_first_kiss' => 'İlk öpücük',

    'storage_title' => 'Depolama',
    'storage_account_info' => 'Your account limit is :accountLimit MB. Your current usage is :currentAccountSize MB (about :percentUsage%).',
    'storage_upgrade_notice' => 'Belge ve fotoğraf yükleyebilmek için hesabınızı yükseltin.',
    'storage_description' => 'Burada, kişileriniz hakkında yüklenen tüm dokümanları ve fotoğrafları görebilirsiniz.',

    'dav_title' => 'WebDAV',
    'dav_description' => 'Burada CardDAV ve CalDAV dışa aktarma işlemleri için WebDAV kaynaklarını kullanmak için tüm ayarları bulabilirsiniz.',
    'dav_copy_help' => 'Panoya kopyalayın',
    'dav_clipboard_copied' => 'Değer panonuza kopyalandı',
    'dav_url_base' => 'Tüm CardDAV ve CalDAV kaynakları için temel URL:',
    'dav_connect_help' => 'Telefonunuzda veya bilgisayarınızda kişilerinizi ve/veya takvimlerinizi, bu temel URL ile bağlayabilirsiniz.',
    'dav_connect_help2' => 'Use your login (email) and create an API token as the password to authenticate.',
    'dav_url_carddav' => 'Kişiler kaynağı için CardDAV URL\'si:',
    'dav_url_caldav_birthdays' => 'Doğum günleri kaynağı için CalDAV URL\'si:',
    'dav_url_caldav_tasks' => 'Görevler kaynağı için CalDAV URL\'si:',
    'dav_title_carddav' => 'CardDAV',
    'dav_title_caldav' => 'CalDAV',
    'dav_carddav_export' => 'Tüm kişileri tek bir dosyada dışa aktar',
    'dav_caldav_birthdays_export' => 'Tüm doğum günlerini tek bir dosyada dışa aktar',
    'dav_caldav_tasks_export' => 'Tüm görevleri tek bir dosyada dışa aktar',

    'archive_title' => 'Archive all of the contacts in your account',
    'archive_desc' => 'This will archive all of the contacts in your account.',
    'archive_cta' => 'Archive all of your contacts',

    'logs_title' => 'Everything that has happened to this account',
    'logs_actor' => 'Actor',
    'logs_timestamp' => 'Timestamp',
    'logs_description' => 'Description',
    'logs_subject' => 'Subject',
    'logs_size' => 'Size (Kb)',
    'logs_object' => 'Object',
];
