/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrOffset2Di
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    public XrOffset2Di(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrOffset2Di.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int32_t")
    public int x() {
        return XrOffset2Di.nx(this.address());
    }

    @NativeType(value="int32_t")
    public int y() {
        return XrOffset2Di.ny(this.address());
    }

    public XrOffset2Di x(@NativeType(value="int32_t") int value) {
        XrOffset2Di.nx(this.address(), value);
        return this;
    }

    public XrOffset2Di y(@NativeType(value="int32_t") int value) {
        XrOffset2Di.ny(this.address(), value);
        return this;
    }

    public XrOffset2Di set(int x, int y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public XrOffset2Di set(XrOffset2Di src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrOffset2Di malloc() {
        return (XrOffset2Di)XrOffset2Di.wrap(XrOffset2Di.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrOffset2Di calloc() {
        return (XrOffset2Di)XrOffset2Di.wrap(XrOffset2Di.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrOffset2Di create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrOffset2Di)XrOffset2Di.wrap(XrOffset2Di.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrOffset2Di create(long address) {
        return (XrOffset2Di)XrOffset2Di.wrap(XrOffset2Di.class, (long)address);
    }

    @Nullable
    public static XrOffset2Di createSafe(long address) {
        return address == 0L ? null : (XrOffset2Di)XrOffset2Di.wrap(XrOffset2Di.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrOffset2Di.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrOffset2Di.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrOffset2Di.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrOffset2Di.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrOffset2Di.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrOffset2Di.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrOffset2Di.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrOffset2Di malloc(MemoryStack stack) {
        return (XrOffset2Di)XrOffset2Di.wrap(XrOffset2Di.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrOffset2Di calloc(MemoryStack stack) {
        return (XrOffset2Di)XrOffset2Di.wrap(XrOffset2Di.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrOffset2Di.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrOffset2Di.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nx(long struct) {
        return UNSAFE.getInt(null, struct + (long)X);
    }

    public static int ny(long struct) {
        return UNSAFE.getInt(null, struct + (long)Y);
    }

    public static void nx(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = XrOffset2Di.__struct((Struct.Member[])new Struct.Member[]{XrOffset2Di.__member((int)4), XrOffset2Di.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrOffset2Di, Buffer>
    implements NativeResource {
        private static final XrOffset2Di ELEMENT_FACTORY = XrOffset2Di.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrOffset2Di getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int32_t")
        public int x() {
            return XrOffset2Di.nx(this.address());
        }

        @NativeType(value="int32_t")
        public int y() {
            return XrOffset2Di.ny(this.address());
        }

        public Buffer x(@NativeType(value="int32_t") int value) {
            XrOffset2Di.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="int32_t") int value) {
            XrOffset2Di.ny(this.address(), value);
            return this;
        }
    }
}

