/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrLoaderInitInfoBaseHeaderKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    public XrLoaderInitInfoBaseHeaderKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrLoaderInitInfoBaseHeaderKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrLoaderInitInfoBaseHeaderKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrLoaderInitInfoBaseHeaderKHR.nnext(this.address());
    }

    public XrLoaderInitInfoBaseHeaderKHR type(@NativeType(value="XrStructureType") int value) {
        XrLoaderInitInfoBaseHeaderKHR.ntype(this.address(), value);
        return this;
    }

    public XrLoaderInitInfoBaseHeaderKHR next(@NativeType(value="void const *") long value) {
        XrLoaderInitInfoBaseHeaderKHR.nnext(this.address(), value);
        return this;
    }

    public XrLoaderInitInfoBaseHeaderKHR set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrLoaderInitInfoBaseHeaderKHR set(XrLoaderInitInfoBaseHeaderKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrLoaderInitInfoBaseHeaderKHR malloc() {
        return (XrLoaderInitInfoBaseHeaderKHR)XrLoaderInitInfoBaseHeaderKHR.wrap(XrLoaderInitInfoBaseHeaderKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrLoaderInitInfoBaseHeaderKHR calloc() {
        return (XrLoaderInitInfoBaseHeaderKHR)XrLoaderInitInfoBaseHeaderKHR.wrap(XrLoaderInitInfoBaseHeaderKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrLoaderInitInfoBaseHeaderKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrLoaderInitInfoBaseHeaderKHR)XrLoaderInitInfoBaseHeaderKHR.wrap(XrLoaderInitInfoBaseHeaderKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrLoaderInitInfoBaseHeaderKHR create(long address) {
        return (XrLoaderInitInfoBaseHeaderKHR)XrLoaderInitInfoBaseHeaderKHR.wrap(XrLoaderInitInfoBaseHeaderKHR.class, (long)address);
    }

    @Nullable
    public static XrLoaderInitInfoBaseHeaderKHR createSafe(long address) {
        return address == 0L ? null : (XrLoaderInitInfoBaseHeaderKHR)XrLoaderInitInfoBaseHeaderKHR.wrap(XrLoaderInitInfoBaseHeaderKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrLoaderInitInfoBaseHeaderKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrLoaderInitInfoBaseHeaderKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrLoaderInitInfoBaseHeaderKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrLoaderInitInfoBaseHeaderKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrLoaderInitInfoBaseHeaderKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrLoaderInitInfoBaseHeaderKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrLoaderInitInfoBaseHeaderKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrLoaderInitInfoBaseHeaderKHR malloc(MemoryStack stack) {
        return (XrLoaderInitInfoBaseHeaderKHR)XrLoaderInitInfoBaseHeaderKHR.wrap(XrLoaderInitInfoBaseHeaderKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrLoaderInitInfoBaseHeaderKHR calloc(MemoryStack stack) {
        return (XrLoaderInitInfoBaseHeaderKHR)XrLoaderInitInfoBaseHeaderKHR.wrap(XrLoaderInitInfoBaseHeaderKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrLoaderInitInfoBaseHeaderKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrLoaderInitInfoBaseHeaderKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrLoaderInitInfoBaseHeaderKHR.__struct((Struct.Member[])new Struct.Member[]{XrLoaderInitInfoBaseHeaderKHR.__member((int)4), XrLoaderInitInfoBaseHeaderKHR.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrLoaderInitInfoBaseHeaderKHR, Buffer>
    implements NativeResource {
        private static final XrLoaderInitInfoBaseHeaderKHR ELEMENT_FACTORY = XrLoaderInitInfoBaseHeaderKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrLoaderInitInfoBaseHeaderKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrLoaderInitInfoBaseHeaderKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrLoaderInitInfoBaseHeaderKHR.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrLoaderInitInfoBaseHeaderKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrLoaderInitInfoBaseHeaderKHR.nnext(this.address(), value);
            return this;
        }
    }
}

