/*
 * Decompiled with CFR 0.152.
 */
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.console.AeshConsole;
import org.jboss.aesh.console.AeshConsoleBuilder;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.console.command.registry.AeshCommandRegistryBuilder;
import org.jboss.aesh.console.command.registry.CommandRegistry;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.console.settings.SettingsBuilder;
import org.jboss.aesh.graphics.AeshGraphicsConfiguration;
import org.jboss.aesh.graphics.Graphics;
import org.jboss.aesh.terminal.Color;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.terminal.TerminalColor;

public class AeshGraphicsExample {
    public static void main(String[] args) {
        SettingsBuilder builder = new SettingsBuilder().logging(true);
        builder.enableMan(true);
        Settings settings = builder.create();
        CommandRegistry registry = new AeshCommandRegistryBuilder().command(ExitCommand.class).command(new GraphicsCommand()).create();
        AeshConsole aeshConsole = new AeshConsoleBuilder().commandRegistry(registry).settings(settings).prompt(new Prompt("[aesh@rules]$ ")).create();
        aeshConsole.start();
    }

    @CommandDefinition(name="gfx", description="")
    public static class GraphicsCommand
    implements Command {
        private CommandInvocation invocation;
        private Graphics g;

        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            this.invocation = commandInvocation;
            this.invocation.getShell().enableAlternateBuffer();
            this.doGfx();
            return CommandResult.SUCCESS;
        }

        public void waitForInput() {
            try {
                while (!this.invocation.getInput().getInputKey().equals((Object)Key.q)) {
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.g != null) {
                this.g.clearAndShowCursor();
            }
            this.invocation.getShell().enableMainBuffer();
        }

        private void doGfx() {
            try {
                AeshGraphicsConfiguration gc = new AeshGraphicsConfiguration(this.invocation.getShell());
                this.g = gc.getGraphics();
                this.g.setColor(new TerminalColor(Color.BLUE, Color.DEFAULT));
                this.g.drawRect(20, 10, 20, 4);
                Thread.sleep(500L);
                this.g.flush();
                this.g.setColor(new TerminalColor(Color.RED, Color.DEFAULT));
                this.g.drawRect(50, 5, 10, 8);
                Thread.sleep(500L);
                this.g.flush();
                this.g.setColor(new TerminalColor(Color.DEFAULT, Color.YELLOW));
                this.g.fillRect(0, 15, 16, 10);
                Thread.sleep(500L);
                this.g.flush();
                this.g.setColor(new TerminalColor(Color.CYAN, Color.DEFAULT));
                this.g.drawString("\u00c6SH", 100, 25);
                this.g.drawString("RULES", 100, 26);
                Thread.sleep(500L);
                this.g.flush();
                this.g.setColor(new TerminalColor(Color.WHITE, Color.WHITE));
                this.g.drawRect(80, 23, 40, 5);
                Thread.sleep(500L);
                this.g.flush();
                this.g.setColor(new TerminalColor(Color.BLUE, Color.DEFAULT));
                this.g.drawCircle(100, 10, 5);
                this.g.flush();
                Thread.sleep(500L);
                this.g.setColor(new TerminalColor(Color.DEFAULT, Color.DEFAULT));
                this.g.drawLine(0, 0, 50, 20);
                this.g.flush();
                Thread.sleep(1500L);
                this.g.setColor(new TerminalColor(Color.DEFAULT, Color.RED));
                int j = 0;
                for (int i = 0; i < 100; ++i) {
                    this.g.clear();
                    this.g.fillRect(i, 15 + j, 20, 8);
                    this.g.flush();
                    Thread.sleep(50L);
                    if (i > 10 && i < 20 || i > 30 && i < 40) {
                        ++j;
                    }
                    if (i >= 10 && (i <= 20 || i >= 30) && (i <= 40 || i >= 50)) continue;
                    --j;
                }
                this.waitForInput();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @CommandDefinition(name="exit", description="exit the program")
    public static class ExitCommand
    implements Command {
        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            commandInvocation.stop();
            return CommandResult.SUCCESS;
        }
    }
}

