/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.component.ComponentModel;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.LDAPServerCapabilitiesManager;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.storage.managers.UserStorageSyncManager;
import org.keycloak.storage.user.SynchronizationResult;

public class UserStorageProviderResource {
    private static final Logger logger = Logger.getLogger(UserStorageProviderResource.class);
    protected final RealmModel realm;
    protected final AdminPermissionEvaluator auth;
    protected final AdminEventBuilder adminEvent;
    protected final ClientConnection clientConnection;
    protected final KeycloakSession session;
    protected final HttpHeaders headers;

    public UserStorageProviderResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.auth = auth;
        this.realm = session.getContext().getRealm();
        this.adminEvent = adminEvent;
        this.clientConnection = session.getContext().getConnection();
        this.headers = session.getContext().getRequestHeaders();
    }

    public static String getErrorCode(Throwable throwable) {
        if (throwable instanceof ModelException && throwable.getCause() != null) {
            return UserStorageProviderResource.getErrorCode(throwable.getCause());
        }
        return LDAPServerCapabilitiesManager.getErrorCode((Throwable)throwable);
    }

    @GET
    @Path(value="{id}/name")
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, String> getSimpleName(@PathParam(value="id") String id) {
        this.auth.users().requireQuery();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        if (!model.getProviderType().equals(UserStorageProvider.class.getName())) {
            throw new NotFoundException("found, but not a UserStorageProvider");
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", model.getId());
        data.put("name", model.getName());
        return data;
    }

    @POST
    @Path(value="{id}/sync")
    @NoCache
    @Produces(value={"application/json"})
    public SynchronizationResult syncUsers(@PathParam(value="id") String id, @QueryParam(value="action") String action) {
        SynchronizationResult syncResult;
        this.auth.users().requireManage();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        if (!model.getProviderType().equals(UserStorageProvider.class.getName())) {
            throw new NotFoundException("found, but not a UserStorageProvider");
        }
        UserStorageProviderModel providerModel = new UserStorageProviderModel(model);
        logger.debug((Object)"Syncing users");
        UserStorageSyncManager syncManager = new UserStorageSyncManager();
        if ("triggerFullSync".equals(action)) {
            try {
                syncResult = UserStorageSyncManager.syncAllUsers((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), (String)this.realm.getId(), (UserStorageProviderModel)providerModel);
            }
            catch (Exception e) {
                String errorMsg = UserStorageProviderResource.getErrorCode(e);
                throw ErrorResponse.error((String)errorMsg, (Response.Status)Response.Status.BAD_REQUEST);
            }
        } else if ("triggerChangedUsersSync".equals(action)) {
            try {
                syncResult = UserStorageSyncManager.syncChangedUsers((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), (String)this.realm.getId(), (UserStorageProviderModel)providerModel);
            }
            catch (Exception e) {
                String errorMsg = UserStorageProviderResource.getErrorCode(e);
                throw ErrorResponse.error((String)errorMsg, (Response.Status)Response.Status.BAD_REQUEST);
            }
        } else {
            if (action == null || action == "") {
                logger.debug((Object)"Missing action");
                throw new BadRequestException("Missing action");
            }
            logger.debug((Object)("Unknown action: " + action));
            throw new BadRequestException("Unknown action: " + action);
        }
        HashMap<String, String> eventRep = new HashMap<String, String>();
        eventRep.put("action", action);
        eventRep.put("result", (String)syncResult);
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(eventRep).success();
        return syncResult;
    }

    @POST
    @Path(value="{id}/remove-imported-users")
    @NoCache
    public void removeImportedUsers(@PathParam(value="id") String id) {
        this.auth.users().requireManage();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        if (!model.getProviderType().equals(UserStorageProvider.class.getName())) {
            throw new NotFoundException("found, but not a UserStorageProvider");
        }
        this.session.users().removeImportedUsers(this.realm, id);
    }

    @POST
    @Path(value="{id}/unlink-users")
    @NoCache
    public void unlinkUsers(@PathParam(value="id") String id) {
        this.auth.users().requireManage();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        if (!model.getProviderType().equals(UserStorageProvider.class.getName())) {
            throw new NotFoundException("found, but not a UserStorageProvider");
        }
        this.session.users().unlinkUsers(this.realm, id);
    }

    @POST
    @Path(value="{parentId}/mappers/{id}/sync")
    @NoCache
    @Produces(value={"application/json"})
    public SynchronizationResult syncMapperData(@PathParam(value="parentId") String parentId, @PathParam(value="id") String mapperId, @QueryParam(value="direction") String direction) {
        SynchronizationResult syncResult;
        this.auth.users().requireManage();
        ComponentModel parentModel = this.realm.getComponent(parentId);
        if (parentModel == null) {
            throw new NotFoundException("Parent model not found");
        }
        ComponentModel mapperModel = this.realm.getComponent(mapperId);
        if (mapperModel == null) {
            throw new NotFoundException("Mapper model not found");
        }
        LDAPStorageProvider ldapProvider = (LDAPStorageProvider)this.session.getProvider(UserStorageProvider.class, parentModel);
        LDAPStorageMapper mapper = (LDAPStorageMapper)this.session.getProvider(LDAPStorageMapper.class, mapperModel);
        ServicesLogger.LOGGER.syncingDataForMapper(mapperModel.getName(), mapperModel.getProviderId(), direction);
        if ("fedToKeycloak".equals(direction)) {
            syncResult = mapper.syncDataFromFederationProviderToKeycloak(this.realm);
        } else if ("keycloakToFed".equals(direction)) {
            syncResult = mapper.syncDataFromKeycloakToFederationProvider(this.realm);
        } else {
            throw new BadRequestException("Unknown direction: " + direction);
        }
        HashMap<String, String> eventRep = new HashMap<String, String>();
        eventRep.put("action", direction);
        eventRep.put("result", (String)syncResult);
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(eventRep).success();
        return syncResult;
    }
}

