/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.executors.CachedThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.CachedThreadPoolConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ScheduledThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadPoolBuilderAdapter;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.factories.threads.DefaultThreadFactory;

public class CachedThreadPoolConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<CachedThreadPoolConfiguration>,
ThreadPoolBuilderAdapter {
    private final AttributeSet attributes = CachedThreadPoolConfiguration.attributeDefinitionSet();

    CachedThreadPoolConfigurationBuilder(GlobalConfigurationBuilder globalConfig, String name) {
        super(globalConfig);
        this.attributes.attribute(CachedThreadPoolConfiguration.NAME).set((Object)name);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public CachedThreadPoolConfigurationBuilder name(String name) {
        this.attributes.attribute(CachedThreadPoolConfiguration.NAME).set((Object)name);
        return this;
    }

    public CachedThreadPoolConfigurationBuilder threadFactory(String threadFactory) {
        this.attributes.attribute(CachedThreadPoolConfiguration.THREAD_FACTORY).set((Object)threadFactory);
        return this;
    }

    public String name() {
        return (String)this.attributes.attribute(CachedThreadPoolConfiguration.NAME).get();
    }

    public CachedThreadPoolConfiguration create() {
        return new CachedThreadPoolConfiguration(this.attributes.protect());
    }

    public CachedThreadPoolConfigurationBuilder read(CachedThreadPoolConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public String toString() {
        return "CachedThreadPoolConfigurationBuilder{attributes=" + this.attributes + "}";
    }

    @Override
    public ThreadPoolConfiguration asThreadPoolConfigurationBuilder() {
        ThreadPoolConfigurationBuilder builder = new ThreadPoolConfigurationBuilder(this.getGlobalConfig());
        builder.threadPoolFactory((ThreadPoolExecutorFactory)CachedThreadPoolExecutorFactory.create());
        DefaultThreadFactory threadFactory = this.getGlobalConfig().threads().getThreadFactory(this.threadFactory()).create().getThreadFactory(false);
        builder.threadFactory(threadFactory);
        builder.name(this.name());
        return builder.create();
    }

    public String threadFactory() {
        return (String)this.attributes.attribute(ScheduledThreadPoolConfiguration.THREAD_FACTORY).get();
    }
}

