/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.RecoveryConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.infinispan.util.logging.Log;

public class TransactionConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<TransactionConfiguration> {
    final AttributeSet attributes = TransactionConfiguration.attributeDefinitionSet();
    private final RecoveryConfigurationBuilder recovery = new RecoveryConfigurationBuilder(this);

    TransactionConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public TransactionConfigurationBuilder autoCommit(boolean b) {
        this.attributes.attribute(TransactionConfiguration.AUTO_COMMIT).set((Object)b);
        return this;
    }

    public TransactionConfigurationBuilder cacheStopTimeout(long l) {
        this.attributes.attribute(TransactionConfiguration.CACHE_STOP_TIMEOUT).set((Object)l);
        return this;
    }

    public TransactionConfigurationBuilder cacheStopTimeout(long l, TimeUnit unit) {
        return this.cacheStopTimeout(unit.toMillis(l));
    }

    public TransactionConfigurationBuilder lockingMode(LockingMode lockingMode) {
        this.attributes.attribute(TransactionConfiguration.LOCKING_MODE).set((Object)lockingMode);
        return this;
    }

    LockingMode lockingMode() {
        return (LockingMode)((Object)this.attributes.attribute(TransactionConfiguration.LOCKING_MODE).get());
    }

    public TransactionConfigurationBuilder transactionManagerLookup(TransactionManagerLookup tml) {
        this.attributes.attribute(TransactionConfiguration.TRANSACTION_MANAGER_LOOKUP).set((Object)tml);
        if (tml != null) {
            this.transactionMode(TransactionMode.TRANSACTIONAL);
        }
        return this;
    }

    public TransactionManagerLookup transactionManagerLookup() {
        return (TransactionManagerLookup)this.attributes.attribute(TransactionConfiguration.TRANSACTION_MANAGER_LOOKUP).get();
    }

    public TransactionConfigurationBuilder transactionSynchronizationRegistryLookup(TransactionSynchronizationRegistryLookup lookup) {
        this.attributes.attribute(TransactionConfiguration.TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP).set((Object)lookup);
        return this;
    }

    public TransactionConfigurationBuilder transactionMode(TransactionMode transactionMode) {
        this.attributes.attribute(TransactionConfiguration.TRANSACTION_MODE).set((Object)transactionMode);
        return this;
    }

    public TransactionMode transactionMode() {
        return (TransactionMode)((Object)this.attributes.attribute(TransactionConfiguration.TRANSACTION_MODE).get());
    }

    public TransactionConfigurationBuilder useSynchronization(boolean b) {
        this.attributes.attribute(TransactionConfiguration.USE_SYNCHRONIZATION).set((Object)b);
        return this;
    }

    boolean useSynchronization() {
        return (Boolean)this.attributes.attribute(TransactionConfiguration.USE_SYNCHRONIZATION).get();
    }

    public RecoveryConfigurationBuilder recovery() {
        return this.recovery;
    }

    public TransactionConfigurationBuilder use1PcForAutoCommitTransactions(boolean b) {
        this.attributes.attribute(TransactionConfiguration.USE_1_PC_FOR_AUTO_COMMIT_TRANSACTIONS).set((Object)b);
        return this;
    }

    public boolean use1PcForAutoCommitTransactions() {
        return (Boolean)this.attributes.attribute(TransactionConfiguration.USE_1_PC_FOR_AUTO_COMMIT_TRANSACTIONS).get();
    }

    public TransactionConfigurationBuilder reaperWakeUpInterval(long interval) {
        this.attributes.attribute(TransactionConfiguration.REAPER_WAKE_UP_INTERVAL).set((Object)interval);
        return this;
    }

    public TransactionConfigurationBuilder completedTxTimeout(long timeout) {
        this.attributes.attribute(TransactionConfiguration.COMPLETED_TX_TIMEOUT).set((Object)timeout);
        return this;
    }

    public TransactionConfigurationBuilder notifications(boolean enabled) {
        this.attributes.attribute(TransactionConfiguration.NOTIFICATIONS).set((Object)enabled);
        return this;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public void validate() {
        Attribute reaperWakeUpInterval = this.attributes.attribute(TransactionConfiguration.REAPER_WAKE_UP_INTERVAL);
        Attribute completedTxTimeout = this.attributes.attribute(TransactionConfiguration.COMPLETED_TX_TIMEOUT);
        if ((Long)reaperWakeUpInterval.get() < 0L) {
            throw Log.CONFIG.invalidReaperWakeUpInterval((Long)reaperWakeUpInterval.get());
        }
        if ((Long)completedTxTimeout.get() < 0L) {
            throw Log.CONFIG.invalidCompletedTxTimeout((Long)completedTxTimeout.get());
        }
        CacheMode cacheMode = this.clustering().cacheMode();
        if (!((Boolean)this.attributes.attribute(TransactionConfiguration.NOTIFICATIONS).get()).booleanValue() && !this.getBuilder().template()) {
            Log.CONFIG.transactionNotificationsDisabled();
        }
        if (((TransactionMode)((Object)this.attributes.attribute(TransactionConfiguration.TRANSACTION_MODE).get())).isTransactional() && !cacheMode.isSynchronous()) {
            throw Log.CONFIG.unsupportedAsyncCacheMode(cacheMode);
        }
        this.recovery.validate();
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        this.recovery.validate(globalConfig);
    }

    public TransactionConfiguration create() {
        boolean invocationBatching = this.builder.invocationBatching().isEnabled();
        return new TransactionConfiguration(this.attributes.protect(), this.recovery.create(), invocationBatching);
    }

    public TransactionConfigurationBuilder read(TransactionConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.recovery.read(template.recovery(), combine);
        return this;
    }

    public String toString() {
        return "TransactionConfigurationBuilder [attributes=" + this.attributes + ", recovery=" + this.recovery + "]";
    }
}

