/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.spies;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.spies.UniSpyBase;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.tuples.Tuple3;

public class UniOnTerminationSpy<T>
extends UniSpyBase<T> {
    private volatile Tuple3<T, Throwable, Boolean> lastTermination;

    UniOnTerminationSpy(Uni<T> upstream) {
        super(upstream);
    }

    public T lastTerminationItem() throws IllegalStateException {
        return this.lastTermination == null ? null : (T)this.lastTermination.getItem1();
    }

    public Throwable lastTerminationFailure() throws IllegalStateException {
        return this.lastTermination == null ? null : (Throwable)this.lastTermination.getItem2();
    }

    public boolean lastTerminationWasCancelled() throws IllegalStateException {
        return this.lastTermination != null && this.lastTermination.getItem3() != false;
    }

    @Override
    public void reset() {
        super.reset();
        this.lastTermination = null;
    }

    @Override
    public void subscribe(UniSubscriber<? super T> downstream) {
        this.upstream().onTermination().invoke((T i, Throwable f, Boolean c) -> {
            this.incrementInvocationCount();
            this.lastTermination = Tuple3.of(i, f, c);
        }).subscribe().withSubscriber(downstream);
    }

    @Override
    public String toString() {
        return "UniOnTerminationSpy{lastTermination=" + this.lastTermination + "} " + super.toString();
    }
}

