/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.command.AbstractStartCommand;
import org.keycloak.quarkus.runtime.cli.command.HelpAllMixin;
import org.keycloak.quarkus.runtime.cli.command.ImportRealmMixin;
import picocli.CommandLine;

@CommandLine.Command(name="start-dev", header={"Start the server in development mode."}, description={"%nUse this command if you want to run the server locally for development or testing purposes."}, footer={"%nDo NOT start the server using this command when deploying to production.%n%nUse '${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --help-all' to list all available options, including build options."})
public final class StartDev
extends AbstractStartCommand
implements Runnable {
    public static final String NAME = "start-dev";
    @CommandLine.Option(names={"--auto-build"}, hidden=true)
    Boolean autoConfig;
    @CommandLine.Mixin
    HelpAllMixin helpAllMixin;
    @CommandLine.Mixin
    ImportRealmMixin importRealmMixin;

    @Override
    protected void doBeforeRun() {
        Environment.forceDevProfile();
    }

    @Override
    public List<OptionCategory> getOptionCategories() {
        return super.getOptionCategories().stream().filter(optionCategory -> optionCategory != OptionCategory.EXPORT && optionCategory != OptionCategory.IMPORT).collect(Collectors.toList());
    }

    @Override
    public boolean includeRuntime() {
        return true;
    }
}

