/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.locking;

import java.time.Duration;
import java.util.Objects;
import org.infinispan.client.hotrod.RemoteCache;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTaskWithResult;
import org.keycloak.models.locking.GlobalLockProvider;
import org.keycloak.models.locking.LockAcquiringTimeoutException;
import org.keycloak.models.map.storage.hotRod.locking.HotRodLocksUtils;
import org.keycloak.models.utils.KeycloakModelUtils;

public class HotRodGlobalLockProvider
implements GlobalLockProvider {
    private static final Logger LOG = Logger.getLogger(HotRodGlobalLockProvider.class);
    private final KeycloakSession session;
    private final RemoteCache<String, String> locksCache;
    private final long defaultTimeoutMilliseconds;

    public HotRodGlobalLockProvider(KeycloakSession session, RemoteCache<String, String> locksCache, long defaultTimeoutMilliseconds) {
        this.locksCache = locksCache;
        this.defaultTimeoutMilliseconds = defaultTimeoutMilliseconds;
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V withLock(String lockName, Duration timeToWaitForLock, KeycloakSessionTaskWithResult<V> task) throws LockAcquiringTimeoutException {
        Objects.requireNonNull(lockName, "lockName cannot be null");
        if (timeToWaitForLock == null) {
            timeToWaitForLock = Duration.ofMillis(this.defaultTimeoutMilliseconds);
        }
        try {
            LOG.debugf("Acquiring lock [%s].%s", (Object)lockName, StackUtil.getShortStackTrace());
            HotRodLocksUtils.repeatPutIfAbsent(this.locksCache, lockName, timeToWaitForLock, 50, false);
            LOG.debugf("Lock acquired [%s]. Continuing with task execution.", (Object)lockName);
            Object object = KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), task);
            return (V)object;
        }
        finally {
            LOG.debugf("Releasing lock [%s].%s", (Object)lockName, StackUtil.getShortStackTrace());
            boolean result = HotRodLocksUtils.removeWithInstanceIdentifier(this.locksCache, lockName);
            LOG.debugf("Lock [%s] release resulted with %s", (Object)lockName, (Object)result);
        }
    }

    public void forceReleaseAllLocks() {
        this.locksCache.clear();
    }

    public void close() {
    }
}

