/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.exception.RollbackFailedException;
import liquibase.util.StringUtil;

public class AfterTagChangeSetFilter
implements ChangeSetFilter {
    private final String tag;
    private Set<String> changeLogsAfterTag = new HashSet<String>();

    public AfterTagChangeSetFilter(String tag, List<RanChangeSet> ranChangeSets) throws RollbackFailedException {
        this.tag = tag;
        boolean seenTag = false;
        for (RanChangeSet ranChangeSet : ranChangeSets) {
            if (seenTag && !tag.equalsIgnoreCase(ranChangeSet.getTag())) {
                this.changeLogsAfterTag.add(ranChangeSet.toString());
            }
            if (seenTag || !tag.equalsIgnoreCase(ranChangeSet.getTag())) continue;
            seenTag = true;
            if (!"tagDatabase".equals(StringUtil.trimToEmpty(ranChangeSet.getDescription()))) continue;
            this.changeLogsAfterTag.add(ranChangeSet.toString());
        }
        if (!seenTag) {
            throw new RollbackFailedException("Could not find tag '" + tag + "' in the database");
        }
    }

    @Override
    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        if (this.changeLogsAfterTag.contains(changeSet.toString())) {
            return new ChangeSetFilterResult(true, "Changeset is before tag '" + this.tag + "'", this.getClass());
        }
        return new ChangeSetFilterResult(false, "Changeset after tag '" + this.tag + "'", this.getClass());
    }
}

