/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.impl.neomedia.codec.video.h264;

import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi_modified.impl.neomedia.codec.video.h264.H264;

public class DePacketizer {
    private static final Logger logger = new LoggerImpl(DePacketizer.class.toString());

    public static boolean isKeyFrame(byte[] buf, int off, int len) {
        if (buf == null || buf.length < off + Math.max(len, 1)) {
            return false;
        }
        int nalType = buf[off] & 0x1F;
        return nalType == 28 ? DePacketizer.parseFuaNaluForKeyFrame(buf, off, len) : DePacketizer.parseSingleNaluForKeyFrame(buf, off, len);
    }

    private static boolean parseFuaNaluForKeyFrame(byte[] buf, int off, int len) {
        if (len < 2) {
            return false;
        }
        return (buf[off + 1] & 0x1F) == 5;
    }

    private static boolean parseSingleNaluForKeyFrame(byte[] buf, int off, int len) {
        int naluStart = off + 1;
        int naluLength = len - 1;
        int nalType = buf[off] & 0x1F;
        if (nalType == 24) {
            if (len <= 3) {
                logger.error("StapA header truncated.");
                return false;
            }
            if (!H264.verifyStapANaluLengths(buf, naluStart, naluLength)) {
                logger.error("StapA packet with incorrect NALU packet lengths.");
                return false;
            }
            nalType = buf[off + 3] & 0x1F;
        }
        return nalType == 5 || nalType == 7 || nalType == 8 || nalType == 6;
    }
}

