/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketHandler;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.NodeStatsProducer;
import org.jitsi.nlj.util.NodeStatsBlockExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH$J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/nlj/StatsKeepingPacketHandler;", "Lorg/jitsi/nlj/PacketHandler;", "Lorg/jitsi/nlj/transform/NodeStatsProducer;", "()V", "statistics", "Lorg/jitsi/nlj/StatsKeepingPacketHandler$Statistics;", "doProcessPacket", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "processPacket", "Statistics", "jitsi-media-transform"})
public abstract class StatsKeepingPacketHandler
implements PacketHandler,
NodeStatsProducer {
    @NotNull
    private final Statistics statistics = new Statistics(0L, 0L, 0L, 0L, 15, null);

    @Override
    public final void processPacket(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        long now = System.currentTimeMillis();
        Statistics statistics = this.statistics;
        long l = statistics.getPacketsReceived();
        statistics.setPacketsReceived(l + 1L);
        statistics = this.statistics;
        statistics.setBytesReceived(statistics.getBytesReceived() + (long)packetInfo.getPacket().length);
        if (this.statistics.getFirstPacketReceivedTime() == 0L) {
            this.statistics.setFirstPacketReceivedTime(now);
        }
        this.statistics.setLastPacketReceivedTime(now);
        this.doProcessPacket(packetInfo);
    }

    protected abstract void doProcessPacket(@NotNull PacketInfo var1);

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        return this.statistics.getNodeStats();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\""}, d2={"Lorg/jitsi/nlj/StatsKeepingPacketHandler$Statistics;", "Lorg/jitsi/nlj/transform/NodeStatsProducer;", "firstPacketReceivedTime", "", "lastPacketReceivedTime", "bytesReceived", "packetsReceived", "(JJJJ)V", "getBytesReceived", "()J", "setBytesReceived", "(J)V", "getFirstPacketReceivedTime", "setFirstPacketReceivedTime", "getLastPacketReceivedTime", "setLastPacketReceivedTime", "getPacketsReceived", "setPacketsReceived", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "hashCode", "", "toString", "", "Companion", "jitsi-media-transform"})
    public static final class Statistics
    implements NodeStatsProducer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private long firstPacketReceivedTime;
        private long lastPacketReceivedTime;
        private long bytesReceived;
        private long packetsReceived;
        @NotNull
        private static final String RECEIVED_PACKETS = "received_packets";
        @NotNull
        private static final String RECEIVED_BYTES = "received_bytes";
        @NotNull
        private static final String RECEIVED_DURATION_MS = "received_duration_ms";
        @NotNull
        private static final String RECEIVED_BITRATE_MBPS = "received_bitrate_mbps";

        public Statistics(long firstPacketReceivedTime, long lastPacketReceivedTime, long bytesReceived, long packetsReceived) {
            this.firstPacketReceivedTime = firstPacketReceivedTime;
            this.lastPacketReceivedTime = lastPacketReceivedTime;
            this.bytesReceived = bytesReceived;
            this.packetsReceived = packetsReceived;
        }

        public /* synthetic */ Statistics(long l, long l2, long l3, long l4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 0L;
            }
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            if ((n & 4) != 0) {
                l3 = 0L;
            }
            if ((n & 8) != 0) {
                l4 = 0L;
            }
            this(l, l2, l3, l4);
        }

        public final long getFirstPacketReceivedTime() {
            return this.firstPacketReceivedTime;
        }

        public final void setFirstPacketReceivedTime(long l) {
            this.firstPacketReceivedTime = l;
        }

        public final long getLastPacketReceivedTime() {
            return this.lastPacketReceivedTime;
        }

        public final void setLastPacketReceivedTime(long l) {
            this.lastPacketReceivedTime = l;
        }

        public final long getBytesReceived() {
            return this.bytesReceived;
        }

        public final void setBytesReceived(long l) {
            this.bytesReceived = l;
        }

        public final long getPacketsReceived() {
            return this.packetsReceived;
        }

        public final void setPacketsReceived(long l) {
            this.packetsReceived = l;
        }

        @Override
        @NotNull
        public NodeStatsBlock getNodeStats() {
            NodeStatsBlock nodeStatsBlock;
            NodeStatsBlock $this$getNodeStats_u24lambda_u2d0 = nodeStatsBlock = new NodeStatsBlock("Packet handler stats");
            boolean bl = false;
            $this$getNodeStats_u24lambda_u2d0.addNumber(RECEIVED_PACKETS, this.packetsReceived);
            $this$getNodeStats_u24lambda_u2d0.addNumber(RECEIVED_BYTES, this.bytesReceived);
            $this$getNodeStats_u24lambda_u2d0.addNumber(RECEIVED_DURATION_MS, this.lastPacketReceivedTime - this.firstPacketReceivedTime);
            NodeStatsBlockExtensionsKt.addMbps($this$getNodeStats_u24lambda_u2d0, RECEIVED_BITRATE_MBPS, RECEIVED_BYTES, RECEIVED_DURATION_MS);
            return nodeStatsBlock;
        }

        public final long component1() {
            return this.firstPacketReceivedTime;
        }

        public final long component2() {
            return this.lastPacketReceivedTime;
        }

        public final long component3() {
            return this.bytesReceived;
        }

        public final long component4() {
            return this.packetsReceived;
        }

        @NotNull
        public final Statistics copy(long firstPacketReceivedTime, long lastPacketReceivedTime, long bytesReceived, long packetsReceived) {
            return new Statistics(firstPacketReceivedTime, lastPacketReceivedTime, bytesReceived, packetsReceived);
        }

        public static /* synthetic */ Statistics copy$default(Statistics statistics, long l, long l2, long l3, long l4, int n, Object object) {
            if ((n & 1) != 0) {
                l = statistics.firstPacketReceivedTime;
            }
            if ((n & 2) != 0) {
                l2 = statistics.lastPacketReceivedTime;
            }
            if ((n & 4) != 0) {
                l3 = statistics.bytesReceived;
            }
            if ((n & 8) != 0) {
                l4 = statistics.packetsReceived;
            }
            return statistics.copy(l, l2, l3, l4);
        }

        @NotNull
        public String toString() {
            return "Statistics(firstPacketReceivedTime=" + this.firstPacketReceivedTime + ", lastPacketReceivedTime=" + this.lastPacketReceivedTime + ", bytesReceived=" + this.bytesReceived + ", packetsReceived=" + this.packetsReceived + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.firstPacketReceivedTime);
            result2 = result2 * 31 + Long.hashCode(this.lastPacketReceivedTime);
            result2 = result2 * 31 + Long.hashCode(this.bytesReceived);
            result2 = result2 * 31 + Long.hashCode(this.packetsReceived);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Statistics)) {
                return false;
            }
            Statistics statistics = (Statistics)other;
            if (this.firstPacketReceivedTime != statistics.firstPacketReceivedTime) {
                return false;
            }
            if (this.lastPacketReceivedTime != statistics.lastPacketReceivedTime) {
                return false;
            }
            if (this.bytesReceived != statistics.bytesReceived) {
                return false;
            }
            return this.packetsReceived == statistics.packetsReceived;
        }

        public Statistics() {
            this(0L, 0L, 0L, 0L, 15, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jitsi/nlj/StatsKeepingPacketHandler$Statistics$Companion;", "", "()V", "RECEIVED_BITRATE_MBPS", "", "RECEIVED_BYTES", "RECEIVED_DURATION_MS", "RECEIVED_PACKETS", "jitsi-media-transform"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

