/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jingle;

import java.util.List;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleAction;
import org.jitsi.xmpp.extensions.jingle.JingleIQ;
import org.jitsi.xmpp.extensions.jingle.Reason;
import org.jitsi.xmpp.extensions.jingle.ReasonPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SessionInfoPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SessionInfoType;
import org.jivesoftware.smack.packet.IQ;
import org.jxmpp.jid.Jid;

public class JinglePacketFactory {
    public static JingleIQ createRinging(JingleIQ sessionInitiate) {
        return JinglePacketFactory.createSessionInfo(sessionInitiate.getTo(), sessionInitiate.getFrom(), sessionInitiate.getSID(), SessionInfoType.ringing);
    }

    public static JingleIQ createSessionInfo(Jid from, Jid to, String sid) {
        JingleIQ sessionInfo = new JingleIQ(JingleAction.SESSION_INFO, sid);
        sessionInfo.setFrom(from);
        sessionInfo.setTo(to);
        sessionInfo.setType(IQ.Type.set);
        return sessionInfo;
    }

    public static JingleIQ createSessionInfo(Jid from, Jid to, String sid, SessionInfoType type2) {
        JingleIQ ringing = JinglePacketFactory.createSessionInfo(from, to, sid);
        SessionInfoPacketExtension sessionInfoType = new SessionInfoPacketExtension(type2);
        ringing.setSessionInfo(sessionInfoType);
        return ringing;
    }

    public static JingleIQ createBusy(Jid from, Jid to, String sid) {
        return JinglePacketFactory.createSessionTerminate(from, to, sid, Reason.BUSY, null);
    }

    public static JingleIQ createBye(Jid from, Jid to, String sid) {
        return JinglePacketFactory.createSessionTerminate(from, to, sid, Reason.SUCCESS, "Nice talking to you!");
    }

    public static JingleIQ createCancel(Jid from, Jid to, String sid) {
        return JinglePacketFactory.createSessionTerminate(from, to, sid, Reason.CANCEL, "Oops!");
    }

    public static JingleIQ createSessionTerminate(Jid from, Jid to, String sid, Reason reason, String reasonText) {
        JingleIQ terminate = new JingleIQ(JingleAction.SESSION_TERMINATE, sid);
        terminate.setTo(to);
        terminate.setFrom(from);
        terminate.setType(IQ.Type.set);
        ReasonPacketExtension reasonPacketExt = new ReasonPacketExtension(reason, reasonText, null);
        terminate.setReason(reasonPacketExt);
        return terminate;
    }

    public static JingleIQ createSessionAccept(Jid from, Jid to, String sid, Iterable<ContentPacketExtension> contentList) {
        JingleIQ sessionAccept = new JingleIQ(JingleAction.SESSION_ACCEPT, sid);
        sessionAccept.setTo(to);
        sessionAccept.setFrom(from);
        sessionAccept.setResponder(from);
        sessionAccept.setType(IQ.Type.set);
        for (ContentPacketExtension content : contentList) {
            sessionAccept.addContent(content);
        }
        return sessionAccept;
    }

    public static JingleIQ createDescriptionInfo(Jid from, Jid to, String sid, Iterable<ContentPacketExtension> contentList) {
        JingleIQ descriptionInfo = new JingleIQ(JingleAction.DESCRIPTION_INFO, sid);
        descriptionInfo.setTo(to);
        descriptionInfo.setFrom(from);
        descriptionInfo.setResponder(from);
        descriptionInfo.setType(IQ.Type.set);
        for (ContentPacketExtension content : contentList) {
            descriptionInfo.addContent(content);
        }
        return descriptionInfo;
    }

    public static JingleIQ createTransportInfo(Jid from, Jid to, String sid, Iterable<ContentPacketExtension> contentList) {
        JingleIQ transportInfo = new JingleIQ(JingleAction.TRANSPORT_INFO, sid);
        transportInfo.setTo(to);
        transportInfo.setFrom(from);
        transportInfo.setInitiator(from);
        transportInfo.setType(IQ.Type.set);
        for (ContentPacketExtension content : contentList) {
            transportInfo.addContent(content);
        }
        return transportInfo;
    }

    public static JingleIQ createSessionInitiate(Jid from, Jid to, String sid, List<ContentPacketExtension> contentList) {
        JingleIQ sessionInitiate = new JingleIQ(JingleAction.SESSION_INITIATE, sid);
        sessionInitiate.setTo(to);
        sessionInitiate.setFrom(from);
        sessionInitiate.setInitiator(from);
        sessionInitiate.setType(IQ.Type.set);
        for (ContentPacketExtension content : contentList) {
            sessionInitiate.addContent(content);
        }
        return sessionInitiate;
    }

    public static JingleIQ createContentAdd(Jid from, Jid to, String sid, List<ContentPacketExtension> contentList) {
        JingleIQ contentAdd = new JingleIQ(JingleAction.CONTENT_ADD, sid);
        contentAdd.setTo(to);
        contentAdd.setFrom(from);
        contentAdd.setType(IQ.Type.set);
        for (ContentPacketExtension content : contentList) {
            contentAdd.addContent(content);
        }
        return contentAdd;
    }

    public static JingleIQ createContentAccept(Jid from, Jid to, String sid, Iterable<ContentPacketExtension> contentList) {
        JingleIQ contentAccept = new JingleIQ(JingleAction.CONTENT_ACCEPT, sid);
        contentAccept.setTo(to);
        contentAccept.setFrom(from);
        contentAccept.setType(IQ.Type.set);
        for (ContentPacketExtension content : contentList) {
            contentAccept.addContent(content);
        }
        return contentAccept;
    }

    public static JingleIQ createContentReject(Jid from, Jid to, String sid, Iterable<ContentPacketExtension> contentList) {
        JingleIQ contentReject = new JingleIQ(JingleAction.CONTENT_REJECT, sid);
        contentReject.setTo(to);
        contentReject.setFrom(from);
        contentReject.setType(IQ.Type.set);
        if (contentList != null) {
            for (ContentPacketExtension content : contentList) {
                contentReject.addContent(content);
            }
        }
        return contentReject;
    }

    public static JingleIQ createContentModify(Jid from, Jid to, String sid, ContentPacketExtension content) {
        JingleIQ contentModify = new JingleIQ(JingleAction.CONTENT_MODIFY, sid);
        contentModify.setTo(to);
        contentModify.setFrom(from);
        contentModify.setType(IQ.Type.set);
        contentModify.addContent(content);
        return contentModify;
    }

    public static JingleIQ createContentRemove(Jid from, Jid to, String sid, Iterable<ContentPacketExtension> contentList) {
        JingleIQ contentRemove = new JingleIQ(JingleAction.CONTENT_REMOVE, sid);
        contentRemove.setTo(to);
        contentRemove.setFrom(from);
        contentRemove.setType(IQ.Type.set);
        for (ContentPacketExtension content : contentList) {
            contentRemove.addContent(content);
        }
        return contentRemove;
    }
}

