/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter;

import java.io.File;
import java.util.Objects;
import org.gradle.tooling.model.ProjectIdentifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalBuildIdentifier;

@ApiStatus.Internal
public final class InternalProjectIdentifier
implements ProjectIdentifier {
    private final InternalBuildIdentifier build;
    private final String projectPath;

    public InternalProjectIdentifier(InternalBuildIdentifier build, String projectPath) {
        this.build = build;
        this.projectPath = projectPath;
    }

    public InternalBuildIdentifier getBuildIdentifier() {
        return this.build;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public File getRootDir() {
        return this.build.getRootDir();
    }

    public String toString() {
        return String.format("project=%s, %s", this.projectPath, this.build);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalProjectIdentifier that = (InternalProjectIdentifier)o;
        if (!Objects.equals(this.build, that.build)) {
            return false;
        }
        return Objects.equals(this.projectPath, that.projectPath);
    }

    public int hashCode() {
        int result = this.build != null ? this.build.hashCode() : 0;
        result = 31 * result + (this.projectPath != null ? this.projectPath.hashCode() : 0);
        return result;
    }
}

