/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdwp;

import com.jetbrains.sa.jdwp.Command;
import com.jetbrains.sa.jdwp.JDWP;
import com.jetbrains.sa.jdwp.Packet;
import com.jetbrains.sa.jdwp.PacketStream;
import com.jetbrains.sa.jdwp.VirtualMachineImpl;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.connect.spi.Connection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class JDWPProxy {
    private static final Map<Integer, Map<Integer, Command>> COMMANDS = new HashMap<Integer, Map<Integer, Command>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reply(Connection connection, com.jetbrains.sa.jdi.VirtualMachineImpl vm) throws IOException {
        VirtualMachineImpl virtualMachine = new VirtualMachineImpl(connection, vm);
        try {
            try {
                while (true) {
                    byte[] b = connection.readPacket();
                    Packet p = Packet.fromByteArray(b);
                    short cmdSet = p.cmdSet;
                    short cmd = p.cmd;
                    PacketStream packetStream = new PacketStream(virtualMachine, p.id, cmdSet, cmd);
                    Command command = COMMANDS.get(cmdSet).get(cmd);
                    try {
                        command.reply(virtualMachine, packetStream, new PacketStream(virtualMachine, p));
                    }
                    catch (VMDisconnectedException vde) {
                        throw vde;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        packetStream.pkt.errorCode = (short)113;
                        packetStream.dataStream.reset();
                        try {
                            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                            PrintStream printStream = new PrintStream((OutputStream)byteStream, false, "UTF8");
                            e.printStackTrace(printStream);
                            printStream.close();
                            packetStream.writeString(byteStream.toString("UTF8"));
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                    }
                    packetStream.send();
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                connection.close();
                vm.dispose();
            }
        }
        catch (Throwable throwable) {
            connection.close();
            vm.dispose();
            throw throwable;
        }
    }

    private static void sendVMStart(VirtualMachineImpl virtualMachine) {
        PacketStream packetStream = new PacketStream(virtualMachine, 0, 64, 100);
        packetStream.pkt.flags = 0;
        packetStream.writeByte((byte)2);
        packetStream.writeInt(1);
        packetStream.writeByte((byte)90);
        packetStream.writeInt(0);
        packetStream.writeObjectRef(0L);
        packetStream.send();
    }

    static {
        try {
            Class<?>[] declaredClasses;
            for (Class<?> declaredClass : declaredClasses = JDWP.class.getDeclaredClasses()) {
                try {
                    int setId = (Integer)declaredClass.getDeclaredField("COMMAND_SET").get(null);
                    Class<?>[] commandsClasses = declaredClass.getDeclaredClasses();
                    HashMap<Integer, Command> commandsMap = new HashMap<Integer, Command>();
                    COMMANDS.put(setId, commandsMap);
                    for (Class<?> commandsClass : commandsClasses) {
                        try {
                            int commandId = (Integer)commandsClass.getDeclaredField("COMMAND").get(null);
                            commandsMap.put(commandId, (Command)commandsClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                        catch (NoSuchFieldException ignored) {
                            // empty catch block
                        }
                    }
                }
                catch (NoSuchFieldException ignored) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

