/*
 * Decompiled with CFR 0.152.
 */
package training.learn.lesson;

import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.text.paragraph.TextParagraph;
import com.intellij.ide.ui.text.parts.IconTextPart;
import com.intellij.ide.ui.text.parts.LinkTextPart;
import com.intellij.ide.ui.text.parts.RegularTextPart;
import com.intellij.ide.ui.text.parts.TextPart;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.util.IconUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.TaskContext;
import training.dsl.TaskTextProperties;
import training.dsl.impl.LessonExecutor;
import training.dsl.impl.OpenPassedContext;
import training.learn.course.KLesson;
import training.learn.course.Lesson;
import training.learn.lesson.LessonManager;
import training.ui.LearnToolWindow;
import training.ui.LearningUiHighlightingManager;
import training.ui.LearningUiManager;
import training.ui.LessonMessagePane;
import training.ui.MessageFactory;
import training.ui.views.LearnPanel;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 O2\u00020\u0001:\u0001OB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010 JA\u0010!\u001a\u00020\u001b2\b\b\u0001\u0010\"\u001a\u00020\u001d2\b\b\u0002\u0010#\u001a\u00020$2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010%\u001a\u00020$2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'\u00a2\u0006\u0002\u0010(J\r\u0010)\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b*J\u0012\u0010+\u001a\u00020\u001b2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002J\u0006\u0010.\u001a\u00020\u001bJ\u0006\u0010/\u001a\u00020\u001bJ'\u00100\u001a\u00020\u001b2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b3J\u001a\u00104\u001a\u00020\u001b2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u00101\u001a\u00020\u0004H\u0002J\u0006\u00105\u001a\u00020$J\u000e\u00106\u001a\u00020$2\u0006\u00107\u001a\u00020\u0004J\u0006\u00108\u001a\u00020\u001fJ\u001d\u00109\u001a\u00020\u001b2\u0006\u00107\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0000\u00a2\u0006\u0002\b=J\u0006\u0010>\u001a\u00020\u001bJ\u000e\u0010?\u001a\u00020\u001b2\u0006\u00101\u001a\u00020\u0004J\u000e\u0010@\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u001fJ\u000e\u0010B\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020\u001fJ\u000e\u0010D\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020\u001fJ\u000e\u0010E\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u001fJ\u0016\u0010F\u001a\u00020\u001b2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020I0HH\u0002J\u000e\u0010J\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020\u0010J\u000e\u0010L\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020\u0010J\u0006\u0010M\u001a\u00020\u001bJ\u0010\u0010M\u001a\u00020\u001b2\u0006\u0010N\u001a\u00020$H\u0002R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0003\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006P"}, d2={"Ltraining/learn/lesson/LessonManager;", "", "()V", "<set-?>", "Ltraining/learn/course/Lesson;", "currentLesson", "getCurrentLesson", "()Ltraining/learn/course/Lesson;", "Ltraining/dsl/impl/LessonExecutor;", "currentLessonExecutor", "getCurrentLessonExecutor$intellij_featuresTrainer", "()Ltraining/dsl/impl/LessonExecutor;", "learnPanel", "Ltraining/ui/views/LearnPanel;", "getLearnPanel", "()Ltraining/ui/views/LearnPanel;", "Ltraining/dsl/TaskContext$RestoreNotification;", "shownRestoreNotification", "getShownRestoreNotification", "()Ltraining/dsl/TaskContext$RestoreNotification;", "testActionsExecutor", "Ljava/util/concurrent/Executor;", "getTestActionsExecutor", "()Ljava/util/concurrent/Executor;", "testActionsExecutor$delegate", "Lkotlin/Lazy;", "addInactiveMessage", "", "message", "", "visualNumber", "", "(Ljava/lang/String;Ljava/lang/Integer;)V", "addMessage", "text", "isInformer", "", "useInternalParagraphStyle", "textProperties", "Ltraining/dsl/TaskTextProperties;", "(Ljava/lang/String;ZLjava/lang/Integer;ZLtraining/dsl/TaskTextProperties;)V", "clearCurrentLesson", "clearCurrentLesson$intellij_featuresTrainer", "clearEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "clearRestoreMessage", "focusTask", "initDslLesson", "cLesson", "lessonExecutor", "initDslLesson$intellij_featuresTrainer", "initLesson", "lessonIsRunning", "lessonShouldBeOpenedCompleted", "lesson", "messagesNumber", "openLessonPassed", "Ltraining/learn/course/KLesson;", "project", "Lcom/intellij/openapi/project/Project;", "openLessonPassed$intellij_featuresTrainer", "passExercise", "passLesson", "removeInactiveMessages", "number", "removeMessage", "index", "removeMessageAndRepaint", "resetMessagesNumber", "setNotification", "textParts", "", "Lcom/intellij/ide/ui/text/parts/TextPart;", "setRestoreNotification", "notification", "setWarningNotification", "stopLesson", "lessonPassed", "Companion", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nLessonManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LessonManager.kt\ntraining/learn/lesson/LessonManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,214:1\n1#2:215\n10#3:216\n*S KotlinDebug\n*F\n+ 1 LessonManager.kt\ntraining/learn/lesson/LessonManager\n*L\n211#1:216\n*E\n"})
public final class LessonManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Lesson currentLesson;
    @Nullable
    private LessonExecutor currentLessonExecutor;
    @Nullable
    private TaskContext.RestoreNotification shownRestoreNotification;
    @NotNull
    private final Lazy testActionsExecutor$delegate = LazyKt.lazy((Function0)testActionsExecutor.2.INSTANCE);
    @Nullable
    private static volatile Executor externalTestActionsExecutor;
    @NotNull
    private static final Logger LOG;

    @Nullable
    public final Lesson getCurrentLesson() {
        return this.currentLesson;
    }

    private final LearnPanel getLearnPanel() {
        LearnToolWindow learnToolWindow = LearningUiManager.INSTANCE.getActiveToolWindow$intellij_featuresTrainer();
        return learnToolWindow != null ? learnToolWindow.getLearnPanel$intellij_featuresTrainer() : null;
    }

    @Nullable
    public final LessonExecutor getCurrentLessonExecutor$intellij_featuresTrainer() {
        return this.currentLessonExecutor;
    }

    @Nullable
    public final TaskContext.RestoreNotification getShownRestoreNotification() {
        return this.shownRestoreNotification;
    }

    @NotNull
    public final Executor getTestActionsExecutor() {
        Lazy lazy = this.testActionsExecutor$delegate;
        return (Executor)lazy.getValue();
    }

    public final void clearCurrentLesson$intellij_featuresTrainer() {
        this.currentLesson = null;
    }

    public final void openLessonPassed$intellij_featuresTrainer(@NotNull KLesson lesson, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LearnPanel learnPanel = this.getLearnPanel();
        if (learnPanel == null) {
            throw new IllegalStateException("No learn panel".toString());
        }
        LearnPanel learnPanel2 = learnPanel;
        this.initLesson(null, lesson);
        learnPanel2.setScrollToNewMessages$intellij_featuresTrainer(false);
        OpenPassedContext openPassedContext = new OpenPassedContext(project, lesson);
        lesson.getFullLessonContent().invoke((Object)openPassedContext);
        learnPanel2.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        learnPanel2.makeNextButtonSelected();
        learnPanel2.getLearnToolWindow().showGotItAboutRestart$intellij_featuresTrainer();
    }

    public final void initDslLesson$intellij_featuresTrainer(@Nullable Editor editor, @NotNull Lesson cLesson, @NotNull LessonExecutor lessonExecutor) {
        Intrinsics.checkNotNullParameter((Object)cLesson, (String)"cLesson");
        Intrinsics.checkNotNullParameter((Object)lessonExecutor, (String)"lessonExecutor");
        this.initLesson(editor, cLesson);
        this.currentLessonExecutor = lessonExecutor;
    }

    public final boolean lessonIsRunning() {
        LessonExecutor lessonExecutor = this.currentLessonExecutor;
        return lessonExecutor != null ? !lessonExecutor.getHasBeenStopped() : false;
    }

    public final void stopLesson() {
        this.stopLesson(false);
    }

    private final void stopLesson(boolean lessonPassed) {
        this.shownRestoreNotification = null;
        LessonExecutor lessonExecutor = this.currentLessonExecutor;
        if (lessonExecutor != null) {
            LessonExecutor lessonExecutor2;
            LessonExecutor it = lessonExecutor2 = lessonExecutor;
            boolean bl = false;
            lessonExecutor = !it.getHasBeenStopped() ? lessonExecutor2 : null;
            if (lessonExecutor != null) {
                it = lessonExecutor;
                boolean bl2 = false;
                it.stopLesson();
                this.currentLessonExecutor = null;
            }
        }
        if (!lessonPassed) {
            LearningUiHighlightingManager.INSTANCE.clearHighlights();
        }
    }

    private final void initLesson(Editor editor, Lesson cLesson) {
        LearnPanel learnPanel = this.getLearnPanel();
        if (learnPanel == null) {
            return;
        }
        LearnPanel learnPanel2 = learnPanel;
        this.stopLesson();
        this.currentLesson = cLesson;
        learnPanel2.reinitMe(cLesson);
        if (cLesson.getSampleFilePath() == null) {
            this.clearEditor(editor);
        }
        learnPanel2.scrollToTheStart();
    }

    public final void addMessage(@Language(value="HTML") @NotNull String text2, boolean isInformer, @Nullable Integer visualNumber, boolean useInternalParagraphStyle, @Nullable TaskTextProperties textProperties) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            LessonMessagePane.MessageState state = isInformer ? LessonMessagePane.MessageState.INFORMER : LessonMessagePane.MessageState.NORMAL;
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel == null) break block0;
            learnPanel.addMessage(text2, new LessonMessagePane.MessageProperties(state, visualNumber, useInternalParagraphStyle, textProperties));
        }
    }

    public static /* synthetic */ void addMessage$default(LessonManager lessonManager, String string, boolean bl, Integer n, boolean bl2, TaskTextProperties taskTextProperties, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            taskTextProperties = null;
        }
        lessonManager.addMessage(string, bl, n, bl2, taskTextProperties);
    }

    public final void addInactiveMessage(@NotNull String message, @Nullable Integer visualNumber) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel == null) break block0;
            learnPanel.addMessage(message, new LessonMessagePane.MessageProperties(LessonMessagePane.MessageState.INACTIVE, visualNumber, false, null, 12, null));
        }
    }

    public final void removeInactiveMessages(int number) {
        block0: {
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel == null) break block0;
            learnPanel.removeInactiveMessages(number);
        }
    }

    public final void resetMessagesNumber(int number) {
        block0: {
            this.shownRestoreNotification = null;
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel == null) break block0;
            learnPanel.resetMessagesNumber(number);
        }
    }

    public final void removeMessage(int index) {
        block0: {
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel == null) break block0;
            learnPanel.removeMessage(index);
        }
    }

    public final void removeMessageAndRepaint(int index) {
        block0: {
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel == null) break block0;
            LearnPanel it = learnPanel;
            boolean bl = false;
            it.removeMessage(index);
            it.getLessonMessagePane().redraw();
            it.adjustMessagesArea();
        }
    }

    public final int messagesNumber() {
        LearnPanel learnPanel = this.getLearnPanel();
        return learnPanel != null ? learnPanel.messagesNumber() : 0;
    }

    public final void passExercise() {
        block0: {
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel == null) break block0;
            learnPanel.setPreviousMessagesPassed();
        }
    }

    public final void passLesson(@NotNull Lesson cLesson) {
        Intrinsics.checkNotNullParameter((Object)cLesson, (String)"cLesson");
        cLesson.pass$intellij_featuresTrainer();
        LearningUiHighlightingManager.INSTANCE.clearHighlights();
        LearnPanel learnPanel = this.getLearnPanel();
        if (learnPanel == null) {
            return;
        }
        LearnPanel learnPanel2 = learnPanel;
        learnPanel2.makeNextButtonSelected();
        this.stopLesson(true);
    }

    private final void clearEditor(Editor editor) {
        ApplicationManager.getApplication().runWriteAction(() -> LessonManager.clearEditor$lambda$3(editor));
    }

    public final void clearRestoreMessage() {
        if (this.shownRestoreNotification != null) {
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel != null) {
                learnPanel.clearRestoreMessage();
            }
            this.shownRestoreNotification = null;
        }
    }

    public final void setRestoreNotification(@NotNull TaskContext.RestoreNotification notification2) {
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        RegularTextPart message = new RegularTextPart(notification2.getMessage() + " ", true);
        LinkTextPart restoreLink2 = new LinkTextPart(notification2.getRestoreLinkText(), (Function0)new Function0<Unit>(notification2, this){
            final /* synthetic */ TaskContext.RestoreNotification $notification;
            final /* synthetic */ LessonManager this$0;
            {
                this.$notification = $notification;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                block0: {
                    this.$notification.getCallback().invoke();
                    LessonExecutor lessonExecutor = this.this$0.getCurrentLessonExecutor$intellij_featuresTrainer();
                    if (lessonExecutor == null) break block0;
                    LessonManager lessonManager = this.this$0;
                    ModalityState modalityState$iv = null;
                    boolean $i$f$taskInvokeLater = false;
                    ActionsKt.invokeLater(modalityState$iv, (Function0)((Function0)new Function0<Unit>(lessonExecutor, lessonManager){
                        final /* synthetic */ LessonExecutor this$0$inline_fun;
                        final /* synthetic */ LessonManager this$0;
                        {
                            this.this$0$inline_fun = $receiver;
                            this.this$0 = lessonManager;
                            super(0);
                        }

                        public final void invoke() {
                            try {
                                boolean bl = false;
                                this.this$0.clearRestoreMessage();
                            }
                            catch (Throwable e) {
                                LessonExecutor $this$thisLogger$iv = this.this$0$inline_fun;
                                boolean $i$f$thisLogger = false;
                                Logger logger = Logger.getInstance(LessonExecutor.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                                logger.error(this.this$0$inline_fun.getLessonInfoString(), e);
                            }
                        }
                    }));
                }
            }
        });
        Object[] objectArray = new TextPart[]{message, restoreLink2};
        this.setNotification(CollectionsKt.listOf((Object[])objectArray));
        this.shownRestoreNotification = notification2;
    }

    public final void setWarningNotification(@NotNull TaskContext.RestoreNotification notification2) {
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        TextParagraph textParagraph = (TextParagraph)CollectionsKt.singleOrNull(MessageFactory.INSTANCE.convert(notification2.getMessage()));
        if (textParagraph == null) {
            throw new IllegalStateException("Notification message should contain only one paragraph".toString());
        }
        TextParagraph message = textParagraph;
        this.setNotification(message.getTextParts());
        this.shownRestoreNotification = notification2;
    }

    private final void setNotification(List<? extends TextPart> textParts) {
        block0: {
            this.clearRestoreMessage();
            Icon icon = AllIcons.General.NotificationWarning;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"NotificationWarning");
            Icon icon2 = IconUtil.scale((Icon)icon, (Component)this.getLearnPanel(), (float)0.66f);
            IconTextPart warningIconPart = new IconTextPart(icon2);
            RegularTextPart spacePart = new RegularTextPart(" ", false, 2, null);
            Object object = new TextPart[]{warningIconPart, spacePart};
            Object it = object = CollectionsKt.mutableListOf((Object[])object);
            boolean bl = false;
            it.addAll((Collection)textParts);
            Object allParts = object;
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel == null) break block0;
            learnPanel.addMessages(new TextParagraph((List)allParts), new LessonMessagePane.MessageProperties(LessonMessagePane.MessageState.RESTORE, null, false, null, 14, null));
        }
    }

    public final boolean lessonShouldBeOpenedCompleted(@NotNull Lesson lesson) {
        Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
        return lesson.getPassed$intellij_featuresTrainer() && !Intrinsics.areEqual((Object)this.currentLesson, (Object)lesson);
    }

    public final void focusTask() {
        block1: {
            if (!this.lessonIsRunning()) break block1;
            LearnPanel learnPanel = this.getLearnPanel();
            if (learnPanel != null) {
                learnPanel.focusCurrentMessage();
            }
        }
    }

    private static final void clearEditor$lambda$3(Editor $editor) {
        if ($editor != null) {
            Document document = $editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
            Document document2 = document;
            try {
                document2.setText((CharSequence)"");
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                System.err.println("Unable to update text in editor!");
            }
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LessonManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Ltraining/learn/lesson/LessonManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "externalTestActionsExecutor", "Ljava/util/concurrent/Executor;", "getExternalTestActionsExecutor", "()Ljava/util/concurrent/Executor;", "setExternalTestActionsExecutor", "(Ljava/util/concurrent/Executor;)V", "instance", "Ltraining/learn/lesson/LessonManager;", "getInstance", "()Ltraining/learn/lesson/LessonManager;", "intellij.featuresTrainer"})
    @SourceDebugExtension(value={"SMAP\nLessonManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LessonManager.kt\ntraining/learn/lesson/LessonManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,214:1\n43#2,3:215\n*S KotlinDebug\n*F\n+ 1 LessonManager.kt\ntraining/learn/lesson/LessonManager$Companion\n*L\n209#1:215,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Executor getExternalTestActionsExecutor() {
            return externalTestActionsExecutor;
        }

        public final void setExternalTestActionsExecutor(@Nullable Executor executor) {
            externalTestActionsExecutor = executor;
        }

        @NotNull
        public final LessonManager getInstance() {
            boolean $i$f$service = false;
            Class<LessonManager> serviceClass$iv = LessonManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (LessonManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

