/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationImporter;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J4\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/GradleRunConfigurationImporter;", "Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationImporter;", "()V", "canImport", "", "typeName", "", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "process", "", "project", "Lcom/intellij/openapi/project/Project;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "cfg", "", "", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "intellij.gradle.common"})
public final class GradleRunConfigurationImporter
implements RunConfigurationImporter {
    public void process(@NotNull Project project, @NotNull RunConfiguration runConfiguration, @NotNull Map<String, Object> cfg, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter(cfg, (String)"cfg");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        if (!(runConfiguration instanceof GradleRunConfiguration)) {
            return;
        }
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = ((GradleRunConfiguration)runConfiguration).getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskExecutionSettings, (String)"runConfiguration.settings");
        ExternalSystemTaskExecutionSettings settings2 = externalSystemTaskExecutionSettings;
        ObjectUtils.consumeIfCast((Object)cfg.get("projectPath"), String.class, arg_0 -> GradleRunConfigurationImporter.process$lambda$0((Function1)new Function1<String, Unit>(settings2){
            final /* synthetic */ ExternalSystemTaskExecutionSettings $settings;
            {
                this.$settings = $settings;
                super(1);
            }

            public final void invoke(String it) {
                this.$settings.setExternalProjectPath(it);
            }
        }, arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("taskNames"), List.class, arg_0 -> GradleRunConfigurationImporter.process$lambda$1((Function1)new Function1<List<?>, Unit>(settings2){
            final /* synthetic */ ExternalSystemTaskExecutionSettings $settings;
            {
                this.$settings = $settings;
                super(1);
            }

            public final void invoke(List<?> it) {
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                this.$settings.setTaskNames(it);
            }
        }, arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("envs"), Map.class, arg_0 -> GradleRunConfigurationImporter.process$lambda$2((Function1)new Function1<Map<?, ?>, Unit>(settings2){
            final /* synthetic */ ExternalSystemTaskExecutionSettings $settings;
            {
                this.$settings = $settings;
                super(1);
            }

            public final void invoke(Map<?, ?> it) {
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                this.$settings.setEnv(it);
            }
        }, arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("jvmArgs"), String.class, arg_0 -> GradleRunConfigurationImporter.process$lambda$3((Function1)new Function1<String, Unit>(settings2){
            final /* synthetic */ ExternalSystemTaskExecutionSettings $settings;
            {
                this.$settings = $settings;
                super(1);
            }

            public final void invoke(String it) {
                this.$settings.setVmOptions(it);
            }
        }, arg_0));
        ObjectUtils.consumeIfCast((Object)cfg.get("scriptParameters"), String.class, arg_0 -> GradleRunConfigurationImporter.process$lambda$4((Function1)new Function1<String, Unit>(settings2){
            final /* synthetic */ ExternalSystemTaskExecutionSettings $settings;
            {
                this.$settings = $settings;
                super(1);
            }

            public final void invoke(String it) {
                this.$settings.setScriptParameters(it);
            }
        }, arg_0));
    }

    public boolean canImport(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        return Intrinsics.areEqual((Object)"gradle", (Object)typeName);
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = GradleExternalTaskConfigurationType.getInstance().getFactory();
        Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"getInstance().factory");
        return configurationFactory;
    }

    private static final void process$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void process$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void process$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void process$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void process$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

