/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.dependencies.ScriptContents;
import kotlin.script.experimental.dependencies.DependenciesResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.KotlinScriptDefinitionFromAnnotatedTemplate;
import org.jetbrains.kotlin.scripting.resolve.RefineCompilationConfigurationKt;
import org.jetbrains.kotlin.scripting.resolve.ScriptContentLoaderKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00062\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/scripting/resolve/ScriptContentLoader;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getEnvironment", "", "", "scriptDef", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "getScriptContents", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptContentLoader$BasicScriptContents;", "scriptDefinition", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadContentsAndResolveDependencies", "Lkotlin/script/experimental/dependencies/DependenciesResolver$ResolveResult;", "BasicScriptContents", "kotlin-scripting-compiler-impl"})
public final class ScriptContentLoader {
    @NotNull
    private final Project project;

    public ScriptContentLoader(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final BasicScriptContents getScriptContents(@NotNull KotlinScriptDefinition scriptDefinition, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDefinition), (String)"scriptDefinition");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return RefineCompilationConfigurationKt.makeScriptContents(file2, scriptDefinition, this.project, scriptDefinition.getTemplate().getClass().getClassLoader());
    }

    @NotNull
    public final DependenciesResolver.ResolveResult loadContentsAndResolveDependencies(@NotNull KotlinScriptDefinition scriptDef, @NotNull VirtualFile file2) {
        DependenciesResolver.ResolveResult resolveResult;
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDef), (String)"scriptDef");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        BasicScriptContents scriptContents = this.getScriptContents(scriptDef, file2);
        Map<String, Object> environment = this.getEnvironment(scriptDef);
        try {
            resolveResult = scriptDef.getDependencyResolver().resolve(scriptContents, environment);
        }
        catch (Throwable e) {
            resolveResult = ScriptContentLoaderKt.asResolveFailure(e, scriptDef);
        }
        DependenciesResolver.ResolveResult result2 = resolveResult;
        return result2;
    }

    @NotNull
    public final Map<String, Object> getEnvironment(@NotNull KotlinScriptDefinition scriptDef) {
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDef), (String)"scriptDef");
        KotlinScriptDefinitionFromAnnotatedTemplate kotlinScriptDefinitionFromAnnotatedTemplate = scriptDef instanceof KotlinScriptDefinitionFromAnnotatedTemplate ? (KotlinScriptDefinitionFromAnnotatedTemplate)scriptDef : null;
        Map map2 = kotlinScriptDefinitionFromAnnotatedTemplate != null ? kotlinScriptDefinitionFromAnnotatedTemplate.getEnvironment() : null;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u001b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bR!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0004\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\f\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/scripting/resolve/ScriptContentLoader$BasicScriptContents;", "Lkotlin/script/dependencies/ScriptContents;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAnnotations", "Lkotlin/Function0;", "", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/jvm/functions/Function0;)V", "annotations", "()Ljava/lang/Iterable;", "annotations$delegate", "Lkotlin/Lazy;", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "text", "", "getText", "()Ljava/lang/CharSequence;", "text$delegate", "kotlin-scripting-compiler-impl"})
    public static final class BasicScriptContents
    implements ScriptContents {
        @NotNull
        private final File file;
        @NotNull
        private final Lazy annotations$delegate;
        @NotNull
        private final Lazy text$delegate;

        public BasicScriptContents(@NotNull VirtualFile virtualFile2, @NotNull Function0<? extends Iterable<? extends Annotation>> getAnnotations) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            Intrinsics.checkNotNullParameter(getAnnotations, (String)"getAnnotations");
            this.file = new File(virtualFile2.getPath());
            this.annotations$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<Iterable<? extends Annotation>>(getAnnotations){
                final /* synthetic */ Function0<Iterable<Annotation>> $getAnnotations;
                {
                    this.$getAnnotations = $getAnnotations;
                    super(0);
                }

                @NotNull
                public final Iterable<Annotation> invoke() {
                    return (Iterable)this.$getAnnotations.invoke();
                }
            }));
            this.text$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<String>(virtualFile2){
                final /* synthetic */ VirtualFile $virtualFile;
                {
                    this.$virtualFile = $virtualFile;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    InputStream inputStream = this.$virtualFile.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    InputStream inputStream2 = inputStream;
                    Charset charset = this.$virtualFile.getCharset();
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCharset(...)");
                    Charset charset2 = charset;
                    return TextStreamsKt.readText((Reader)new InputStreamReader(inputStream2, charset2));
                }
            }));
        }

        @Override
        @NotNull
        public File getFile() {
            return this.file;
        }

        @Override
        @NotNull
        public Iterable<Annotation> getAnnotations() {
            Lazy lazy = this.annotations$delegate;
            return (Iterable)lazy.getValue();
        }

        @Override
        @Nullable
        public CharSequence getText() {
            Lazy lazy = this.text$delegate;
            return (CharSequence)lazy.getValue();
        }
    }
}

