/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.refIndex;

import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.io.CorruptedException;
import java.io.Closeable;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.impl.BuildDataPathsImpl;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.kotlin.idea.search.refIndex.ClassOneToManyStorage;
import org.jetbrains.kotlin.idea.search.refIndex.KotlinCompilerReferenceIndexStorage;
import org.jetbrains.kotlin.idea.search.refIndex.KotlinCompilerReferenceIndexStorageKt;
import org.jetbrains.kotlin.idea.search.refIndex.LookupStorageReader;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000e\u001a\u00020\rJ\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexStorage;", "", "kotlinDataContainerPath", "Ljava/nio/file/Path;", "lookupStorageReader", "Lorg/jetbrains/kotlin/idea/search/refIndex/LookupStorageReader;", "(Ljava/nio/file/Path;Lorg/jetbrains/kotlin/idea/search/refIndex/LookupStorageReader;)V", "subtypesStorage", "Lorg/jetbrains/kotlin/idea/search/refIndex/ClassOneToManyStorage;", "close", "", "getSubtypesOf", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "deep", "", "getUsages", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "initialize", "buildDataPaths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "Companion", "kotlin.compiler-reference-index"})
@SourceDebugExtension(value={"SMAP\nKotlinCompilerReferenceIndexStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCompilerReferenceIndexStorage.kt\norg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,179:1\n1603#2,9:180\n1855#2:189\n1856#2:191\n1612#2:192\n1#3:190\n10#4:193\n*S KotlinDebug\n*F\n+ 1 KotlinCompilerReferenceIndexStorage.kt\norg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexStorage\n*L\n157#1:180,9\n157#1:189\n157#1:191\n157#1:192\n157#1:190\n45#1:193\n*E\n"})
public final class KotlinCompilerReferenceIndexStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LookupStorageReader lookupStorageReader;
    @NotNull
    private final ClassOneToManyStorage subtypesStorage;
    @NotNull
    private static final String SUBTYPES_STORAGE_NAME = "subtypes." + BasicMapsOwner.Companion.getCACHE_EXTENSION();
    @NotNull
    private static final ExecutorService STORAGE_INDEXING_EXECUTOR;
    @NotNull
    private static final Logger LOG;

    private KotlinCompilerReferenceIndexStorage(Path kotlinDataContainerPath, LookupStorageReader lookupStorageReader) {
        this.lookupStorageReader = lookupStorageReader;
        Path path2 = kotlinDataContainerPath.resolve(SUBTYPES_STORAGE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"kotlinDataContainerPath.\u2026ve(SUBTYPES_STORAGE_NAME)");
        this.subtypesStorage = new ClassOneToManyStorage(path2);
    }

    private final boolean initialize(BuildDataPaths buildDataPaths) {
        return KotlinCompilerReferenceIndexStorage.Companion.initializeSubtypeStorage(buildDataPaths, this.subtypesStorage);
    }

    private final void close() {
        this.lookupStorageReader.close();
        this.subtypesStorage.closeAndClean();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VirtualFile> getUsages(@NotNull FqName fqName2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Iterable $this$mapNotNull$iv = this.lookupStorageReader.get(fqName2);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Path it = (Path)element$iv$iv;
            boolean bl2 = false;
            if (VfsUtil.findFile((Path)it, (boolean)false) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Sequence<FqName> getSubtypesOf(@NotNull FqName fqName2, boolean deep) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return this.subtypesStorage.get(fqName2, deep);
    }

    public /* synthetic */ KotlinCompilerReferenceIndexStorage(Path kotlinDataContainerPath, LookupStorageReader lookupStorageReader, DefaultConstructorMarker $constructor_marker) {
        this(kotlinDataContainerPath, lookupStorageReader);
    }

    public static final /* synthetic */ ExecutorService access$getSTORAGE_INDEXING_EXECUTOR$cp() {
        return STORAGE_INDEXING_EXECUTOR;
    }

    static {
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Kotlin compiler references indexing", (int)UnindexedFilesUpdater.getMaxNumberOfIndexingThreads());
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplication\u2026dexingThreads()\n        )");
        STORAGE_INDEXING_EXECUTOR = executorService;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KotlinCompilerReferenceIndexStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fJ\u0018\u0010\u001a\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\fJ$\u0010\u001f\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00140!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexStorage$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "STORAGE_INDEXING_EXECUTOR", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "SUBTYPES_STORAGE_NAME", "", "buildDataPaths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "Lcom/intellij/openapi/project/Project;", "getBuildDataPaths$kotlin_compiler_reference_index", "(Lcom/intellij/openapi/project/Project;)Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "kotlinDataContainer", "Ljava/nio/file/Path;", "getKotlinDataContainer$kotlin_compiler_reference_index", "(Lorg/jetbrains/jps/builders/storage/BuildDataPaths;)Ljava/nio/file/Path;", "close", "", "storage", "Lorg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexStorage;", "hasIndex", "", "project", "initializeForTests", "destination", "Lorg/jetbrains/kotlin/idea/search/refIndex/ClassOneToManyStorage;", "initializeSubtypeStorage", "open", "visitSubtypeStorages", "processor", "Lkotlin/Function1;", "kotlin.compiler-reference-index"})
    @SourceDebugExtension(value={"SMAP\nKotlinCompilerReferenceIndexStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCompilerReferenceIndexStorage.kt\norg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexStorage$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,179:1\n1#2:180\n17#3,6:181\n17#3,6:187\n*S KotlinDebug\n*F\n+ 1 KotlinCompilerReferenceIndexStorage.kt\norg/jetbrains/kotlin/idea/search/refIndex/KotlinCompilerReferenceIndexStorage$Companion\n*L\n94#1:181,6\n118#1:187,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final KotlinCompilerReferenceIndexStorage open(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            String string2 = (String)ActionsKt.runReadAction((Function0)((Function0)new Function0<String>(project2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                @Nullable
                public final String invoke() {
                    Project project2;
                    Project p0 = project2 = this.$project;
                    boolean bl = false;
                    Object object = !p0.isDisposed() ? project2 : null;
                    return object != null ? object.getBasePath() : null;
                }
            }));
            if (string2 == null) {
                return null;
            }
            String projectPath2 = string2;
            BuildDataPaths buildDataPaths = this.getBuildDataPaths$kotlin_compiler_reference_index(project2);
            Path path2 = this.getKotlinDataContainer$kotlin_compiler_reference_index(buildDataPaths);
            if (path2 == null) {
                boolean bl = false;
                LOG.warn("kotlin-data-container is not found");
                return null;
            }
            Path kotlinDataContainerPath = path2;
            LookupStorageReader lookupStorageReader = LookupStorageReader.Companion.create(kotlinDataContainerPath, projectPath2);
            if (lookupStorageReader == null) {
                boolean bl = false;
                LOG.warn("LookupStorage not found or corrupted");
                return null;
            }
            LookupStorageReader lookupStorageReader2 = lookupStorageReader;
            KotlinCompilerReferenceIndexStorage storage = new KotlinCompilerReferenceIndexStorage(kotlinDataContainerPath, lookupStorageReader2, null);
            if (!storage.initialize(buildDataPaths)) {
                return null;
            }
            return storage;
        }

        public final void close(@Nullable KotlinCompilerReferenceIndexStorage storage) {
            Unit unit2;
            KotlinCompilerReferenceIndexStorage kotlinCompilerReferenceIndexStorage = storage;
            if (kotlinCompilerReferenceIndexStorage != null) {
                kotlinCompilerReferenceIndexStorage.close();
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            Unit it = unit2;
            boolean bl = false;
            LOG.info("KCRI storage is closed" + (it == null ? " (didn't exist)" : ""));
        }

        public final boolean hasIndex(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return LookupStorageReader.Companion.hasStorage(project2);
        }

        @TestOnly
        public final boolean initializeForTests(@NotNull BuildDataPaths buildDataPaths, @NotNull ClassOneToManyStorage destination) {
            Intrinsics.checkNotNullParameter((Object)buildDataPaths, (String)"buildDataPaths");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            return this.initializeSubtypeStorage(buildDataPaths, destination);
        }

        @NotNull
        public final BuildDataPaths getBuildDataPaths$kotlin_compiler_reference_index(@NotNull Project $this$buildDataPaths) {
            Intrinsics.checkNotNullParameter((Object)$this$buildDataPaths, (String)"<this>");
            return (BuildDataPaths)new BuildDataPathsImpl(BuildManager.getInstance().getProjectSystemDirectory($this$buildDataPaths));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final Path getKotlinDataContainer$kotlin_compiler_reference_index(@NotNull BuildDataPaths $this$kotlinDataContainer) {
            Path path2;
            Intrinsics.checkNotNullParameter((Object)$this$kotlinDataContainer, (String)"<this>");
            File file2 = $this$kotlinDataContainer.getTargetsDataRoot();
            if (file2 == null) return null;
            Path path3 = file2.toPath();
            if (path3 == null) return null;
            Path path4 = path3.resolve("kotlin-data-container");
            if (path4 == null) return null;
            Path it = path2 = path4;
            boolean bl = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return null;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (!Files.isDirectory(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) return null;
            boolean bl2 = true;
            if (!bl2) return null;
            Path path5 = path2;
            Path path6 = path5;
            if (path6 == null) return null;
            List list2 = PathsKt.listDirectoryEntries((Path)path6, (String)"kotlin-data-container*");
            if (list2 == null) return null;
            Path path7 = (Path)CollectionsKt.firstOrNull((List)list2);
            return path7;
        }

        private final boolean initializeSubtypeStorage(BuildDataPaths buildDataPaths, ClassOneToManyStorage destination) {
            Ref.BooleanRef wasCorrupted = new Ref.BooleanRef();
            MultiMap multiMap = MultiMap.createConcurrentSet();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createConcurrentSet<String, String>()");
            MultiMap destinationMap = multiMap;
            List futures = new ArrayList();
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Companion.visitSubtypeStorages(buildDataPaths, (Function1<? super Path, Unit>)((Function1)new Function1<Path, Unit>(futures, (MultiMap<String, String>)destinationMap, wasCorrupted){
                final /* synthetic */ List<Future<?>> $futures;
                final /* synthetic */ MultiMap<String, String> $destinationMap;
                final /* synthetic */ Ref.BooleanRef $wasCorrupted;
                {
                    this.$futures = $futures;
                    this.$destinationMap = $destinationMap;
                    this.$wasCorrupted = $wasCorrupted;
                    super(1);
                }

                public final void invoke(@NotNull Path storagePath) {
                    Intrinsics.checkNotNullParameter((Object)storagePath, (String)"storagePath");
                    ((Collection)this.$futures).add(KotlinCompilerReferenceIndexStorage.access$getSTORAGE_INDEXING_EXECUTOR$cp().submit(() -> initializeSubtypeStorage.timeOfFilling.1.1.invoke$lambda$0(this.$destinationMap, storagePath, this.$wasCorrupted)));
                }

                private static final void invoke$lambda$0(MultiMap $destinationMap, Path $storagePath, Ref.BooleanRef $wasCorrupted) {
                    Intrinsics.checkNotNullParameter((Object)$destinationMap, (String)"$destinationMap");
                    Intrinsics.checkNotNullParameter((Object)$storagePath, (String)"$storagePath");
                    Intrinsics.checkNotNullParameter((Object)$wasCorrupted, (String)"$wasCorrupted");
                    try {
                        KotlinCompilerReferenceIndexStorageKt.access$initializeStorage($destinationMap, $storagePath);
                    }
                    catch (CorruptedException e) {
                        $wasCorrupted.element = true;
                        KotlinCompilerReferenceIndexStorage.access$getLOG$cp().warn("KCRI storage was corrupted", (Throwable)e);
                    }
                }
            }));
            try {
                for (Future future : futures) {
                    future.get();
                }
            }
            catch (InterruptedException e) {
                LOG.warn("KCRI initialization was interrupted");
                throw e;
            }
            long timeOfFilling2 = System.currentTimeMillis() - start$iv;
            if (wasCorrupted.element) {
                return false;
            }
            boolean $i$f$measureTimeMillis2 = false;
            long start$iv2 = System.currentTimeMillis();
            boolean bl2 = false;
            for (Map.Entry entry : destinationMap.entrySet()) {
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"destinationMap.entrySet()");
                String key = (String)entry.getKey();
                Collection values2 = (Collection)entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                Intrinsics.checkNotNullExpressionValue((Object)values2, (String)"values");
                destination.put(key, values2);
            }
            long timeOfFlush = System.currentTimeMillis() - start$iv2;
            LOG.info("KCRI storage is opened: took " + (timeOfFilling2 + timeOfFlush) + " ms for " + futures.size() + " storages (filling map: " + timeOfFilling2 + " ms, flush to storage: " + timeOfFlush + " ms)");
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void visitSubtypeStorages(BuildDataPaths buildDataPaths, Function1<? super Path, Unit> processor2) {
            for (JavaModuleBuildTargetType buildTargetType : JavaModuleBuildTargetType.ALL_TYPES) {
                Path buildTargetPath = buildDataPaths.getTargetTypeDataRoot((BuildTargetType)buildTargetType).toPath();
                Intrinsics.checkNotNullExpressionValue((Object)buildTargetPath, (String)"buildTargetPath");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(buildTargetPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.isDirectory(buildTargetPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
                Path path2 = buildTargetPath;
                Closeable closeable = Files.newDirectoryStream(path2, "*");
                Throwable throwable = null;
                try {
                    DirectoryStream directoryStream = (DirectoryStream)closeable;
                    Intrinsics.checkNotNull((Object)directoryStream);
                    Iterable iterable = directoryStream;
                    for (Path targetDataRoot : iterable) {
                        Path path3;
                        Path path4;
                        Path path5;
                        boolean bl = false;
                        Path it = path5 = targetDataRoot;
                        boolean bl2 = false;
                        LinkOption[] linkOptionArray3 = new LinkOption[]{};
                        Path path6 = Files.isDirectory(it, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) ? path5 : null;
                        if (path6 == null || (path5 = path6.resolve("kotlin")) == null || (path4 = path5.resolve(SUBTYPES_STORAGE_NAME)) == null) continue;
                        Path it2 = path3 = path4;
                        boolean bl3 = false;
                        LinkOption[] linkOptionArray4 = new LinkOption[]{};
                        Path path7 = !Files.notExists(it2, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length)) ? path3 : null;
                        if (path7 == null) continue;
                        Path workingPath = path7;
                        processor2.invoke((Object)workingPath);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

