/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.declarationsSearch;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.search.declarationsSearch.ClassInheritorsSearchKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchySearch;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchySearchRequest;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchyTraverser;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.PsiMethodOverridingHierarchyTraverser;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\tH\u0014J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0014J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/search/declarationsSearch/KotlinPsiMethodOverridersSearch;", "Lorg/jetbrains/kotlin/idea/search/declarationsSearch/HierarchySearch;", "Lcom/intellij/psi/PsiMethod;", "()V", "doSearchDirect", "", "request", "Lorg/jetbrains/kotlin/idea/search/declarationsSearch/HierarchySearchRequest;", "consumer", "Lcom/intellij/util/Processor;", "isApplicable", "", "searchDirectOverriders", "", "psiMethod", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\noverridersSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 overridersSearch.kt\norg/jetbrains/kotlin/idea/search/declarationsSearch/KotlinPsiMethodOverridersSearch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1855#2,2:153\n*S KotlinDebug\n*F\n+ 1 overridersSearch.kt\norg/jetbrains/kotlin/idea/search/declarationsSearch/KotlinPsiMethodOverridersSearch\n*L\n91#1:153,2\n*E\n"})
public final class KotlinPsiMethodOverridersSearch
extends HierarchySearch<PsiMethod> {
    @NotNull
    public static final KotlinPsiMethodOverridersSearch INSTANCE = new KotlinPsiMethodOverridersSearch();

    private KotlinPsiMethodOverridersSearch() {
        super(PsiMethodOverridingHierarchyTraverser.INSTANCE);
    }

    @NotNull
    public final Iterable<PsiMethod> searchDirectOverriders(@NotNull PsiMethod psiMethod) {
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        PsiClass psiClass2 = psiMethod.getContainingClass();
        if (psiClass2 == null) {
            List list2 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"emptyList()");
            return list2;
        }
        PsiClass psiClass3 = psiClass2;
        LinkedHashMap<PsiClass, PsiMethod> classToMethod = new LinkedHashMap<PsiClass, PsiMethod>();
        HierarchyTraverser<PsiClass> classTraverser2 = new HierarchyTraverser<PsiClass>(classToMethod){
            final /* synthetic */ LinkedHashMap<PsiClass, PsiMethod> $classToMethod;
            {
                this.$classToMethod = $classToMethod;
            }

            @NotNull
            public Iterable<PsiClass> nextElements(@NotNull PsiClass current) {
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                Project project2 = current.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"current.project");
                Query query = DirectClassInheritorsSearch.search((PsiClass)current, (SearchScope)((SearchScope)KotlinScopeUtils.allScope(project2)), (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(\n                \u2026*/ true\n                )");
                return (Iterable)query;
            }

            public boolean shouldDescend(@NotNull PsiClass element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                return ClassInheritorsSearchKt.isInheritable(element3) && !this.$classToMethod.containsKey(element3);
            }
        };
        classTraverser2.forEach(psiClass3, (Function1)new Function1<PsiClass, Unit>(psiClass3, psiMethod, classToMethod){
            final /* synthetic */ PsiClass $psiClass;
            final /* synthetic */ PsiMethod $psiMethod;
            final /* synthetic */ LinkedHashMap<PsiClass, PsiMethod> $classToMethod;
            {
                this.$psiClass = $psiClass;
                this.$psiMethod = $psiMethod;
                this.$classToMethod = $classToMethod;
                super(1);
            }

            public final void invoke(@NotNull PsiClass inheritor) {
                Intrinsics.checkNotNullParameter((Object)inheritor, (String)"inheritor");
                PsiSubstitutor psiSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)this.$psiClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"getSuperClassSubstitutor\u2026or, PsiSubstitutor.EMPTY)");
                PsiSubstitutor substitutor3 = psiSubstitutor;
                MethodSignature methodSignature = this.$psiMethod.getSignature(substitutor3);
                Intrinsics.checkNotNullExpressionValue((Object)methodSignature, (String)"psiMethod.getSignature(substitutor)");
                MethodSignature signature2 = methodSignature;
                PsiMethod candidate2 = MethodSignatureUtil.findMethodBySuperSignature((PsiClass)inheritor, (MethodSignature)signature2, (boolean)false);
                if (candidate2 != null && KotlinPsiMethodOverridersSearch.access$searchDirectOverriders$isAcceptable(candidate2, inheritor, this.$psiMethod, this.$psiClass)) {
                    ((Map)this.$classToMethod).put(inheritor, candidate2);
                }
            }
        });
        Collection<PsiMethod> collection = classToMethod.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"classToMethod.values");
        return collection;
    }

    @Override
    protected boolean isApplicable(@NotNull HierarchySearchRequest<PsiMethod> request2) {
        Intrinsics.checkNotNullParameter(request2, (String)"request");
        return (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(request2){
            final /* synthetic */ HierarchySearchRequest<PsiMethod> $request;
            {
                this.$request = $request;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return OverridersSearchKt.isOverridableElement((PsiElement)this.$request.getOriginalElement());
            }
        }));
    }

    @Override
    protected void doSearchDirect(@NotNull HierarchySearchRequest<PsiMethod> request2, @NotNull Processor<? super PsiMethod> consumer) {
        Intrinsics.checkNotNullParameter(request2, (String)"request");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Iterable<PsiMethod> $this$forEach$iv = this.searchDirectOverriders(request2.getOriginalElement());
        boolean $i$f$forEach = false;
        Iterator<PsiMethod> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            PsiMethod element$iv;
            PsiMethod method = element$iv = iterator2.next();
            boolean bl = false;
            consumer.process((Object)method);
        }
    }

    private static final boolean searchDirectOverriders$isAcceptable(PsiMethod $this$searchDirectOverriders_u24isAcceptable, PsiClass inheritor, PsiMethod baseMethod, PsiClass baseClass2) {
        return $this$searchDirectOverriders_u24isAcceptable.hasModifierProperty("static") ? false : (baseMethod.hasModifierProperty("packageLocal") ? JavaPsiFacade.getInstance((Project)$this$searchDirectOverriders_u24isAcceptable.getProject()).arePackagesTheSame((PsiElement)baseClass2, (PsiElement)inheritor) : true);
    }

    public static final /* synthetic */ boolean access$searchDirectOverriders$isAcceptable(PsiMethod $receiver, PsiClass inheritor, PsiMethod baseMethod, PsiClass baseClass2) {
        return KotlinPsiMethodOverridersSearch.searchDirectOverriders$isAcceptable($receiver, inheritor, baseMethod, baseClass2);
    }
}

