/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.ui;

import com.intellij.ide.util.AbstractTreeClassChooserDialog;
import com.intellij.ide.util.TreeChooser;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.projectView.KtClassOrObjectTreeNode;
import org.jetbrains.kotlin.idea.projectView.KtFileTreeNode;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B+\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J.\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0014\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/ui/KotlinFileChooserDialog;", "Lcom/intellij/ide/util/AbstractTreeClassChooserDialog;", "Lorg/jetbrains/kotlin/psi/KtFile;", "title", "", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "packageName", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;Ljava/lang/String;)V", "createChooseByNameModel", "Lcom/intellij/ide/util/gotoByName/GotoFileModel;", "getClassesByName", "", "name", "checkBoxState", "", "pattern", "getSelectedFromTreeUserObject", "node", "Ljavax/swing/tree/DefaultMutableTreeNode;", "ScopeAwareClassFilter", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nKotlinFileChooserDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFileChooserDialog.kt\norg/jetbrains/kotlin/idea/refactoring/ui/KotlinFileChooserDialog\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,65:1\n4098#2,11:66\n*S KotlinDebug\n*F\n+ 1 KotlinFileChooserDialog.kt\norg/jetbrains/kotlin/idea/refactoring/ui/KotlinFileChooserDialog\n*L\n45#1:66,11\n*E\n"})
public final class KotlinFileChooserDialog
extends AbstractTreeClassChooserDialog<KtFile> {
    public KotlinFileChooserDialog(@NlsContexts.DialogTitle @NotNull String title, @NotNull Project project2, @Nullable GlobalSearchScope searchScope2, @Nullable String packageName2) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        GlobalSearchScope globalSearchScope = searchScope2;
        if (globalSearchScope == null) {
            globalSearchScope = KotlinScopeUtils.restrictToKotlinSources(KotlinScopeUtils.projectScope(project2));
        }
        super(title, project2, globalSearchScope, KtFile.class, (TreeChooser.Filter)new ScopeAwareClassFilter(searchScope2, packageName2), null, null, false, false);
    }

    @Nullable
    protected KtFile getSelectedFromTreeUserObject(@NotNull DefaultMutableTreeNode node2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Object userObject = node2.getUserObject();
        if (userObject instanceof KtFileTreeNode) {
            object = ((KtFileTreeNode)((Object)userObject)).getKtFile();
        } else if (userObject instanceof KtClassOrObjectTreeNode) {
            KtFile ktFile = ((KtClassOrObject)((KtClassOrObjectTreeNode)((Object)userObject)).getValue()).getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"userObject.value.containingKtFile");
            KtFile containingFile = ktFile;
            object = containingFile.getDeclarations().size() == 1 ? containingFile : null;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<KtFile> getClassesByName(@NotNull String name2, boolean checkBoxState, @NotNull String pattern2, @NotNull GlobalSearchScope searchScope2) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pattern2, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        PsiFile[] psiFileArray = FilenameIndex.getFilesByName((Project)this.getProject(), (String)name2, (GlobalSearchScope)searchScope2);
        Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFilesByName(project, name, searchScope)");
        Object[] $this$filterIsInstance$iv = psiFileArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected GotoFileModel createChooseByNameModel() {
        return new GotoFileModel(this.getProject());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/ui/KotlinFileChooserDialog$ScopeAwareClassFilter;", "Lcom/intellij/ide/util/TreeChooser$Filter;", "Lorg/jetbrains/kotlin/psi/KtFile;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "packageName", "", "(Lcom/intellij/psi/search/GlobalSearchScope;Ljava/lang/String;)V", "getPackageName", "()Ljava/lang/String;", "getSearchScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "isAccepted", "", "element", "kotlin.refactorings.common"})
    @SourceDebugExtension(value={"SMAP\nKotlinFileChooserDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFileChooserDialog.kt\norg/jetbrains/kotlin/idea/refactoring/ui/KotlinFileChooserDialog$ScopeAwareClassFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
    private static final class ScopeAwareClassFilter
    implements TreeChooser.Filter<KtFile> {
        @Nullable
        private final GlobalSearchScope searchScope;
        @Nullable
        private final String packageName;

        public ScopeAwareClassFilter(@Nullable GlobalSearchScope searchScope2, @Nullable String packageName2) {
            this.searchScope = searchScope2;
            this.packageName = packageName2;
        }

        @Nullable
        public final GlobalSearchScope getSearchScope() {
            return this.searchScope;
        }

        @Nullable
        public final String getPackageName() {
            return this.packageName;
        }

        public boolean isAccepted(@Nullable KtFile element3) {
            boolean bl;
            if (element3 == null) {
                return false;
            }
            if (this.searchScope == null && this.packageName == null) {
                return true;
            }
            GlobalSearchScope globalSearchScope = this.searchScope;
            boolean matchesSearchScope = globalSearchScope != null ? globalSearchScope.accept(element3.getVirtualFile()) : true;
            String string2 = this.packageName;
            if (string2 != null) {
                String it = string2;
                boolean bl2 = false;
                bl = Intrinsics.areEqual((Object)element3.getPackageFqName().asString(), (Object)it);
            } else {
                bl = true;
            }
            boolean matchesPackage = bl;
            return matchesSearchScope && matchesPackage;
        }
    }
}

