/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.rename.KtResolvableCollisionUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameKotlinPsiProcessor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtTypeAlias;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J,\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\fH\u0016J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J5\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016\u00a2\u0006\u0002\u0010\"J\u0018\u0010#\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0004H\u0016J\u0018\u0010%\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0004H\u0016J\u001c\u0010&\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\f\u0010)\u001a\u00020\u0004*\u00020\u0012H\u0002\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinClassifierProcessor;", "Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinPsiProcessor;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "findCollisions", "", "newName", "", "allRenames", "", "result", "", "Lcom/intellij/usageView/UsageInfo;", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "searchInCommentsAndStrings", "getClassOrObject", "isToSearchForTextOccurrences", "isToSearchInComments", "psiElement", "prepareRenaming", "processFoundReferences", "references", "renameElement", "usages", "", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "setToSearchForTextOccurrences", "enabled", "setToSearchInComments", "substituteElementToRename", "editor", "Lcom/intellij/openapi/editor/Editor;", "isCompanionObjectClassReference", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nRenameKotlinClassifierProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameKotlinClassifierProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinClassifierProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,131:1\n766#2:132\n857#2,2:133\n1855#2,2:135\n766#2:137\n857#2,2:138\n37#3,2:140\n13579#4,2:142\n*S KotlinDebug\n*F\n+ 1 RenameKotlinClassifierProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinClassifierProcessor\n*L\n42#1:132\n42#1:133,2\n44#1:135,2\n63#1:137\n63#1:138,2\n116#1:140,2\n118#1:142,2\n*E\n"})
public final class RenameKotlinClassifierProcessor
extends RenameKotlinPsiProcessor {
    @Override
    public boolean canProcessElement(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return element3 instanceof KtClassOrObject || element3 instanceof KtLightClass || element3 instanceof KtConstructor || element3 instanceof KtTypeAlias;
    }

    public boolean isToSearchInComments(@NotNull PsiElement psiElement2) {
        Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"psiElement");
        return KotlinCommonRefactoringSettings.Companion.getInstance().getRENAME_SEARCH_IN_COMMENTS_FOR_CLASS();
    }

    public void setToSearchInComments(@NotNull PsiElement element3, boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KotlinCommonRefactoringSettings.Companion.getInstance().setRENAME_SEARCH_IN_COMMENTS_FOR_CLASS(enabled2);
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinCommonRefactoringSettings.Companion.getInstance().getRENAME_SEARCH_FOR_TEXT_FOR_CLASS();
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element3, boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KotlinCommonRefactoringSettings.Companion.getInstance().setRENAME_SEARCH_FOR_TEXT_FOR_CLASS(enabled2);
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return this.getClassOrObject(element3);
    }

    /*
     * WARNING - void declaration
     */
    public void prepareRenaming(@NotNull PsiElement element3, @NotNull String newName2, @NotNull Map<PsiElement, String> allRenames) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        super.prepareRenaming(element3, newName2, allRenames);
        PsiElement psiElement2 = this.getClassOrObject(element3);
        KtClassOrObject ktClassOrObject = psiElement2 instanceof KtClassOrObject ? (KtClassOrObject)psiElement2 : null;
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject classOrObject = ktClassOrObject;
        Iterable $this$filter$iv = this.getRenameRefactoringSupport().withExpectedActuals((KtDeclaration)classOrObject);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtDeclaration it = (KtDeclaration)element$iv$iv;
            boolean bl = false;
            if (!(it.getParent() instanceof KtFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List topLevelClassifiers = (List)destination$iv$iv;
        Iterable $this$forEach$iv = topLevelClassifiers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String nameWithoutExtensions;
            KtFile file2;
            KtDeclaration it = (KtDeclaration)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getContainingKtFile(), (String)"it.containingKtFile");
            VirtualFile virtualFile2 = file2.getVirtualFile();
            if (virtualFile2 == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2.getNameWithoutExtension(), (String)"virtualFile.nameWithoutExtension");
            if (!Intrinsics.areEqual((Object)nameWithoutExtensions, (Object)it.getName())) continue;
            String newFileName = newName2 + "." + virtualFile2.getExtension();
            allRenames.put((PsiElement)file2, newFileName);
            RenamePsiElementProcessor.forElement((PsiElement)((PsiElement)file2)).prepareRenaming((PsiElement)file2, newFileName, allRenames);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<PsiReference> processFoundReferences(PsiElement element3, Collection<? extends PsiReference> references2) {
        if (element3 instanceof KtObjectDeclaration && ((KtObjectDeclaration)element3).isCompanion()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = references2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PsiReference it = (PsiReference)element$iv$iv;
                boolean bl = false;
                if (!(!this.isCompanionObjectClassReference(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return references2;
    }

    private final boolean isCompanionObjectClassReference(PsiReference $this$isCompanionObjectClassReference) {
        return this.getRenameRefactoringSupport().isCompanionObjectClassReference($this$isCompanionObjectClassReference);
    }

    public void findCollisions(@NotNull PsiElement element3, @NotNull String newName2, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)element3);
        KtNamedDeclaration ktNamedDeclaration = psiNamedElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiNamedElement : null;
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration declaration2 = ktNamedDeclaration;
        SmartList collisions = new SmartList();
        this.getRenameRefactoringSupport().checkRedeclarations(declaration2, newName2, (List)collisions);
        this.getRenameRefactoringSupport().checkOriginalUsagesRetargeting(declaration2, newName2, result2, (List)collisions);
        this.getRenameRefactoringSupport().checkNewNameUsagesRetargeting(declaration2, newName2, (List)collisions);
        CollectionsKt.addAll((Collection)result2, (Iterable)((Iterable)collisions));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PsiElement getClassOrObject(PsiElement element3) {
        PsiElement psiElement2;
        PsiElement psiElement3 = element3;
        if (psiElement3 instanceof KtLightClass) {
            if (this.getRenameRefactoringSupport().isLightClassForRegularKotlinClass((KtLightClass)element3)) {
                psiElement2 = (PsiElement)((KtLightClass)element3).getKotlinOrigin();
                return psiElement2;
            } else {
                if (!(element3 instanceof KtLightClassForFacade)) throw new AssertionError((Object)("Should not be suggested to rename element of type " + element3.getClass() + " " + element3));
                psiElement2 = element3;
            }
            return psiElement2;
        } else if (psiElement3 instanceof KtConstructor) {
            psiElement2 = (PsiElement)((KtConstructor)element3).getContainingClassOrObject();
            return psiElement2;
        } else {
            if (!(psiElement3 instanceof KtClassOrObject ? true : psiElement3 instanceof KtTypeAlias)) return null;
            psiElement2 = element3;
        }
        return psiElement2;
    }

    @Override
    public void renameElement(@NotNull PsiElement element3, @NotNull String newName2, @NotNull UsageInfo[] usages2, @Nullable RefactoringElementListener listener2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        ArrayList simpleUsages = new ArrayList(usages2.length);
        SmartList ambiguousImportUsages = new SmartList();
        SmartList simpleImportUsages = new SmartList();
        int n = usages2.length;
        block5: for (int j = 0; j < n; ++j) {
            UsageInfo usage = usages2[j];
            switch (WhenMappings.$EnumSwitchMapping$0[this.importState(usage).ordinal()]) {
                case 1: {
                    ((Collection)ambiguousImportUsages).add(usage);
                    continue block5;
                }
                case 2: {
                    ((Collection)simpleImportUsages).add(usage);
                    continue block5;
                }
                case 3: {
                    ((Collection)simpleUsages).add(usage);
                }
            }
        }
        this.setAmbiguousImportUsages(element3, (List)ambiguousImportUsages);
        List usagesToRename = simpleImportUsages.isEmpty() ? (List)simpleUsages : CollectionsKt.plus((Collection)((Collection)simpleImportUsages), (Iterable)simpleUsages);
        Collection $this$toTypedArray$iv = usagesToRename;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        super.renameElement(element3, newName2, thisCollection$iv.toArray(new UsageInfo[0]), listener2);
        UsageInfo[] $this$forEach$iv = usages2;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (int j = 0; j < n2; ++j) {
            UsageInfo element$iv;
            UsageInfo it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            KtResolvableCollisionUsageInfo ktResolvableCollisionUsageInfo = it instanceof KtResolvableCollisionUsageInfo ? (KtResolvableCollisionUsageInfo)it : null;
            if (ktResolvableCollisionUsageInfo == null) continue;
            ktResolvableCollisionUsageInfo.apply();
        }
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element3, @NotNull SearchScope searchScope2, boolean searchInCommentsAndStrings) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        Collection<PsiReference> references2 = super.findReferences(element3, searchScope2, searchInCommentsAndStrings);
        return this.processFoundReferences(element3, references2);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RenameKotlinPsiProcessor.ImportState.values().length];
            try {
                nArray[RenameKotlinPsiProcessor.ImportState.AMBIGUOUS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenameKotlinPsiProcessor.ImportState.SIMPLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenameKotlinPsiProcessor.ImportState.NOT_IMPORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

