/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchySearchRequest;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u0012\u0010\b\u001a\f0\u0005\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticParameterRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "element", "Lorg/jetbrains/kotlin/psi/KtParameter;", "newName", "", "(Lorg/jetbrains/kotlin/psi/KtParameter;Ljava/lang/String;)V", "entityName", "getDialogDescription", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getDialogTitle", "isSelectedByDefault", "", "processHierarchy", "", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAutomaticParameterRenamer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutomaticParameterRenamer.kt\norg/jetbrains/kotlin/idea/refactoring/rename/AutomaticParameterRenamer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,67:1\n288#2,2:68\n1282#3,2:70\n*S KotlinDebug\n*F\n+ 1 AutomaticParameterRenamer.kt\norg/jetbrains/kotlin/idea/refactoring/rename/AutomaticParameterRenamer\n*L\n34#1:68,2\n35#1:70,2\n*E\n"})
public final class AutomaticParameterRenamer
extends AutomaticRenamer {
    public AutomaticParameterRenamer(@NotNull KtParameter element3, @NotNull String newName2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        this.processHierarchy(element3, newName2);
    }

    private final void processHierarchy(KtParameter element3, String newName2) {
        KtDeclarationWithBody ktDeclarationWithBody = element3.getOwnerFunction();
        if (ktDeclarationWithBody == null) {
            return;
        }
        KtDeclarationWithBody function2 = ktDeclarationWithBody;
        PsiElement psiElement2 = (PsiElement)function2;
        SearchScope searchScope2 = function2.getUseScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"function.useScope");
        for (PsiMethod overrider : OverridersSearchKt.searchOverriders(new HierarchySearchRequest(psiElement2, searchScope2, false, 4, null))) {
            PsiNamedElement parameter2;
            PsiNamedElement psiNamedElement;
            PsiNamedElement callable2;
            Intrinsics.checkNotNullExpressionValue((Object)overrider, (String)"overrider");
            if (LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)((PsiElement)overrider)) == null || !KotlinRefactoringUtilKt.canRefactor((PsiElement)callable2)) continue;
            PsiNamedElement psiNamedElement2 = callable2;
            if (psiNamedElement2 instanceof KtCallableDeclaration) {
                Object v4;
                block8: {
                    List list2 = ((KtCallableDeclaration)callable2).getValueParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"callable.valueParameters");
                    $this$firstOrNull$iv = (Object[])list2;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        KtParameter it = (KtParameter)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)element3.getName())) continue;
                        v4 = element$iv;
                        break block8;
                    }
                    v4 = null;
                }
                psiNamedElement = v4;
            } else if (psiNamedElement2 instanceof PsiMethod) {
                Object object;
                block9: {
                    PsiParameter[] psiParameterArray = ((PsiMethod)callable2).getParameterList().getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"callable.parameterList.parameters");
                    $this$firstOrNull$iv = psiParameterArray;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiParameter it = (PsiParameter)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)element3.getName())) continue;
                        object = element$iv;
                        break block9;
                    }
                    object = null;
                }
                psiNamedElement = (PsiNamedElement)object;
            } else {
                psiNamedElement = null;
            }
            if ((parameter2 = psiNamedElement) == null) continue;
            List list3 = this.myElements;
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"myElements");
            ((Collection)list3).add(parameter2);
        }
        this.suggestAllNames(element3.getName(), KtPsiUtilKt.quoteIfNeeded((String)newName2));
    }

    @NotNull
    public String getDialogTitle() {
        return KotlinBundle.message("text.rename.parameters.title", new Object[0]);
    }

    @NotNull
    public String getDialogDescription() {
        String string2 = RefactoringBundle.message((String)"title.rename.parameters.hierarchy");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"title.rename.parameters.hierarchy\")");
        return string2;
    }

    @NotNull
    public String entityName() {
        return KotlinBundle.message("text.parameter", new Object[0]);
    }

    public boolean isSelectedByDefault() {
        return true;
    }
}

