/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.pushDown;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.shorten.DelayedRequestsWaitingSetKt;
import org.jetbrains.kotlin.idea.core.util.ProgressUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KtPsiClassWrapper;
import org.jetbrains.kotlin.idea.refactoring.pullUp.MarkingUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pullUp.PullUpConflictsUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pullUp.PullUpUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownContext;
import org.jetbrains.kotlin.idea.refactoring.pushDown.KotlinPushDownHandlerKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.PushDownConflictsUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.pushDown.PushDownImplKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.search.declarationsSearch.ClassInheritorsSearchKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchySearchRequest;
import org.jetbrains.kotlin.idea.util.TypeUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002%&B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ!\u0010\f\u001a\u00060\rR\u00020\u00002\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u001d\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u001cJ\u001c\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0 H\u0014J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u001bH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "sourceClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "membersToMove", "", "Lorg/jetbrains/kotlin/idea/refactoring/memberInfo/KotlinMemberInfo;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtClass;Ljava/util/List;)V", "context", "Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownContext;", "createUsageViewDescriptor", "Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor$UsageViewDescriptorImpl;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor$UsageViewDescriptorImpl;", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "getAfterData", "Lcom/intellij/refactoring/listeners/RefactoringEventData;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/refactoring/listeners/RefactoringEventData;", "getBeforeData", "getCommandName", "", "performRefactoring", "", "([Lcom/intellij/usageView/UsageInfo;)V", "preprocessUsages", "", "refUsages", "Lcom/intellij/openapi/util/Ref;", "pushDownToClass", "targetClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "removeOriginalMembers", "SubclassUsage", "UsageViewDescriptorImpl", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinPushDownProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPushDownProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n1549#2:202\n1620#2,3:203\n1603#2,9:221\n1855#2:230\n1856#2:232\n1612#2:233\n1549#2:234\n1620#2,3:235\n1855#2,2:240\n37#3,2:206\n37#3,2:238\n11383#4,9:208\n13309#4:217\n13310#4:219\n11392#4:220\n13309#4:242\n13310#4:244\n1#5:218\n1#5:231\n1#5:243\n*S KotlinDebug\n*F\n+ 1 KotlinPushDownProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor\n*L\n83#1:202\n83#1:203,3\n92#1:221,9\n92#1:230\n92#1:232\n92#1:233\n93#1:234\n93#1:235,3\n192#1:240,2\n83#1:206,2\n94#1:238,2\n87#1:208,9\n87#1:217\n87#1:219\n87#1:220\n195#1:242\n195#1:244\n87#1:218\n92#1:231\n*E\n"})
public final class KotlinPushDownProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final KotlinPushDownContext context;

    public KotlinPushDownProcessor(@NotNull Project project2, @NotNull KtClass sourceClass, @NotNull List<KotlinMemberInfo> membersToMove) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceClass, (String)"sourceClass");
        Intrinsics.checkNotNullParameter(membersToMove, (String)"membersToMove");
        super(project2);
        this.context = new KotlinPushDownContext(sourceClass, membersToMove);
    }

    @NotNull
    protected String getCommandName() {
        return KotlinPushDownHandlerKt.getPUSH_MEMBERS_DOWN();
    }

    @NotNull
    protected UsageViewDescriptorImpl createUsageViewDescriptor(@NotNull UsageInfo[] usages2) {
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        return new UsageViewDescriptorImpl();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected RefactoringEventData getBeforeData() {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        RefactoringEventData refactoringEventData;
        RefactoringEventData $this$getBeforeData_u24lambda_u241 = refactoringEventData = new RefactoringEventData();
        boolean bl = false;
        $this$getBeforeData_u24lambda_u241.addElement((PsiElement)this.context.getSourceClass());
        Iterable iterable = this.context.getMembersToMove();
        RefactoringEventData refactoringEventData2 = $this$getBeforeData_u24lambda_u241;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinMemberInfo kotlinMemberInfo = (KotlinMemberInfo)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add((KtNamedDeclaration)it.getMember());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        refactoringEventData2.addElements((PsiElement[])thisCollection$iv.toArray(new KtNamedDeclaration[0]));
        return refactoringEventData;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        RefactoringEventData refactoringEventData;
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        RefactoringEventData $this$getAfterData_u24lambda_u243 = refactoringEventData = new RefactoringEventData();
        boolean bl = false;
        UsageInfo[] usageInfoArray = usages2;
        RefactoringEventData refactoringEventData2 = $this$getAfterData_u24lambda_u243;
        boolean $i$f$mapNotNull = false;
        void var8_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            KtClassOrObject it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl2 = false;
            void it = element$iv$iv;
            boolean bl3 = false;
            PsiElement psiElement2 = it.getElement();
            if ((psiElement2 instanceof KtClassOrObject ? (KtClassOrObject)psiElement2 : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        refactoringEventData2.addElements((Collection)((List)destination$iv$iv));
        return refactoringEventData;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected UsageInfo[] findUsages() {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        PsiElement psiElement2 = (PsiElement)this.context.getSourceClass();
        SearchScope searchScope2 = this.context.getSourceClass().getUseScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"context.sourceClass.useScope");
        Iterable $this$mapNotNull$iv = (Iterable)ClassInheritorsSearchKt.searchInheritors(new HierarchySearchRequest<PsiElement>(psiElement2, searchScope2, false));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        PsiElement psiElement3 = $this$forEach$iv$iv$iv.iterator();
        while (psiElement3.hasNext()) {
            PsiElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = psiElement3.next();
            boolean bl = false;
            PsiClass it = (PsiClass)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)it)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            psiElement3 = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SubclassUsage((PsiElement)p0));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new SubclassUsage[0]);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        Object[] objectArray;
        String message2;
        int answer;
        Intrinsics.checkNotNullParameter(refUsages, (String)"refUsages");
        UsageInfo[] usageInfoArray = (UsageInfo[])refUsages.get();
        if (usageInfoArray == null) {
            usageInfoArray = UsageInfo.EMPTY_ARRAY;
        }
        UsageInfo[] usages2 = usageInfoArray;
        Intrinsics.checkNotNullExpressionValue((Object)usages2, (String)"usages");
        if (usages2.length == 0 && (answer = Messages.showYesNoDialog((String)StringsKt.capitalize((String)(message2 = KotlinBundle.message("text.0.have.no.inheritors.warning", objectArray = new Object[]{PullUpConflictsUtilsKt.renderForConflicts((DeclarationDescriptor)this.context.getSourceClassDescriptor())}))), (String)KotlinPushDownHandlerKt.getPUSH_MEMBERS_DOWN(), (Icon)Messages.getWarningIcon())) == 1) {
            return false;
        }
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        String string2 = RefactoringBundle.message((String)"detecting.possible.conflicts");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"detecting.possible.conflicts\")");
        MultiMap multiMap = (MultiMap)ProgressUtilsKt.runSynchronouslyWithProgress(project2, string2, true, (Function0)new Function0<MultiMap<PsiElement, String>>(this, usages2){
            final /* synthetic */ KotlinPushDownProcessor this$0;
            final /* synthetic */ UsageInfo[] $usages;
            {
                this.this$0 = $receiver;
                this.$usages = $usages;
                super(0);
            }

            @NotNull
            public final MultiMap<PsiElement, String> invoke() {
                return (MultiMap)ActionsKt.runReadAction((Function0)((Function0)new Function0<MultiMap<PsiElement, String>>(this.this$0, this.$usages){
                    final /* synthetic */ KotlinPushDownProcessor this$0;
                    final /* synthetic */ UsageInfo[] $usages;
                    {
                        this.this$0 = $receiver;
                        this.$usages = $usages;
                        super(0);
                    }

                    @NotNull
                    public final MultiMap<PsiElement, String> invoke() {
                        KotlinPushDownContext kotlinPushDownContext = KotlinPushDownProcessor.access$getContext$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)this.$usages, (String)"usages");
                        return PushDownConflictsUtilsKt.analyzePushDownConflicts(kotlinPushDownContext, this.$usages);
                    }
                }));
            }
        });
        if (multiMap == null) {
            return false;
        }
        MultiMap conflicts2 = multiMap;
        return this.showConflicts(conflicts2, usages2);
    }

    private final void pushDownToClass(KtClassOrObject targetClass) {
        SimpleType simpleType = this.context.getSourceClassDescriptor().getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"context.sourceClassDescriptor.defaultType");
        SimpleType sourceClassType = simpleType;
        DeclarationDescriptor declarationDescriptor = ResolutionFacade.resolveToDescriptor$default(this.context.getResolutionFacade(), (KtDeclaration)targetClass, null, 2, null);
        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        ClassDescriptor targetClassDescriptor2 = (ClassDescriptor)declarationDescriptor;
        KotlinType kotlinType = (KotlinType)sourceClassType;
        SimpleType simpleType2 = targetClassDescriptor2.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"targetClassDescriptor.defaultType");
        LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = TypeUtils.getTypeSubstitution(kotlinType, (KotlinType)simpleType2);
        TypeSubstitutor substitutor3 = TypeUtils.orEmpty((TypeSubstitutor)(linkedHashMap != null ? TypeUtils.toSubstitutor((Map<TypeConstructor, ? extends TypeProjection>)linkedHashMap) : null));
        for (KotlinMemberInfo memberInfo : this.context.getMembersToMove()) {
            KtNamedDeclaration ktNamedDeclaration;
            KtNamedDeclaration member2 = (KtNamedDeclaration)memberInfo.getMember();
            if (this.context.getMemberDescriptors().get(member2) == null) continue;
            KtNamedDeclaration ktNamedDeclaration2 = member2;
            if (ktNamedDeclaration2 instanceof KtProperty ? true : ktNamedDeclaration2 instanceof KtNamedFunction) {
                CallableMemberDescriptor cfr_ignored_0 = (CallableMemberDescriptor)memberDescriptor;
                Intrinsics.checkNotNull((Object)member2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
                ktNamedDeclaration = (KtNamedDeclaration)PushDownImplKt.moveCallableMemberToClass((KtCallableDeclaration)member2, (CallableMemberDescriptor)memberDescriptor, targetClass, targetClassDescriptor2, substitutor3, memberInfo.isToAbstract());
            } else {
                if (!(ktNamedDeclaration2 instanceof KtClassOrObject ? true : ktNamedDeclaration2 instanceof KtPsiClassWrapper)) continue;
                if (memberInfo.getOverrides() != null) {
                    KtSuperTypeListEntry ktSuperTypeListEntry = PullUpUtilsKt.getSuperTypeEntryByDescriptor((KtClassOrObject)this.context.getSourceClass(), (ClassDescriptor)memberDescriptor, this.context.getSourceClassContext());
                    if (ktSuperTypeListEntry == null) continue;
                    KtSuperTypeListEntry it = ktSuperTypeListEntry;
                    boolean bl = false;
                    PullUpUtilsKt.addSuperTypeEntry(it, targetClass, targetClassDescriptor2, this.context.getSourceClassContext(), substitutor3);
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)member2, (String)"member");
                ktNamedDeclaration = PullUpUtilsKt.addMemberToTarget(member2, targetClass);
            }
            KtNamedDeclaration movedMember = ktNamedDeclaration;
            MarkingUtilsKt.applyMarking(movedMember, substitutor3, targetClassDescriptor2);
        }
    }

    private final void removeOriginalMembers() {
        for (KotlinMemberInfo memberInfo : this.context.getMembersToMove()) {
            DeclarationDescriptor memberDescriptor;
            KtNamedDeclaration member2 = (KtNamedDeclaration)memberInfo.getMember();
            if (this.context.getMemberDescriptors().get(member2) == null) continue;
            KtNamedDeclaration ktNamedDeclaration = member2;
            if (ktNamedDeclaration instanceof KtProperty ? true : ktNamedDeclaration instanceof KtNamedFunction) {
                Intrinsics.checkNotNull((Object)member2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
                KtCallableDeclaration cfr_ignored_0 = (KtCallableDeclaration)member2;
                CallableMemberDescriptor cfr_ignored_1 = (CallableMemberDescriptor)memberDescriptor;
                if (((CallableMemberDescriptor)memberDescriptor).getModality() != Modality.ABSTRACT && memberInfo.isToAbstract()) {
                    if (member2.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                        member2.addModifier(KtTokens.PROTECTED_KEYWORD);
                    }
                    KtCallableDeclaration ktCallableDeclaration2 = (KtCallableDeclaration)member2;
                    CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)memberDescriptor;
                    TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.EMPTY;
                    Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"EMPTY");
                    PullUpUtilsKt.makeAbstract(ktCallableDeclaration2, callableMemberDescriptor, typeSubstitutor2, this.context.getSourceClass());
                    KtTypeReference ktTypeReference = ((KtCallableDeclaration)member2).getTypeReference();
                    if (ktTypeReference != null) {
                        DelayedRequestsWaitingSetKt.addToShorteningWaitSet$default((KtElement)ktTypeReference, null, 1, null);
                    }
                    continue;
                }
                member2.delete();
                continue;
            }
            if (!(ktNamedDeclaration instanceof KtClassOrObject ? true : ktNamedDeclaration instanceof KtPsiClassWrapper)) continue;
            if (memberInfo.getOverrides() != null) {
                KtSuperTypeListEntry ktSuperTypeListEntry = PullUpUtilsKt.getSuperTypeEntryByDescriptor((KtClassOrObject)this.context.getSourceClass(), (ClassDescriptor)memberDescriptor, this.context.getSourceClassContext());
                if (ktSuperTypeListEntry == null) continue;
                KtSuperTypeListEntry it = ktSuperTypeListEntry;
                boolean bl = false;
                this.context.getSourceClass().removeSuperTypeListEntry(it);
                continue;
            }
            member2.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages2) {
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        ArrayList markedElements = new ArrayList();
        try {
            UsageInfo[] $this$forEach$iv = (UsageInfo[])this.context.getMembersToMove();
            boolean $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                KotlinMemberInfo it = (KotlinMemberInfo)((Object)t);
                boolean bl = false;
                Collection collection = markedElements;
                PsiElement psiElement2 = it.getMember();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"it.member");
                CollectionsKt.addAll((Collection)collection, (Iterable)MarkingUtilsKt.markElements((KtNamedDeclaration)psiElement2, this.context.getSourceClassContext(), this.context.getSourceClassDescriptor(), null));
            }
            $this$forEach$iv = usages2;
            $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                KtClassOrObject it;
                UsageInfo element$iv;
                UsageInfo it2 = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                PsiElement psiElement3 = it2.getElement();
                if ((psiElement3 instanceof KtClassOrObject ? (KtClassOrObject)psiElement3 : null) == null) continue;
                it = it;
                boolean bl2 = false;
                this.pushDownToClass(it);
            }
            this.removeOriginalMembers();
        }
        finally {
            MarkingUtilsKt.clearMarking(markedElements);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor$SubclassUsage;", "Lcom/intellij/usageView/UsageInfo;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "kotlin.idea"})
    public static final class SubclassUsage
    extends UsageInfo {
        public SubclassUsage(@NotNull PsiElement element3) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            super(element3);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor$UsageViewDescriptorImpl;", "Lcom/intellij/usageView/UsageViewDescriptor;", "(Lorg/jetbrains/kotlin/idea/refactoring/pushDown/KotlinPushDownProcessor;)V", "getCodeReferencesText", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "usagesCount", "", "filesCount", "getCommentReferencesText", "", "getElements", "", "Lorg/jetbrains/kotlin/psi/KtClass;", "()[Lorg/jetbrains/kotlin/psi/KtClass;", "getProcessedElementsHeader", "kotlin.idea"})
    public final class UsageViewDescriptorImpl
    implements UsageViewDescriptor {
        @NotNull
        public String getProcessedElementsHeader() {
            String string2 = RefactoringBundle.message((String)"push.down.members.elements.header");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"push.down.members.elements.header\")");
            return string2;
        }

        @NotNull
        public KtClass[] getElements() {
            KtClass[] ktClassArray = new KtClass[]{KotlinPushDownProcessor.this.context.getSourceClass()};
            return ktClassArray;
        }

        @NotNull
        public String getCodeReferencesText(int usagesCount, int filesCount) {
            Object[] objectArray = new Object[]{UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount)};
            String string2 = RefactoringBundle.message((String)"classes.to.push.down.members.to", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"classes.to.push\u2026usagesCount, filesCount))");
            return string2;
        }

        @Nullable
        public Void getCommentReferencesText(int usagesCount, int filesCount) {
            return null;
        }
    }
}

