/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveConflictCheckerInfo;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveConflictCheckerSupport;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveRenameUsage;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveTarget;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0000\u001aX\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0018\u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a8\u0006\u0010"}, d2={"analyzeConflictsInFile", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "moveTarget", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget;", "allElementsToMove", "onUsageUpdate", "Lkotlin/Function1;", "", "", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nKotlinMoveConflictCheckerSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMoveConflictCheckerSupport.kt\norg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveConflictCheckerSupportKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n3190#2,10:94\n*S KotlinDebug\n*F\n+ 1 KotlinMoveConflictCheckerSupport.kt\norg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveConflictCheckerSupportKt\n*L\n23#1:94,10\n*E\n"})
public final class KotlinMoveConflictCheckerSupportKt {
    @NotNull
    public static final MultiMap<PsiElement, String> analyzeConflictsInFile(@NotNull KtFile file2, @NotNull Collection<? extends UsageInfo> usages2, @NotNull KotlinMoveTarget moveTarget2, @NotNull Collection<? extends PsiElement> allElementsToMove, @NotNull Function1<? super List<? extends UsageInfo>, Unit> onUsageUpdate) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(usages2, (String)"usages");
        Intrinsics.checkNotNullParameter((Object)moveTarget2, (String)"moveTarget");
        Intrinsics.checkNotNullParameter(allElementsToMove, (String)"allElementsToMove");
        Intrinsics.checkNotNullParameter(onUsageUpdate, (String)"onUsageUpdate");
        List elementsToMove = file2.getDeclarations();
        if (elementsToMove.isEmpty()) {
            MultiMap multiMap = MultiMap.empty();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"empty()");
            return multiMap;
        }
        Iterable $this$partition$iv = usages2;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            UsageInfo it = (UsageInfo)element$iv;
            boolean bl = false;
            if (it instanceof KotlinMoveRenameUsage && ((KotlinMoveRenameUsage)it).isInternal()) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List internalUsages = (List)pair.component1();
        List externalUsages = (List)pair.component2();
        Set internalUsageSet = CollectionsKt.toMutableSet((Iterable)internalUsages);
        Set externalUsageSet = CollectionsKt.toMutableSet((Iterable)externalUsages);
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
        KotlinMoveConflictCheckerInfo moveCheckerInfo = new KotlinMoveConflictCheckerInfo(project2, elementsToMove, moveTarget2, (KtElement)CollectionsKt.first((List)elementsToMove), allElementsToMove);
        MultiMap<PsiElement, String> conflicts2 = KotlinMoveConflictCheckerSupport.Companion.getInstance().checkAllConflicts(moveCheckerInfo, internalUsageSet, externalUsageSet);
        if (externalUsageSet.size() != externalUsages.size() || internalUsageSet.size() != internalUsages.size()) {
            onUsageUpdate.invoke((Object)CollectionsKt.toList((Iterable)SetsKt.plus((Set)externalUsageSet, (Iterable)internalUsageSet)));
        }
        return conflicts2;
    }
}

