/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.BaseRefactoringProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractKotlinInlineDialog;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlinePropertyDialog;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlinePropertyProcessor;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u0006\u0010\u0019\u001a\u00020\tR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlinePropertyDialog;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineDialog;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "reference", "Lcom/intellij/psi/PsiReference;", "assignmentToDelete", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "withPreview", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lcom/intellij/psi/PsiReference;Lorg/jetbrains/kotlin/psi/KtBinaryExpression;ZLcom/intellij/openapi/editor/Editor;)V", "inlineKeepOption", "Lkotlin/reflect/KMutableProperty1;", "Lorg/jetbrains/kotlin/idea/refactoring/KotlinRefactoringSettings;", "getInlineKeepOption", "()Lkotlin/reflect/KMutableProperty1;", "inlineThisOption", "getInlineThisOption", "simpleLocal", "createProcessor", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "doHelpAction", "", "shouldBeShown", "kotlin.idea"})
public final class KotlinInlinePropertyDialog
extends AbstractKotlinInlineDialog<KtProperty> {
    @Nullable
    private final KtBinaryExpression assignmentToDelete;
    private final boolean simpleLocal;

    public KotlinInlinePropertyDialog(@NotNull KtProperty property2, @Nullable PsiReference reference2, @Nullable KtBinaryExpression assignmentToDelete, boolean withPreview, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        super((KtNamedDeclaration)property2, reference2, editor2);
        this.assignmentToDelete = assignmentToDelete;
        this.simpleLocal = ((KtProperty)this.getDeclaration()).isLocal() && (reference2 == null || this.getOccurrencesNumber() == 1);
        this.setPreviewResults(withPreview && this.shouldBeShown());
        if (this.simpleLocal) {
            this.setDoNotAskOption(new DoNotAskOption(){

                public boolean isToBeShown() {
                    return EditorSettingsExternalizable.getInstance().isShowInlineLocalDialog();
                }

                public void setToBeShown(boolean value2, int exitCode) {
                    EditorSettingsExternalizable.getInstance().setShowInlineLocalDialog(value2);
                }

                public boolean canBeHidden() {
                    return true;
                }

                public boolean shouldSaveOptionsOnCancel() {
                    return false;
                }

                @NotNull
                public String getDoNotShowMessage() {
                    return KotlinBundle.message("message.do.not.show.for.local.variables.in.future", new Object[0]);
                }
            });
        }
        this.init();
    }

    public /* synthetic */ KotlinInlinePropertyDialog(KtProperty ktProperty, PsiReference psiReference, KtBinaryExpression ktBinaryExpression, boolean bl, Editor editor2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(ktProperty, psiReference, ktBinaryExpression, bl, editor2);
    }

    public final boolean shouldBeShown() {
        return !this.simpleLocal || this.getReference() != null && EditorSettingsExternalizable.getInstance().isShowInlineLocalDialog();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.inlineVariable");
    }

    @Override
    @NotNull
    public KMutableProperty1<KotlinRefactoringSettings, Boolean> getInlineThisOption() {
        return (KMutableProperty1)inlineThisOption.1.INSTANCE;
    }

    @Override
    @NotNull
    public KMutableProperty1<KotlinRefactoringSettings, Boolean> getInlineKeepOption() {
        return (KMutableProperty1)inlineKeepOption.1.INSTANCE;
    }

    @Override
    @NotNull
    public BaseRefactoringProcessor createProcessor() {
        KtProperty ktProperty = (KtProperty)this.getDeclaration();
        PsiReference psiReference = this.getReference();
        boolean bl = this.isInlineThisOnly();
        boolean bl2 = !this.isInlineThisOnly() && (!this.isKeepTheDeclaration() || this.getReference() == null);
        PsiElement psiElement2 = ((KtProperty)this.getDeclaration()).getParent();
        KtWhenExpression ktWhenExpression = psiElement2 instanceof KtWhenExpression ? (KtWhenExpression)psiElement2 : null;
        boolean bl3 = Intrinsics.areEqual((Object)(ktWhenExpression != null ? ktWhenExpression.getSubjectVariable() : null), this.getDeclaration());
        Editor editor2 = this.getEditor();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        return new KotlinInlinePropertyProcessor(ktProperty, psiReference, bl, bl2, bl3, editor2, this.assignmentToDelete, project2);
    }
}

