/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.IntentionActionPriority;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactoryWithDelegate;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003\u0018\u0019\u001aB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J#\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096\u0002J\"\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "element", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "typePresentation", "", "typeSourceCode", "upOrDownCast", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "Factory", "GenericVarianceConversion", "SmartCastImpossibleFactory", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nCastExpressionFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CastExpressionFix.kt\norg/jetbrains/kotlin/idea/quickfix/CastExpressionFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,66:1\n1#2:67\n21#3,7:68\n*S KotlinDebug\n*F\n+ 1 CastExpressionFix.kt\norg/jetbrains/kotlin/idea/quickfix/CastExpressionFix\n*L\n46#1:68,7\n*E\n"})
public final class CastExpressionFix
extends KotlinQuickFixAction<KtExpression>
implements LowPriorityAction {
    @NotNull
    private final String typePresentation;
    @NotNull
    private final String typeSourceCode;
    private final boolean upOrDownCast;

    public CastExpressionFix(@NotNull KtExpression element3, @NotNull KotlinType type2) {
        CastExpressionFix it;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        super((PsiElement)element3);
        this.typePresentation = IdeDescriptorRenderers.SOURCE_CODE_TYPES_WITH_SHORT_NAMES.renderType(type2);
        String string2 = IdeDescriptorRenderers.SOURCE_CODE_TYPES.renderType(type2);
        CastExpressionFix castExpressionFix = this;
        boolean bl = false;
        castExpressionFix.typeSourceCode = SpecialTypesKt.isDefinitelyNotNullType((KotlinType)type2) ? "(" + (String)((Object)it) + ")" : it;
        it = this;
        castExpressionFix = this;
        boolean bl2 = false;
        KotlinType expressionType2 = ResolutionUtils.analyze((KtElement)element3, BodyResolveMode.PARTIAL).getType(element3);
        boolean bl3 = expressionType2 != null && (TypeUtilsKt.isSubtypeOf((KotlinType)type2, (KotlinType)expressionType2) || TypeUtilsKt.isSubtypeOf((KotlinType)expressionType2, (KotlinType)type2)) && !Intrinsics.areEqual((Object)expressionType2, (Object)TypeUtilsKt.makeNullable((KotlinType)type2));
        castExpressionFix.upOrDownCast = bl3;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.cast.expression.family", new Object[0]);
    }

    @NotNull
    public String getText() {
        Object object;
        block3: {
            block2: {
                object = (KtExpression)this.getElement();
                if (object == null) break block2;
                KtExpression it = object;
                boolean bl = false;
                Object[] objectArray = new Object[2];
                Intrinsics.checkNotNullExpressionValue((Object)it.getText(), (String)"it.text");
                objectArray[1] = this.typePresentation;
                String string2 = KotlinBundle.message("fix.cast.expression.text", objectArray);
                object = string2;
                if (string2 != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @Override
    protected boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.upOrDownCast;
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        block6: {
            PsiElement psiElement2;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KtExpression ktExpression = (KtExpression)this.getElement();
            if (ktExpression == null) {
                return;
            }
            KtExpression element3 = ktExpression;
            Object[] objectArray = new Object[]{element3, this.typeSourceCode};
            KtExpression expressionToInsert = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project2, false, 2, null), (String)"$0 as $1", (Object[])objectArray, (boolean)false, (int)4, null);
            PsiElement $this$replaced$iv = (PsiElement)element3;
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)expressionToInsert))) {
                psiElement2 = (PsiElement)expressionToInsert;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace((PsiElement)expressionToInsert);
                if (result$iv instanceof KtExpression) {
                    psiElement2 = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression2 = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement2 = (PsiElement)ktExpression2;
                }
            }
            KtExpression newExpression2 = (KtExpression)psiElement2;
            KtExpression ktExpression3 = KtPsiUtil.safeDeparenthesize((KtExpression)newExpression2);
            Intrinsics.checkNotNull((Object)ktExpression3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS");
            KtTypeReference ktTypeReference = ((KtBinaryExpressionWithTypeRHS)ktExpression3).getRight();
            Intrinsics.checkNotNull((Object)ktTypeReference);
            ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)ktTypeReference, null, 2, null);
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getCaretModel()) == null) break block6;
            editor3.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)newExpression2)));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactoryWithDelegate;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/types/KotlinType;", "()V", "createFix", "Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix;", "originalElement", "data", "getElementOfInterest", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static abstract class Factory
    extends KotlinSingleIntentionActionFactoryWithDelegate<KtExpression, KotlinType> {
        public Factory() {
            super(IntentionActionPriority.LOW);
        }

        @Override
        @Nullable
        public KtExpression getElementOfInterest(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            return psiElement2 instanceof KtExpression ? (KtExpression)psiElement2 : null;
        }

        @NotNull
        protected CastExpressionFix createFix(@NotNull KtExpression originalElement, @NotNull KotlinType data2) {
            Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            return new CastExpressionFix(originalElement, data2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$GenericVarianceConversion;", "Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$Factory;", "()V", "extractFixData", "Lorg/jetbrains/kotlin/types/KotlinType;", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class GenericVarianceConversion
    extends Factory {
        @NotNull
        public static final GenericVarianceConversion INSTANCE = new GenericVarianceConversion();

        private GenericVarianceConversion() {
        }

        @Override
        @NotNull
        public KotlinType extractFixData(@NotNull KtExpression element3, @NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            Object object = ((DiagnosticWithParameters2)ErrorsJvm.JAVA_TYPE_MISMATCH.cast((UnboundDiagnostic)diagnostic)).getB();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"JAVA_TYPE_MISMATCH.cast(diagnostic).b");
            return (KotlinType)FlexibleTypesKt.asFlexibleType((KotlinType)((KotlinType)object)).getUpperBound();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$SmartCastImpossibleFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/CastExpressionFix$Factory;", "()V", "extractFixData", "Lorg/jetbrains/kotlin/types/KotlinType;", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class SmartCastImpossibleFactory
    extends Factory {
        @NotNull
        public static final SmartCastImpossibleFactory INSTANCE = new SmartCastImpossibleFactory();

        private SmartCastImpossibleFactory() {
        }

        @Override
        @NotNull
        public KotlinType extractFixData(@NotNull KtExpression element3, @NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            Object object = ((DiagnosticWithParameters3)Errors.SMARTCAST_IMPOSSIBLE.cast((UnboundDiagnostic)diagnostic)).getA();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SMARTCAST_IMPOSSIBLE.cast(diagnostic).a");
            return (KotlinType)object;
        }
    }
}

