/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\nH\u0002\u001a\f\u0010\u0012\u001a\u00020\n*\u00020\u0002H\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001a\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"rBraceOffSetTextRange", "Lcom/intellij/openapi/util/TextRange;", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "getRBraceOffSetTextRange", "(Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;)Lcom/intellij/openapi/util/TextRange;", "singleReturnExpressionOrNull", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "getSingleReturnExpressionOrNull", "(Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;)Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "singleReturnedExpressionOrNull", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getSingleReturnedExpressionOrNull", "(Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;)Lorg/jetbrains/kotlin/psi/KtExpression;", "correctRightMargin", "", "Lcom/intellij/openapi/editor/Editor;", "declaration", "newBody", "replaceWithPreservingComments", "selectFunctionColonType", "newFunctionBody", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "kotlin.code-insight.intentions-k2"})
@SourceDebugExtension(value={"SMAP\nUseExpressionBodyIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseExpressionBodyIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/UseExpressionBodyIntentionKt\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,114:1\n21#2,7:115\n*S KotlinDebug\n*F\n+ 1 UseExpressionBodyIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/UseExpressionBodyIntentionKt\n*L\n73#1:115,7\n*E\n"})
public final class UseExpressionBodyIntentionKt {
    private static final KtExpression replaceWithPreservingComments(KtDeclarationWithBody $this$replaceWithPreservingComments) {
        PsiElement psiElement2;
        KtBlockExpression ktBlockExpression = $this$replaceWithPreservingComments.getBodyBlockExpression();
        if (ktBlockExpression == null) {
            return (KtExpression)$this$replaceWithPreservingComments;
        }
        KtBlockExpression bodyBlock = ktBlockExpression;
        KtExpression ktExpression = UseExpressionBodyIntentionKt.getSingleReturnedExpressionOrNull($this$replaceWithPreservingComments);
        if (ktExpression == null) {
            return (KtExpression)$this$replaceWithPreservingComments;
        }
        KtExpression returnedExpression = ktExpression;
        CommentSaver commentSaver = new CommentSaver((PsiElement)bodyBlock, false, 2, null);
        Project project2 = $this$replaceWithPreservingComments.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
        PsiElement eq = $this$replaceWithPreservingComments.addBefore(factory2.createEQ(), (PsiElement)$this$replaceWithPreservingComments.getBodyBlockExpression());
        $this$replaceWithPreservingComments.addAfter(factory2.createWhiteSpace(), eq);
        PsiElement $this$replaced$iv = (PsiElement)bodyBlock;
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)returnedExpression))) {
            psiElement2 = (PsiElement)returnedExpression;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace((PsiElement)returnedExpression);
            if (result$iv instanceof KtExpression) {
                psiElement2 = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression2 = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement2 = (PsiElement)ktExpression2;
            }
        }
        KtExpression newBody = (KtExpression)psiElement2;
        CommentSaver.restore$default(commentSaver, (PsiElement)newBody, false, 2, null);
        return newBody;
    }

    private static final void correctRightMargin(Editor $this$correctRightMargin, KtDeclarationWithBody declaration2, KtExpression newBody) {
        Project project2 = declaration2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"declaration.project");
        KtPsiFactory kotlinFactory = new KtPsiFactory(project2, false, 2, null);
        int startOffset = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)newBody));
        int startLine = $this$correctRightMargin.getDocument().getLineNumber(startOffset);
        int rightMargin = $this$correctRightMargin.getSettings().getRightMargin($this$correctRightMargin.getProject());
        if ($this$correctRightMargin.getDocument().getLineEndOffset(startLine) - $this$correctRightMargin.getDocument().getLineStartOffset(startLine) >= rightMargin) {
            declaration2.addBefore(kotlinFactory.createNewLine(), (PsiElement)newBody);
        }
    }

    private static final void selectFunctionColonType(Editor $this$selectFunctionColonType, KtNamedFunction newFunctionBody) {
        PsiElement psiElement2 = newFunctionBody.getColon();
        if (psiElement2 == null) {
            return;
        }
        PsiElement colon = psiElement2;
        KtTypeReference ktTypeReference = newFunctionBody.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference2 = ktTypeReference;
        $this$selectFunctionColonType.getSelectionModel().setSelection(PsiUtilsKt.getStartOffset((PsiElement)colon), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)typeReference2)));
        $this$selectFunctionColonType.getCaretModel().moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)typeReference2)));
    }

    private static final KtReturnExpression getSingleReturnExpressionOrNull(KtDeclarationWithBody $this$singleReturnExpressionOrNull) {
        Object object = $this$singleReturnExpressionOrNull.getBodyBlockExpression();
        KtExpression ktExpression = object != null && (object = object.getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)object) : null;
        return ktExpression instanceof KtReturnExpression ? (KtReturnExpression)ktExpression : null;
    }

    private static final KtExpression getSingleReturnedExpressionOrNull(KtDeclarationWithBody $this$singleReturnedExpressionOrNull) {
        KtReturnExpression ktReturnExpression = UseExpressionBodyIntentionKt.getSingleReturnExpressionOrNull($this$singleReturnedExpressionOrNull);
        return ktReturnExpression != null ? ktReturnExpression.getReturnedExpression() : null;
    }

    private static final TextRange getRBraceOffSetTextRange(KtDeclarationWithBody $this$rBraceOffSetTextRange) {
        KtBlockExpression ktBlockExpression = $this$rBraceOffSetTextRange.getBodyBlockExpression();
        if (ktBlockExpression == null || (ktBlockExpression = ktBlockExpression.getRBrace()) == null) {
            return null;
        }
        KtBlockExpression rightBlockBodyBrace = ktBlockExpression;
        return rightBlockBodyBrace.getTextRange().shiftLeft(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)$this$rBraceOffSetTextRange)));
    }

    public static final /* synthetic */ KtReturnExpression access$getSingleReturnExpressionOrNull(KtDeclarationWithBody $receiver) {
        return UseExpressionBodyIntentionKt.getSingleReturnExpressionOrNull($receiver);
    }

    public static final /* synthetic */ TextRange access$getRBraceOffSetTextRange(KtDeclarationWithBody $receiver) {
        return UseExpressionBodyIntentionKt.getRBraceOffSetTextRange($receiver);
    }

    public static final /* synthetic */ KtExpression access$getSingleReturnedExpressionOrNull(KtDeclarationWithBody $receiver) {
        return UseExpressionBodyIntentionKt.getSingleReturnedExpressionOrNull($receiver);
    }

    public static final /* synthetic */ KtExpression access$replaceWithPreservingComments(KtDeclarationWithBody $receiver) {
        return UseExpressionBodyIntentionKt.replaceWithPreservingComments($receiver);
    }

    public static final /* synthetic */ void access$correctRightMargin(Editor $receiver, KtDeclarationWithBody declaration2, KtExpression newBody) {
        UseExpressionBodyIntentionKt.correctRightMargin($receiver, declaration2, newBody);
    }

    public static final /* synthetic */ void access$selectFunctionColonType(Editor $receiver, KtNamedFunction newFunctionBody) {
        UseExpressionBodyIntentionKt.selectFunctionColonType($receiver, newFunctionBody);
    }
}

