/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal.makeBackup;

import com.intellij.compiler.server.BuildManager;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.RevisionsCollector;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.history.integration.patches.PatchCreator;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.io.ZipUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.internal.makeBackup.CreateIncrementalCompilationBackup;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/internal/makeBackup/CreateIncrementalCompilationBackup;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "copyLogs", "backupDir", "Ljava/io/File;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "copyProjectSystemDir", "project", "Lcom/intellij/openapi/project/Project;", "createPatches", "zipProjectDir", "projectDir", "Companion", "kotlin.jvm"})
public final class CreateIncrementalCompilationBackup
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String BACKUP_DIR_NAME = ".backup";
    public static final int PATCHES_TO_CREATE = 5;
    public static final double PATCHES_FRACTION = 0.25;
    public static final double LOGS_FRACTION = 0.05;
    public static final double PROJECT_SYSTEM_FRACTION = 0.05;
    public static final double ZIP_FRACTION = 0.6499999999999999;

    public CreateIncrementalCompilationBackup() {
        super(KotlinJvmBundle.message("create.backup.for.debugging.kotlin.incremental.compilation", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        Intrinsics.checkNotNull((Object)project2);
        Project project3 = project2;
        VirtualFile virtualFile2 = project3.getBaseDir();
        Intrinsics.checkNotNull((Object)virtualFile2);
        File projectBaseDir = new File(virtualFile2.getPath());
        File backupDir = new File(FileUtil.createTempDirectory((String)"makeBackup", null), BACKUP_DIR_NAME);
        String string2 = KotlinJvmBundle.message("creating.backup.for.debugging.kotlin.incremental.compilation", new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project3, this, backupDir, projectBaseDir, string2){
            final /* synthetic */ Project $project;
            final /* synthetic */ CreateIncrementalCompilationBackup this$0;
            final /* synthetic */ File $backupDir;
            final /* synthetic */ File $projectBaseDir;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$backupDir = $backupDir;
                this.$projectBaseDir = $projectBaseDir;
                super($project, $super_call_param$1, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                CreateIncrementalCompilationBackup.access$createPatches(this.this$0, this.$backupDir, this.$project, indicator);
                CreateIncrementalCompilationBackup.access$copyLogs(this.this$0, this.$backupDir, indicator);
                CreateIncrementalCompilationBackup.access$copyProjectSystemDir(this.this$0, this.$backupDir, this.$project, indicator);
                CreateIncrementalCompilationBackup.access$zipProjectDir(this.this$0, this.$backupDir, this.$project, this.$projectBaseDir, indicator);
            }
        });
    }

    private final void createPatches(File backupDir, Project project2, ProgressIndicator indicator) {
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(project2, backupDir, indicator){
            final /* synthetic */ Project $project;
            final /* synthetic */ File $backupDir;
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.$project = $project;
                this.$backupDir = $backupDir;
                this.$indicator = $indicator;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                LocalHistoryImpl localHistoryImpl = LocalHistoryImpl.getInstanceImpl();
                Intrinsics.checkNotNull((Object)localHistoryImpl);
                LocalHistoryImpl localHistoryImpl2 = localHistoryImpl;
                IdeaGateway ideaGateway = localHistoryImpl2.getGateway();
                Intrinsics.checkNotNull((Object)ideaGateway);
                IdeaGateway gateway = ideaGateway;
                LocalHistoryFacade localHistoryFacade = localHistoryImpl2.getFacade();
                RootEntry rootEntry = gateway.createTransientRootEntry();
                VirtualFile virtualFile2 = this.$project.getBaseDir();
                Intrinsics.checkNotNull((Object)virtualFile2);
                RevisionsCollector revisionsCollector = new RevisionsCollector(localHistoryFacade, rootEntry, virtualFile2.getPath(), this.$project.getLocationHash(), null);
                int patchesCreated = 0;
                File patchesDir = new File(this.$backupDir, "patches");
                patchesDir.mkdirs();
                List list2 = revisionsCollector.getResult();
                Intrinsics.checkNotNull((Object)list2);
                List revisions = list2;
                for (Revision rev : revisions) {
                    void $this$mapTo$iv$iv;
                    List differences;
                    String label2 = rev.getLabel();
                    if (label2 == null || !StringsKt.startsWith$default((String)label2, (String)"build started ", (boolean)false, (int)2, null)) continue;
                    File patchFile = new File(patchesDir, StringsKt.removePrefix((String)label2, (CharSequence)"build started ") + ".patch");
                    Object[] objectArray = new Object[]{patchFile};
                    this.$indicator.setText(KotlinJvmBundle.message("creating.patch.0", objectArray));
                    this.$indicator.setFraction(0.25 * (double)patchesCreated / (double)5);
                    Intrinsics.checkNotNull((Object)((Revision)revisions.get(0)).getDifferencesWith(rev));
                    Iterable $this$map$iv = differences;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void d;
                        Difference difference = (Difference)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new Change(d.getLeftContentRevision(gateway), d.getRightContentRevision(gateway)));
                    }
                    List changes = (List)destination$iv$iv;
                    PatchCreator.create((Project)this.$project, (List)changes, (Path)patchFile.toPath(), (boolean)false, null);
                    if (++patchesCreated < 5) continue;
                    break;
                }
            }
        }));
    }

    private final void copyLogs(File backupDir, ProgressIndicator indicator) {
        indicator.setText(KotlinJvmBundle.message("copying.logs", new Object[0]));
        indicator.setFraction(0.25);
        File logsDir = new File(backupDir, "logs");
        FileUtil.copyDir((File)new File(PathManager.getLogPath()), (File)logsDir);
        indicator.setFraction(0.3);
    }

    private final void copyProjectSystemDir(File backupDir, Project project2, ProgressIndicator indicator) {
        indicator.setText(KotlinJvmBundle.message("copying.project.s.system.dir", new Object[0]));
        indicator.setFraction(0.25);
        File projectSystemDir = new File(backupDir, "project-system");
        FileUtil.copyDir((File)BuildManager.getInstance().getProjectSystemDirectory(project2), (File)projectSystemDir);
        indicator.setFraction(0.35);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zipProjectDir(File backupDir, Project project2, File projectDir, ProgressIndicator indicator) {
        ArrayList<Pair<File, String>> files2 = new ArrayList<Pair<File, String>>();
        Ref.LongRef totalBytes = new Ref.LongRef();
        Object[] objectArray = new File[2];
        objectArray[0] = projectDir;
        Intrinsics.checkNotNull((Object)backupDir.getParentFile());
        for (File dir : CollectionsKt.listOf((Object[])objectArray)) {
            FileUtil.processFilesRecursively((File)dir, arg_0 -> CreateIncrementalCompilationBackup.zipProjectDir$lambda$0((Function1)new Function1<File, Boolean>(indicator, files2, dir, totalBytes){
                final /* synthetic */ ProgressIndicator $indicator;
                final /* synthetic */ ArrayList<Pair<File, String>> $files;
                final /* synthetic */ File $dir;
                final /* synthetic */ Ref.LongRef $totalBytes;
                {
                    this.$indicator = $indicator;
                    this.$files = $files;
                    this.$dir = $dir;
                    this.$totalBytes = $totalBytes;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(File it) {
                    block2: {
                        block3: {
                            File file2 = it;
                            Intrinsics.checkNotNull((Object)file2);
                            if (!file2.isFile()) break block2;
                            String string2 = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                            if (StringsKt.endsWith$default((String)string2, (String)".hprof", (boolean)false, (int)2, null)) break block2;
                            String string3 = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.name");
                            if (!StringsKt.startsWith$default((String)string3, (String)"make_backup_", (boolean)false, (int)2, null)) break block3;
                            String string4 = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.name");
                            if (StringsKt.endsWith$default((String)string4, (String)".zip", (boolean)false, (int)2, null)) break block2;
                        }
                        Object[] objectArray = new Object[]{it};
                        this.$indicator.setText(KotlinJvmBundle.message("scanning.project.dir.0", objectArray));
                        String string5 = FileUtil.getRelativePath((File)this.$dir, (File)it);
                        Intrinsics.checkNotNull((Object)string5);
                        this.$files.add((Pair<File, String>)new Pair((Object)it, (Object)string5));
                        this.$totalBytes.element += it.length();
                    }
                    return true;
                }
            }, arg_0), arg_0 -> CreateIncrementalCompilationBackup.zipProjectDir$lambda$1(zipProjectDir.2.INSTANCE, arg_0));
        }
        File backupFile = new File(projectDir, "make_backup_" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date()) + ".zip");
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(backupFile));
        long processedBytes = 0L;
        Closeable closeable = zos;
        Throwable throwable = null;
        try {
            ZipOutputStream it = (ZipOutputStream)closeable;
            boolean bl = false;
            for (Pair<File, String> pair : files2) {
                File file2 = (File)pair.component1();
                String relativePath = (String)pair.component2();
                Object[] objectArray2 = new Object[]{relativePath};
                indicator.setText(KotlinJvmBundle.message("adding.file.to.backup.0", objectArray2));
                indicator.setFraction(0.3 + (double)processedBytes / (double)totalBytes.element * 0.6499999999999999);
                ZipUtil.addFileToZip((ZipOutputStream)zos, (File)file2, (String)relativePath, null, null);
                processedBytes += file2.length();
            }
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        FileUtil.delete((File)backupDir);
        WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> CreateIncrementalCompilationBackup.zipProjectDir$lambda$3(backupFile, project2), null, (Project)project2);
    }

    private static final boolean zipProjectDir$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean zipProjectDir$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void zipProjectDir$lambda$3(File $backupFile, Project $project) {
        Intrinsics.checkNotNullParameter((Object)$backupFile, (String)"$backupFile");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        String string2 = KotlinJvmBundle.message("created.backup", new Object[0]);
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)$backupFile.getAbsolutePath(), (String)"backupFile.absolutePath");
        OkCancelDialogBuilder okCancelDialogBuilder = MessageDialogBuilder.Companion.okCancel(string2, KotlinJvmBundle.message("successfully.created.backup.0", objectArray));
        String string3 = RevealFileAction.getActionName(null);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getActionName(null)");
        OkCancelDialogBuilder okCancelDialogBuilder2 = (OkCancelDialogBuilder)okCancelDialogBuilder.yesText(string3);
        String string4 = IdeBundle.message((String)"action.close", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"action.close\")");
        boolean confirmed = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)okCancelDialogBuilder2.noText(string4)).icon(Messages.getInformationIcon())).ask($project);
        if (confirmed) {
            RevealFileAction.openFile((File)$backupFile);
        }
    }

    public static final /* synthetic */ void access$createPatches(CreateIncrementalCompilationBackup $this, File backupDir, Project project2, ProgressIndicator indicator) {
        $this.createPatches(backupDir, project2, indicator);
    }

    public static final /* synthetic */ void access$copyLogs(CreateIncrementalCompilationBackup $this, File backupDir, ProgressIndicator indicator) {
        $this.copyLogs(backupDir, indicator);
    }

    public static final /* synthetic */ void access$copyProjectSystemDir(CreateIncrementalCompilationBackup $this, File backupDir, Project project2, ProgressIndicator indicator) {
        $this.copyProjectSystemDir(backupDir, project2, indicator);
    }

    public static final /* synthetic */ void access$zipProjectDir(CreateIncrementalCompilationBackup $this, File backupDir, Project project2, File projectDir, ProgressIndicator indicator) {
        $this.zipProjectDir(backupDir, project2, projectDir, indicator);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/internal/makeBackup/CreateIncrementalCompilationBackup$Companion;", "", "()V", "BACKUP_DIR_NAME", "", "LOGS_FRACTION", "", "PATCHES_FRACTION", "PATCHES_TO_CREATE", "", "PROJECT_SYSTEM_FRACTION", "ZIP_FRACTION", "kotlin.jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

