/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions.MovePropertyToConstructorUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0002H\u0002J\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u0010*\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u0016*\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/MovePropertyToConstructorIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "applyTo", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "findConstructorParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getTextWithUseSite", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isValidInConstructor", "Lorg/jetbrains/kotlin/psi/KtExpression;", "render", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nMovePropertyToConstructorIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MovePropertyToConstructorIntention.kt\norg/jetbrains/kotlin/idea/intentions/MovePropertyToConstructorIntention\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,129:1\n142#2:130\n*S KotlinDebug\n*F\n+ 1 MovePropertyToConstructorIntention.kt\norg/jetbrains/kotlin/idea/intentions/MovePropertyToConstructorIntention\n*L\n112#1:130\n*E\n"})
public final class MovePropertyToConstructorIntention
extends SelfTargetingIntention<KtProperty>
implements LocalQuickFix {
    public MovePropertyToConstructorIntention() {
        super(KtProperty.class, KotlinBundle.lazyMessage("move.to.constructor", new Object[0]), null, 4, null);
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = descriptor2.getPsiElement();
        KtProperty ktProperty = psiElement2 instanceof KtProperty ? (KtProperty)psiElement2 : null;
        if (ktProperty == null) {
            return;
        }
        KtProperty property2 = ktProperty;
        this.applyTo(property2, (Editor)null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtProperty element3, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!MovePropertyToConstructorUtils.INSTANCE.isMovableToConstructorByPsi(element3)) return false;
        KtExpression ktExpression = element3.getInitializer();
        if (ktExpression == null) return true;
        boolean bl = this.isValidInConstructor(ktExpression);
        if (!bl) return false;
        return true;
    }

    @Override
    public void applyTo(@NotNull KtProperty element3, @Nullable Editor editor2) {
        String propertyAnnotationsText2;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element3), KtClass.class);
        if (ktClass2 == null) {
            return;
        }
        KtClass parentClass2 = ktClass2;
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
        KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
        KtPrimaryConstructor primaryConstructor = KtClassKt.createPrimaryConstructorIfAbsent((KtClass)parentClass2);
        KtParameter constructorParameter = this.findConstructorParameter(element3);
        CommentSaver commentSaver = new CommentSaver((PsiElement)element3, false, 2, null);
        BindingContext context2 = ResolutionUtils.analyze((KtElement)element3, BodyResolveMode.PARTIAL);
        Object object = element3.getModifierList();
        String string2 = object != null && (object = object.getAnnotationEntries()) != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)" ", null, null, (int)0, null, (Function1)((Function1)new Function1<KtAnnotationEntry, CharSequence>(this, context2){
            final /* synthetic */ MovePropertyToConstructorIntention this$0;
            final /* synthetic */ BindingContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(KtAnnotationEntry it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return MovePropertyToConstructorIntention.access$getTextWithUseSite(this.this$0, it, this.$context);
            }
        }), (int)30, null) : (propertyAnnotationsText2 = null);
        if (constructorParameter != null) {
            PsiElement psiElement2;
            String parameterText2 = MovePropertyToConstructorUtils.INSTANCE.buildReplacementConstructorParameterText(element3, constructorParameter, propertyAnnotationsText2);
            PsiElement $this$applyTo_u24lambda_u240 = psiElement2 = constructorParameter.replace((PsiElement)psiFactory.createParameter(parameterText2));
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$applyTo_u24lambda_u240, (String)"this");
            CommentSaver.restore$default(commentSaver, $this$applyTo_u24lambda_u240, false, 2, null);
        } else {
            VariableDescriptor variableDescriptor;
            Object object2 = element3.getTypeReference();
            if (object2 == null || (object2 = object2.getText()) == null) {
                variableDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(element3, null, 1, null);
                PropertyDescriptor propertyDescriptor = variableDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)variableDescriptor : null;
                if (propertyDescriptor != null && (propertyDescriptor = propertyDescriptor.getType()) != null) {
                    object2 = this.render((KotlinType)propertyDescriptor);
                } else {
                    return;
                }
            }
            Object typeText = object2;
            String parameterText3 = MovePropertyToConstructorUtils.INSTANCE.buildAdditionalConstructorParameterText(element3, (String)typeText, propertyAnnotationsText2);
            KtParameterList ktParameterList = primaryConstructor.getValueParameterList();
            if (ktParameterList != null && (ktParameterList = ktParameterList.addParameter(psiFactory.createParameter(parameterText3))) != null) {
                VariableDescriptor $this$applyTo_u24lambda_u241 = variableDescriptor = ktParameterList;
                boolean bl = false;
                ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)$this$applyTo_u24lambda_u241, null, 2, null);
                CommentSaver.restore$default(commentSaver, (PsiElement)$this$applyTo_u24lambda_u241, false, 2, null);
            }
        }
        element3.delete();
    }

    private final KtParameter findConstructorParameter(KtProperty $this$findConstructorParameter) {
        KtExpression ktExpression = $this$findConstructorParameter.getInitializer();
        KtReferenceExpression ktReferenceExpression = ktExpression instanceof KtReferenceExpression ? (KtReferenceExpression)ktExpression : null;
        if (ktReferenceExpression == null) {
            return null;
        }
        KtReferenceExpression reference2 = ktReferenceExpression;
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)reference2, null, 1, null);
        CallableDescriptor callableDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
        ParameterDescriptor parameterDescriptor = callableDescriptor instanceof ParameterDescriptor ? (ParameterDescriptor)callableDescriptor : null;
        if (parameterDescriptor == null) {
            return null;
        }
        ParameterDescriptor parameterDescriptor2 = parameterDescriptor;
        SourceElement sourceElement = parameterDescriptor2.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"parameterDescriptor.source");
        ktExpression = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
        return ktExpression instanceof KtParameter ? (KtParameter)ktExpression : null;
    }

    private final String getTextWithUseSite(KtAnnotationEntry $this$getTextWithUseSite, BindingContext context2) {
        String string2;
        if ($this$getTextWithUseSite.getUseSiteTarget() != null) {
            String string3 = $this$getTextWithUseSite.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"text");
            return string3;
        }
        KtTypeReference ktTypeReference = $this$getTextWithUseSite.getTypeReference();
        String string4 = ktTypeReference != null ? ktTypeReference.getText() : null;
        if (string4 == null) {
            String string5 = $this$getTextWithUseSite.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"text");
            return string5;
        }
        String typeReference2 = string4;
        KtValueArgumentList ktValueArgumentList = $this$getTextWithUseSite.getValueArgumentList();
        String string6 = ktValueArgumentList != null ? ktValueArgumentList.getText() : null;
        if (string6 == null) {
            string6 = "";
        }
        String valueArgumentList2 = string6;
        AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)$this$getTextWithUseSite);
        if (annotationDescriptor == null) {
            String string7 = $this$getTextWithUseSite.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"text");
            return string7;
        }
        AnnotationDescriptor descriptor2 = annotationDescriptor;
        Set applicableTargets = AnnotationChecker.Companion.applicableTargetSet(descriptor2);
        if (!applicableTargets.contains(KotlinTarget.VALUE_PARAMETER)) {
            String string8 = $this$getTextWithUseSite.getText();
            string2 = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"text");
        } else if (applicableTargets.contains(KotlinTarget.PROPERTY)) {
            string2 = MovePropertyToConstructorIntention.getTextWithUseSite$textWithMe(AnnotationUseSiteTarget.PROPERTY, typeReference2, valueArgumentList2);
        } else if (applicableTargets.contains(KotlinTarget.FIELD)) {
            string2 = MovePropertyToConstructorIntention.getTextWithUseSite$textWithMe(AnnotationUseSiteTarget.FIELD, typeReference2, valueArgumentList2);
        } else {
            String string9 = $this$getTextWithUseSite.getText();
            string2 = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"text");
        }
        return string2;
    }

    private final String render(KotlinType $this$render) {
        return IdeDescriptorRenderers.SOURCE_CODE.renderType($this$render);
    }

    private final boolean isValidInConstructor(KtExpression $this$isValidInConstructor) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$isValidInConstructor;
        boolean $i$f$getStrictParentOfType = false;
        KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClass.class, (boolean)true);
        if (ktClass2 == null) {
            return false;
        }
        KtClass containingClass = ktClass2;
        Ref.BooleanRef isValid = new Ref.BooleanRef();
        isValid.element = true;
        $this$isValidInConstructor.accept((PsiElementVisitor)new KtVisitorVoid(containingClass, isValid){
            final /* synthetic */ KtClass $containingClass;
            final /* synthetic */ Ref.BooleanRef $isValid;
            {
                this.$containingClass = $containingClass;
                this.$isValid = $isValid;
            }

            public void visitKtElement(@NotNull KtElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                element3.acceptChildren((PsiElementVisitor)this);
            }

            public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)expression2, null, 1, null);
                if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
                    return;
                }
                ResolvedCall declarationDescriptor = resolvedCall2;
                if (Intrinsics.areEqual((Object)declarationDescriptor.getContainingDeclaration(), (Object)SearchHelpersKt.getDescriptor((KtDeclaration)this.$containingClass))) {
                    this.$isValid.element = false;
                }
            }
        });
        return isValid.element;
    }

    private static final String getTextWithUseSite$textWithMe(AnnotationUseSiteTarget $this$getTextWithUseSite_u24textWithMe, String typeReference2, String valueArgumentList2) {
        return "@" + $this$getTextWithUseSite_u24textWithMe.getRenderName() + ":" + typeReference2 + valueArgumentList2;
    }

    public static final /* synthetic */ String access$getTextWithUseSite(MovePropertyToConstructorIntention $this, KtAnnotationEntry $receiver, BindingContext context2) {
        return $this.getTextWithUseSite($receiver, context2);
    }
}

