/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.codeinsight.utils.EditorUtilsKt;
import org.jetbrains.kotlin.idea.inspections.SuspiciousCollectionReassignmentInspectionKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.ChangeToMutableCollectionFix;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\t\n\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "ChangeTypeToMutableFix", "JoinWithInitializerFix", "ReplaceWithAssignmentFix", "ReplaceWithFilterFix", "kotlin.idea"})
public final class SuspiciousCollectionReassignmentInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.binaryExpressionVisitor((Function1)((Function1)new Function1<KtBinaryExpression, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
                super(1);
            }

            public final void invoke(@NotNull KtBinaryExpression binaryExpression) {
                String string2;
                List fixes2;
                block21: {
                    int n;
                    boolean bl;
                    ClassifierDescriptor leftDefaultType;
                    KotlinType leftType;
                    BindingContext context2;
                    KtProperty property2;
                    KtSingleValueToken operationToken;
                    block20: {
                        Intrinsics.checkNotNullParameter((Object)binaryExpression, (String)"binaryExpression");
                        if (binaryExpression.getRight() == null) {
                            return;
                        }
                        IElementType iElementType = binaryExpression.getOperationToken();
                        KtSingleValueToken ktSingleValueToken = iElementType instanceof KtSingleValueToken ? (KtSingleValueToken)iElementType : null;
                        if (ktSingleValueToken == null) {
                            return;
                        }
                        operationToken = ktSingleValueToken;
                        if (!SuspiciousCollectionReassignmentInspectionKt.access$getTargetOperations$p().contains(operationToken)) {
                            return;
                        }
                        KtExpression ktExpression = binaryExpression.getLeft();
                        if (ktExpression == null) {
                            return;
                        }
                        KtExpression left = ktExpression;
                        KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)left));
                        PsiElement psiElement2 = ktReference != null ? ktReference.resolve() : null;
                        KtProperty ktProperty = psiElement2 instanceof KtProperty ? (KtProperty)psiElement2 : null;
                        if (ktProperty == null) {
                            return;
                        }
                        property2 = ktProperty;
                        if (!property2.isVar()) {
                            return;
                        }
                        context2 = ResolutionUtils.analyze$default((KtElement)binaryExpression, null, 1, null);
                        KotlinType kotlinType = CallUtilKt.getType((KtExpression)left, (BindingContext)context2);
                        if (kotlinType == null) {
                            return;
                        }
                        leftType = kotlinType;
                        ClassifierDescriptor classifierDescriptor = leftType.getConstructor().getDeclarationDescriptor();
                        if (classifierDescriptor == null || (classifierDescriptor = classifierDescriptor.getDefaultType()) == null) {
                            return;
                        }
                        leftDefaultType = classifierDescriptor;
                        if (!SuspiciousCollectionReassignmentInspectionKt.isReadOnlyCollectionOrMap(leftType, PlatformKt.getBuiltIns((KtElement)binaryExpression))) {
                            return;
                        }
                        Iterable $this$any$iv = context2.getDiagnostics().forElement((PsiElement)binaryExpression);
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                Diagnostic it = (Diagnostic)element$iv;
                                n = 0;
                                if (!(it.getSeverity() == Severity.ERROR)) continue;
                                bl = true;
                                break block20;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return;
                    }
                    fixes2 = new ArrayList<E>();
                    if (ChangeTypeToMutableFix.Companion.isApplicable(property2)) {
                        fixes2.add(new ChangeTypeToMutableFix(leftType));
                    }
                    if (ReplaceWithFilterFix.Companion.isApplicable(binaryExpression, (SimpleType)leftDefaultType, context2)) {
                        fixes2.add(new ReplaceWithFilterFix());
                    }
                    if (ReplaceWithAssignmentFix.Companion.isApplicable(binaryExpression, property2, context2)) {
                        fixes2.add(new ReplaceWithAssignmentFix());
                    } else if (JoinWithInitializerFix.Companion.isApplicable(binaryExpression, property2)) {
                        fixes2.add(new JoinWithInitializerFix(operationToken));
                    }
                    if (fixes2.isEmpty()) {
                        return;
                    }
                    String $this$takeWhile$iv = leftDefaultType.toString();
                    boolean $i$f$takeWhile = false;
                    n = $this$takeWhile$iv.length();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        char it22 = $this$takeWhile$iv.charAt(index$iv);
                        boolean bl2 = false;
                        if (it22 != '<') continue;
                        String it22 = $this$takeWhile$iv;
                        int n2 = 0;
                        String string3 = it22.substring(n2, index$iv);
                        string2 = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        break block21;
                    }
                    string2 = $this$takeWhile$iv;
                }
                String string4 = string2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                String typeText = string4;
                KtOperationReferenceExpression ktOperationReferenceExpression = binaryExpression.getOperationReference();
                Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"binaryExpression.operationReference");
                KtOperationReferenceExpression operationReference = ktOperationReferenceExpression;
                PsiElement psiElement3 = (PsiElement)operationReference;
                Object[] objectArray = new Object[2];
                Intrinsics.checkNotNullExpressionValue((Object)operationReference.getText(), (String)"operationReference.text");
                objectArray[1] = typeText;
                String string5 = KotlinBundle.message("0.on.a.readonly.1.creates.a.new.1.under.the.hood", objectArray);
                Collection $this$toTypedArray$iv = fixes2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                objectArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                this.$holder.registerProblem(psiElement3, string5, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
            }
        }));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$ChangeTypeToMutableFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/types/KotlinType;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "Companion", "kotlin.idea"})
    private static final class ChangeTypeToMutableFix
    implements LocalQuickFix {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final KotlinType type;

        public ChangeTypeToMutableFix(@NotNull KotlinType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            this.type = type2;
        }

        @NotNull
        public String getName() {
            return KotlinBundle.message("change.type.to.mutable.fix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            block4: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                PsiElement psiElement2 = descriptor2.getPsiElement();
                KtOperationReferenceExpression ktOperationReferenceExpression = psiElement2 instanceof KtOperationReferenceExpression ? (KtOperationReferenceExpression)psiElement2 : null;
                if (ktOperationReferenceExpression == null) {
                    return;
                }
                KtOperationReferenceExpression operationReference = ktOperationReferenceExpression;
                PsiElement psiElement3 = operationReference.getParent();
                KtBinaryExpression ktBinaryExpression = psiElement3 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement3 : null;
                if (ktBinaryExpression == null) {
                    return;
                }
                KtBinaryExpression binaryExpression = ktBinaryExpression;
                KtExpression ktExpression = binaryExpression.getLeft();
                if (ktExpression == null) {
                    return;
                }
                KtExpression left = ktExpression;
                KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)left));
                PsiElement psiElement4 = ktReference != null ? ktReference.resolve() : null;
                KtProperty ktProperty = psiElement4 instanceof KtProperty ? (KtProperty)psiElement4 : null;
                if (ktProperty == null) {
                    return;
                }
                KtProperty property2 = ktProperty;
                ChangeToMutableCollectionFix.Companion.applyFix(property2, this.type);
                property2.getValOrVarKeyword().replace(new KtPsiFactory(project2, false, 2, null).createValKeyword());
                Editor editor2 = EditorUtilsKt.findExistingEditor((PsiElement)binaryExpression);
                if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) break block4;
                editor2.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)property2)));
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$ChangeTypeToMutableFix$Companion;", "", "()V", "isApplicable", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "kotlin.idea"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean isApplicable(@NotNull KtProperty property2) {
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                return ChangeToMutableCollectionFix.Companion.isApplicable(property2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$JoinWithInitializerFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "op", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "(Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "Companion", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nSuspiciousCollectionReassignmentInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuspiciousCollectionReassignmentInspection.kt\norg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$JoinWithInitializerFix\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,200:1\n21#2,7:201\n*S KotlinDebug\n*F\n+ 1 SuspiciousCollectionReassignmentInspection.kt\norg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$JoinWithInitializerFix\n*L\n179#1:201,7\n*E\n"})
    private static final class JoinWithInitializerFix
    implements LocalQuickFix {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final KtSingleValueToken op;

        public JoinWithInitializerFix(@NotNull KtSingleValueToken op) {
            Intrinsics.checkNotNullParameter((Object)op, (String)"op");
            this.op = op;
        }

        @NotNull
        public String getName() {
            return KotlinBundle.message("join.with.initializer.fix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            block11: {
                PsiElement psiElement2;
                void $this$replaced$iv;
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                PsiElement psiElement3 = descriptor2.getPsiElement();
                KtOperationReferenceExpression ktOperationReferenceExpression = psiElement3 instanceof KtOperationReferenceExpression ? (KtOperationReferenceExpression)psiElement3 : null;
                if (ktOperationReferenceExpression == null) {
                    return;
                }
                KtOperationReferenceExpression operationReference = ktOperationReferenceExpression;
                PsiElement psiElement4 = operationReference.getParent();
                KtBinaryExpression ktBinaryExpression = psiElement4 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement4 : null;
                if (ktBinaryExpression == null) {
                    return;
                }
                KtBinaryExpression binaryExpression = ktBinaryExpression;
                KtExpression ktExpression = binaryExpression.getLeft();
                if (ktExpression == null) {
                    return;
                }
                KtExpression left = ktExpression;
                KtExpression ktExpression2 = binaryExpression.getRight();
                if (ktExpression2 == null) {
                    return;
                }
                KtExpression right2 = ktExpression2;
                KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)left));
                PsiElement psiElement5 = ktReference != null ? ktReference.resolve() : null;
                KtProperty ktProperty = psiElement5 instanceof KtProperty ? (KtProperty)psiElement5 : null;
                if (ktProperty == null) {
                    return;
                }
                KtProperty property2 = ktProperty;
                KtExpression ktExpression3 = property2.getInitializer();
                if (ktExpression3 == null) {
                    return;
                }
                KtExpression initializer2 = ktExpression3;
                KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
                KtSingleValueToken newOp = Intrinsics.areEqual((Object)this.op, (Object)KtTokens.PLUSEQ) ? KtTokens.PLUS : KtTokens.MINUS;
                PsiElement psiElement6 = (PsiElement)initializer2;
                Object[] objectArray = new Object[3];
                objectArray[0] = initializer2;
                Intrinsics.checkNotNullExpressionValue((Object)newOp.getValue(), (String)"newOp.value");
                objectArray[2] = right2;
                PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0 $1 $2", (Object[])objectArray, (boolean)false, (int)4, null);
                boolean $i$f$replaced = false;
                if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                    psiElement2 = newElement$iv;
                } else {
                    PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                    if (result$iv instanceof KtExpression) {
                        psiElement2 = result$iv;
                    } else {
                        Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                        KtExpression ktExpression4 = ((KtParenthesizedExpression)result$iv).getExpression();
                        if (ktExpression4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                        }
                        psiElement2 = (PsiElement)ktExpression4;
                    }
                }
                KtExpression replaced2 = (KtExpression)psiElement2;
                binaryExpression.delete();
                Editor editor2 = EditorUtilsKt.findExistingEditor((PsiElement)property2);
                if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) break block11;
                editor2.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)replaced2)));
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$JoinWithInitializerFix$Companion;", "", "()V", "isApplicable", "", "binaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "kotlin.idea"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean isApplicable(@NotNull KtBinaryExpression binaryExpression, @NotNull KtProperty property2) {
                Intrinsics.checkNotNullParameter((Object)binaryExpression, (String)"binaryExpression");
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                if (!property2.isLocal() || property2.getInitializer() == null) {
                    return false;
                }
                return Intrinsics.areEqual((Object)PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)((PsiElement)binaryExpression), (boolean)false, (int)1, null), (Object)property2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$ReplaceWithAssignmentFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "Companion", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nSuspiciousCollectionReassignmentInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuspiciousCollectionReassignmentInspection.kt\norg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$ReplaceWithAssignmentFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1549#2:201\n1620#2,3:202\n*S KotlinDebug\n*F\n+ 1 SuspiciousCollectionReassignmentInspection.kt\norg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$ReplaceWithAssignmentFix\n*L\n137#1:201\n137#1:202,3\n*E\n"})
    private static final class ReplaceWithAssignmentFix
    implements LocalQuickFix {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final List<String> emptyCollectionFactoryMethods;

        @NotNull
        public String getName() {
            return KotlinBundle.message("replace.with.assignment.fix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtOperationReferenceExpression ktOperationReferenceExpression = psiElement2 instanceof KtOperationReferenceExpression ? (KtOperationReferenceExpression)psiElement2 : null;
            if (ktOperationReferenceExpression == null) {
                return;
            }
            KtOperationReferenceExpression operationReference = ktOperationReferenceExpression;
            KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
            String string2 = KtTokens.EQ.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"EQ.value");
            operationReference.replace((PsiElement)psiFactory.createOperationName(string2));
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var3_3;
            void $this$mapTo$iv$iv;
            Companion = new Companion(null);
            Object[] objectArray = new String[]{"emptyList", "emptySet", "emptyMap", "listOf", "setOf", "mapOf"};
            Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add("kotlin.collections." + (String)it);
            }
            emptyCollectionFactoryMethods = (List)var3_3;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$ReplaceWithAssignmentFix$Companion;", "", "()V", "emptyCollectionFactoryMethods", "", "", "getEmptyCollectionFactoryMethods", "()Ljava/util/List;", "isApplicable", "", "binaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlin.idea"})
        @SourceDebugExtension(value={"SMAP\nSuspiciousCollectionReassignmentInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuspiciousCollectionReassignmentInspection.kt\norg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$ReplaceWithAssignmentFix$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,200:1\n1247#2:201\n1248#2:214\n243#3:202\n254#3,10:203\n276#3:213\n*S KotlinDebug\n*F\n+ 1 SuspiciousCollectionReassignmentInspection.kt\norg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$ReplaceWithAssignmentFix$Companion\n*L\n156#1:201\n156#1:214\n156#1:202\n156#1:203,10\n156#1:213\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<String> getEmptyCollectionFactoryMethods() {
                return emptyCollectionFactoryMethods;
            }

            /*
             * WARNING - void declaration
             */
            public final boolean isApplicable(@NotNull KtBinaryExpression binaryExpression, @NotNull KtProperty property2, @NotNull BindingContext context2) {
                boolean bl;
                block9: {
                    void $this$any$iv;
                    String fqName2;
                    Intrinsics.checkNotNullParameter((Object)binaryExpression, (String)"binaryExpression");
                    Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    if (!Intrinsics.areEqual((Object)binaryExpression.getOperationToken(), (Object)KtTokens.PLUSEQ)) {
                        return false;
                    }
                    if (!property2.isLocal()) {
                        return false;
                    }
                    KtExpression ktExpression = property2.getInitializer();
                    KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
                    if (ktCallExpression == null) {
                        return false;
                    }
                    KtCallExpression initializer2 = ktCallExpression;
                    List list2 = initializer2.getValueArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"initializer.valueArguments");
                    if (!((Collection)list2).isEmpty()) {
                        return false;
                    }
                    ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)initializer2), (BindingContext)context2);
                    Object initializerResultingDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
                    CallableDescriptor callableDescriptor = initializerResultingDescriptor;
                    String string2 = callableDescriptor != null && (callableDescriptor = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor))) != null ? callableDescriptor.asString() : (fqName2 = null);
                    if (!CollectionsKt.contains((Iterable)this.getEmptyCollectionFactoryMethods(), (Object)fqName2)) {
                        return false;
                    }
                    KtExpression ktExpression2 = binaryExpression.getRight();
                    if (ktExpression2 == null || (ktExpression2 = CallUtilKt.getType((KtExpression)ktExpression2, (BindingContext)context2)) == null || (ktExpression2 = SuspiciousCollectionReassignmentInspectionKt.access$classDescriptor((KotlinType)ktExpression2)) == null) {
                        return false;
                    }
                    KtExpression rightClassDescriptor = ktExpression2;
                    CallableDescriptor callableDescriptor2 = initializerResultingDescriptor;
                    if (callableDescriptor2 == null || (callableDescriptor2 = callableDescriptor2.getReturnType()) == null || (callableDescriptor2 = SuspiciousCollectionReassignmentInspectionKt.access$classDescriptor((KotlinType)callableDescriptor2)) == null) {
                        return false;
                    }
                    CallableDescriptor initializerClassDescriptor = callableDescriptor2;
                    if (!DescriptorUtilsKt.isSubclassOf((ClassDescriptor)rightClassDescriptor, (ClassDescriptor)initializerClassDescriptor)) {
                        return false;
                    }
                    Sequence sequence2 = SequencesKt.filter((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)binaryExpression), (boolean)false, (boolean)false), (Function1)((Function1)new Function1<PsiElement, Boolean>(property2){
                        final /* synthetic */ KtProperty $property;
                        {
                            this.$property = $property;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull PsiElement it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return !Intrinsics.areEqual((Object)it, (Object)this.$property);
                        }
                    }));
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        void $this$anyDescendantOfType$iv;
                        PsiElement sibling = (PsiElement)element$iv;
                        boolean bl2 = false;
                        PsiElement psiElement2 = sibling;
                        Function1 predicate$iv = (Function1)new Function1<KtSimpleNameExpression, Boolean>(property2){
                            final /* synthetic */ KtProperty $property;
                            {
                                this.$property = $property;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull KtSimpleNameExpression it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return Intrinsics.areEqual((Object)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)it).resolve(), (Object)this.$property);
                            }
                        };
                        boolean $i$f$anyDescendantOfType = false;
                        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
                        boolean $i$f$findDescendantOfType = false;
                        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
                        boolean $i$f$findDescendantOfType2 = false;
                        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
                        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
                        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
                            final /* synthetic */ Function1 $predicate;
                            final /* synthetic */ Ref.ObjectRef $result;
                            {
                                this.$predicate = $predicate;
                                this.$result = $result;
                            }

                            public void visitElement(@NotNull PsiElement element3) {
                                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                                if (element3 instanceof KtSimpleNameExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                                    this.$result.element = element3;
                                    this.stopWalking();
                                    return;
                                }
                                PsiElement it = element3;
                                boolean bl = false;
                                super.visitElement(element3);
                            }
                        });
                        boolean bl3 = (PsiElement)result$iv$iv$iv.element != null;
                        if (!bl3) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
                return !bl;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$ReplaceWithFilterFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "Companion", "kotlin.idea"})
    private static final class ReplaceWithFilterFix
    implements LocalQuickFix {
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public String getName() {
            return KotlinBundle.message("replace.with.filter.fix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtOperationReferenceExpression ktOperationReferenceExpression = psiElement2 instanceof KtOperationReferenceExpression ? (KtOperationReferenceExpression)psiElement2 : null;
            if (ktOperationReferenceExpression == null) {
                return;
            }
            KtOperationReferenceExpression operationReference = ktOperationReferenceExpression;
            PsiElement psiElement3 = operationReference.getParent();
            KtBinaryExpression ktBinaryExpression = psiElement3 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement3 : null;
            if (ktBinaryExpression == null) {
                return;
            }
            KtBinaryExpression binaryExpression = ktBinaryExpression;
            KtExpression ktExpression = binaryExpression.getLeft();
            if (ktExpression == null) {
                return;
            }
            KtExpression left = ktExpression;
            KtExpression ktExpression2 = binaryExpression.getRight();
            if (ktExpression2 == null) {
                return;
            }
            KtExpression right2 = ktExpression2;
            KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
            String string2 = KtTokens.EQ.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"EQ.value");
            operationReference.replace((PsiElement)psiFactory.createOperationName(string2));
            Object[] objectArray = new Object[]{left, right2};
            right2.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0.filter { it !in $1 }", (Object[])objectArray, (boolean)false, (int)4, null));
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SuspiciousCollectionReassignmentInspection$ReplaceWithFilterFix$Companion;", "", "()V", "isApplicable", "", "binaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "leftType", "Lorg/jetbrains/kotlin/types/SimpleType;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlin.idea"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean isApplicable(@NotNull KtBinaryExpression binaryExpression, @NotNull SimpleType leftType, @NotNull BindingContext context2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)binaryExpression, (String)"binaryExpression");
                Intrinsics.checkNotNullParameter((Object)leftType, (String)"leftType");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                if (!Intrinsics.areEqual((Object)binaryExpression.getOperationToken(), (Object)KtTokens.MINUSEQ)) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)leftType, (Object)PlatformKt.getBuiltIns((KtElement)binaryExpression).getMap().getDefaultType())) {
                    return false;
                }
                KtExpression ktExpression = binaryExpression.getRight();
                if (ktExpression != null && (ktExpression = CallUtilKt.getType((KtExpression)ktExpression, (BindingContext)context2)) != null && (ktExpression = SuspiciousCollectionReassignmentInspectionKt.access$classDescriptor((KotlinType)ktExpression)) != null) {
                    ClassDescriptor classDescriptor = PlatformKt.getBuiltIns((KtElement)binaryExpression).getIterable();
                    Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"binaryExpression.builtIns.iterable");
                    bl = DescriptorUtilsKt.isSubclassOf((ClassDescriptor)ktExpression, (ClassDescriptor)classDescriptor);
                } else {
                    bl = false;
                }
                return bl;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

