/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.ConvertScopeFunctionFix;
import org.jetbrains.kotlin.idea.inspections.ConvertScopeFunctionToReceiver;
import org.jetbrains.kotlin.idea.inspections.ReplacementCollection;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConvertScopeFunctionToReceiver;", "Lorg/jetbrains/kotlin/idea/inspections/ConvertScopeFunctionFix;", "counterpartName", "", "(Ljava/lang/String;)V", "analyzeLambda", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaArgument;", "lambdaDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "replacements", "Lorg/jetbrains/kotlin/idea/inspections/ReplacementCollection;", "postprocessLambda", "kotlin.idea"})
public final class ConvertScopeFunctionToReceiver
extends ConvertScopeFunctionFix {
    public ConvertScopeFunctionToReceiver(@NotNull String counterpartName) {
        Intrinsics.checkNotNullParameter((Object)counterpartName, (String)"counterpartName");
        super(counterpartName);
    }

    @Override
    protected void analyzeLambda(@NotNull BindingContext bindingContext2, @NotNull KtLambdaArgument lambda2, @NotNull SimpleFunctionDescriptor lambdaDescriptor, @NotNull ReplacementCollection replacements) {
        Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        Intrinsics.checkNotNullParameter((Object)lambdaDescriptor, (String)"lambdaDescriptor");
        Intrinsics.checkNotNullParameter((Object)replacements, (String)"replacements");
        lambda2.accept((PsiElementVisitor)new KtTreeVisitorVoid(lambdaDescriptor, replacements, bindingContext2){
            final /* synthetic */ SimpleFunctionDescriptor $lambdaDescriptor;
            final /* synthetic */ ReplacementCollection $replacements;
            final /* synthetic */ BindingContext $bindingContext;
            {
                this.$lambdaDescriptor = $lambdaDescriptor;
                this.$replacements = $replacements;
                this.$bindingContext = $bindingContext;
            }

            public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitSimpleNameExpression(expression2);
                if (Intrinsics.areEqual((Object)expression2.getReferencedName(), (Object)"it")) {
                    DeclarationDescriptor result2 = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors((KtElement)expression2));
                    if (result2 instanceof ValueParameterDescriptor && Intrinsics.areEqual((Object)((ValueParameterDescriptor)result2).getContainingDeclaration(), (Object)this.$lambdaDescriptor)) {
                        this.$replacements.add((PsiElement)expression2, analyzeLambda.visitSimpleNameExpression.1.INSTANCE);
                    }
                } else {
                    ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression2), (BindingContext)this.$bindingContext);
                    if (resolvedCall2 == null) {
                        return;
                    }
                    ResolvedCall resolvedCall3 = resolvedCall2;
                    ReceiverValue dispatchReceiver = resolvedCall3.getDispatchReceiver();
                    if (dispatchReceiver instanceof ImplicitReceiver) {
                        PsiElement parent2 = expression2.getParent();
                        String thisLabelName = KotlinRefactoringUtilKt.getThisLabelName(((ImplicitReceiver)dispatchReceiver).getDeclarationDescriptor());
                        if (parent2 instanceof KtCallExpression && Intrinsics.areEqual((Object)expression2, (Object)((KtCallExpression)parent2).getCalleeExpression())) {
                            this.$replacements.add(parent2, (Function2)new Function2<KtPsiFactory, KtCallExpression, PsiElement>(thisLabelName){
                                final /* synthetic */ String $thisLabelName;
                                {
                                    this.$thisLabelName = $thisLabelName;
                                    super(2);
                                }

                                @NotNull
                                public final PsiElement invoke(@NotNull KtPsiFactory $this$add, @NotNull KtCallExpression element3) {
                                    Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                                    Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                                    Object[] objectArray = new Object[]{this.$thisLabelName, element3};
                                    return (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)$this$add, (String)"this@$0.$1", (Object[])objectArray, (boolean)false, (int)4, null);
                                }
                            });
                        } else {
                            String referencedName = expression2.getReferencedName();
                            this.$replacements.add((PsiElement)expression2, (Function2)new Function2<KtPsiFactory, KtSimpleNameExpression, PsiElement>(thisLabelName, referencedName){
                                final /* synthetic */ String $thisLabelName;
                                final /* synthetic */ String $referencedName;
                                {
                                    this.$thisLabelName = $thisLabelName;
                                    this.$referencedName = $referencedName;
                                    super(2);
                                }

                                @NotNull
                                public final PsiElement invoke(@NotNull KtPsiFactory $this$add, @NotNull KtSimpleNameExpression it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    return (PsiElement)$this$add.createExpression("this@" + this.$thisLabelName + "." + this.$referencedName);
                                }
                            });
                        }
                    }
                }
            }

            public void visitThisExpression(@NotNull KtThisExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression2), (BindingContext)this.$bindingContext);
                if (resolvedCall2 == null) {
                    return;
                }
                ResolvedCall resolvedCall3 = resolvedCall2;
                Name name2 = resolvedCall3.getResultingDescriptor().getContainingDeclaration().getName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"resolvedCall.resultingDe\u2026ontainingDeclaration.name");
                Name qualifierName2 = name2;
                this.$replacements.add((PsiElement)expression2, (Function2)new Function2<KtPsiFactory, KtThisExpression, PsiElement>(qualifierName2){
                    final /* synthetic */ Name $qualifierName;
                    {
                        this.$qualifierName = $qualifierName;
                        super(2);
                    }

                    @NotNull
                    public final PsiElement invoke(@NotNull KtPsiFactory $this$add, @NotNull KtThisExpression it) {
                        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        String string2 = this.$qualifierName.asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"qualifierName.asString()");
                        return (PsiElement)$this$add.createThisExpression(string2);
                    }
                });
            }
        });
    }

    @Override
    protected void postprocessLambda(@NotNull KtLambdaArgument lambda2) {
        Intrinsics.checkNotNullParameter((Object)lambda2, (String)"lambda");
        Function1 filter2 = postprocessLambda.filter.1.INSTANCE;
        new ShortenReferences((Function1<? super KtElement, ShortenReferences.Options>)((Function1)postprocessLambda.1.INSTANCE)).process((KtElement)lambda2, (Function1<? super PsiElement, ? extends ShortenReferences.FilterResult>)filter2);
    }
}

