/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.highlighting.visitor.AbstractHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightInfoTypeSemanticNames;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.CollectionUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/BeforeResolveHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/base/highlighting/visitor/AbstractHighlightingVisitor;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "(Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;)V", "visitArgument", "", "argument", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "visitElement", "element", "Lcom/intellij/psi/PsiElement;", "visitExpressionWithLabel", "expression", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitSuperTypeCallEntry", "call", "Lorg/jetbrains/kotlin/psi/KtSuperTypeCallEntry;", "visitTypeParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "willApplyRainbowHighlight", "", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocLink;", "kotlin.base.highlighting"})
@SourceDebugExtension(value={"SMAP\nBeforeResolveHighlightingVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BeforeResolveHighlightingVisitor.kt\norg/jetbrains/kotlin/idea/highlighter/BeforeResolveHighlightingVisitor\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n76#2:108\n1#3:109\n*S KotlinDebug\n*F\n+ 1 BeforeResolveHighlightingVisitor.kt\norg/jetbrains/kotlin/idea/highlighter/BeforeResolveHighlightingVisitor\n*L\n52#1:108\n*E\n"})
public final class BeforeResolveHighlightingVisitor
extends AbstractHighlightingVisitor {
    public BeforeResolveHighlightingVisitor(@NotNull HighlightInfoHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(holder);
    }

    public void visitElement(@NotNull PsiElement element3) {
        HighlightInfoType highlightInfoType;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        IElementType iElementType = element3.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"element.node.elementType");
        IElementType elementType = iElementType;
        if (element3 instanceof KDocLink && !this.willApplyRainbowHighlight((KDocLink)element3)) {
            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getKDOC_LINK();
        } else if (KtTokens.SOFT_KEYWORDS.contains(elementType)) {
            IElementType iElementType2 = elementType;
            highlightInfoType = KtTokens.MODIFIER_KEYWORDS.contains(iElementType2) ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getBUILTIN_ANNOTATION() : KotlinHighlightInfoTypeSemanticNames.INSTANCE.getKEYWORD();
        } else if (Intrinsics.areEqual((Object)elementType, (Object)KtTokens.SAFE_ACCESS)) {
            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getSAFE_ACCESS();
        } else if (Intrinsics.areEqual((Object)elementType, (Object)KtTokens.EXCLEXCL)) {
            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getEXCLEXCL();
        } else {
            return;
        }
        HighlightInfoType attributes2 = highlightInfoType;
        AbstractHighlightingVisitor.highlightName$default(this, element3, attributes2, null, 4, null);
    }

    private final boolean willApplyRainbowHighlight(KDocLink element3) {
        if (!RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)((TextAttributesScheme)EditorColorsManager.getInstance().getGlobalScheme()), (Language)((Language)KotlinLanguage.INSTANCE))) {
            return false;
        }
        PsiElement psiElement2 = element3.getParent();
        KDocTag kDocTag = psiElement2 instanceof KDocTag ? (KDocTag)psiElement2 : null;
        return (kDocTag != null ? kDocTag.getKnownTag() : null) == KDocKnownTag.PARAM;
    }

    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression2) {
        PsiElement arrow2;
        Intrinsics.checkNotNullParameter((Object)lambdaExpression2, (String)"lambdaExpression");
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        KtFunctionLiteral ktFunctionLiteral = lambdaExpression2.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"lambdaExpression.functionLiteral");
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        AbstractHighlightingVisitor abstractHighlightingVisitor = this;
        PsiElement psiElement2 = functionLiteral.getLBrace();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"functionLiteral.lBrace");
        AbstractHighlightingVisitor.highlightName$default(abstractHighlightingVisitor, psiElement2, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getFUNCTION_LITERAL_BRACES_AND_ARROW(), null, 4, null);
        PsiElement closingBrace = functionLiteral.getRBrace();
        if (closingBrace != null) {
            AbstractHighlightingVisitor.highlightName$default(this, closingBrace, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getFUNCTION_LITERAL_BRACES_AND_ARROW(), null, 4, null);
        }
        if ((arrow2 = functionLiteral.getArrow()) != null) {
            AbstractHighlightingVisitor.highlightName$default(this, arrow2, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getFUNCTION_LITERAL_BRACES_AND_ARROW(), null, 4, null);
        }
    }

    public void visitArgument(@NotNull KtValueArgument argument2) {
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        KtValueArgumentName ktValueArgumentName = argument2.getArgumentName();
        if (ktValueArgumentName == null) {
            return;
        }
        KtValueArgumentName argumentName2 = ktValueArgumentName;
        PsiElement psiElement2 = argument2.getEqualsToken();
        if (psiElement2 == null) {
            return;
        }
        PsiElement eq = psiElement2;
        AbstractHighlightingVisitor abstractHighlightingVisitor = this;
        Project project2 = argument2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"argument.project");
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(KtValueArgumentList.class)};
        AbstractHighlightingVisitor.highlightName$default(abstractHighlightingVisitor, project2, new TextRange(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)argumentName2)), PsiUtilsKt.getEndOffset((PsiElement)eq)), CollectionUtilsKt.match((Sequence<? extends Object>)PsiUtilsKt.getParents((PsiElement)((PsiElement)argument2)), kClassArray, Reflection.getOrCreateKotlinClass(KtAnnotationEntry.class)) != null ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getANNOTATION_ATTRIBUTE_NAME_ATTRIBUTES() : KotlinHighlightInfoTypeSemanticNames.INSTANCE.getNAMED_ARGUMENT(), null, 8, null);
    }

    public void visitExpressionWithLabel(@NotNull KtExpressionWithLabel expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtSimpleNameExpression targetLabel = expression2.getTargetLabel();
        if (targetLabel != null) {
            AbstractHighlightingVisitor.highlightName$default(this, (PsiElement)targetLabel, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getLABEL(), null, 4, null);
        }
    }

    public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call) {
        KtTypeElement typeElement2;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        KtConstructorCalleeExpression ktConstructorCalleeExpression = call.getCalleeExpression();
        Intrinsics.checkNotNullExpressionValue((Object)ktConstructorCalleeExpression, (String)"call.calleeExpression");
        KtConstructorCalleeExpression calleeExpression2 = ktConstructorCalleeExpression;
        KtTypeReference ktTypeReference = calleeExpression2.getTypeReference();
        Object object = typeElement2 = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
        if (typeElement2 instanceof KtUserType) {
            KtSimpleNameExpression ktSimpleNameExpression = ((KtUserType)typeElement2).getReferenceExpression();
            if (ktSimpleNameExpression != null) {
                KtSimpleNameExpression it = ktSimpleNameExpression;
                boolean bl = false;
                AbstractHighlightingVisitor.highlightName$default(this, (PsiElement)it, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getCONSTRUCTOR_CALL(), null, 4, null);
            }
        }
        super.visitSuperTypeCallEntry(call);
    }

    public void visitTypeParameter(@NotNull KtTypeParameter parameter2) {
        Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
        PsiElement psiElement2 = parameter2.getNameIdentifier();
        if (psiElement2 != null) {
            PsiElement it = psiElement2;
            boolean bl = false;
            AbstractHighlightingVisitor.highlightName$default(this, it, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getTYPE_PARAMETER(), null, 4, null);
        }
        super.visitTypeParameter(parameter2);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        this.highlightNamedDeclaration((KtNamedDeclaration)function2, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getFUNCTION_DECLARATION());
        super.visitNamedFunction(function2);
    }
}

