/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.groovy.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroupUtils;
import org.jetbrains.kotlin.idea.base.util.StringUtils;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.GradleBuildScriptManipulatorUtils;
import org.jetbrains.kotlin.idea.groovy.inspections.DeprecatedGradleDependencyInspectionKt;
import org.jetbrains.kotlin.idea.groovy.inspections.DifferentStdlibGradleVersionInspection;
import org.jetbrains.kotlin.idea.groovy.inspections.GradleHeuristicHelper;
import org.jetbrains.kotlin.idea.groovy.inspections.KotlinGradleInspectionVisitor;
import org.jetbrains.kotlin.idea.inspections.ReplaceStringInDocumentFix;
import org.jetbrains.kotlin.idea.versions.DeprecatedLibInfo;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00062\u00020\u00012\u00020\u0002:\u0003\u0006\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/groovy/inspections/DeprecatedGradleDependencyInspection;", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "Companion", "DependencyFinder", "ExternalLibraryInfo", "kotlin.gradle.code-insight-groovy"})
public final class DeprecatedGradleDependencyInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new DependencyFinder();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/groovy/inspections/DeprecatedGradleDependencyInspection$Companion;", "", "()V", "libraryVersionFromOrderEntry", "", "file", "Lcom/intellij/psi/PsiFile;", "libraryId", "parseExternalLibraryName", "Lorg/jetbrains/kotlin/idea/groovy/inspections/DeprecatedGradleDependencyInspection$ExternalLibraryInfo;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "kotlin.gradle.code-insight-groovy"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String libraryVersionFromOrderEntry(@NotNull PsiFile file2, @NotNull String libraryId) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
            Module module2 = ProjectRootManager.getInstance((Project)file2.getProject()).getFileIndex().getModuleForFile(file2.getVirtualFile());
            if (module2 == null) {
                return null;
            }
            Module module3 = module2;
            String libMarker = ":" + libraryId + ":";
            for (Module moduleInGroup : ModuleSourceRootGroupUtils.allModules(ModuleSourceRootGroupUtils.getWholeModuleGroup(module3))) {
                Ref.ObjectRef libVersion = new Ref.ObjectRef();
                ModuleRootManager.getInstance((Module)moduleInGroup).orderEntries().forEachLibrary(arg_0 -> Companion.libraryVersionFromOrderEntry$lambda$0((Function1)new Function1<Library, Boolean>(libMarker, (Ref.ObjectRef<String>)libVersion){
                    final /* synthetic */ String $libMarker;
                    final /* synthetic */ Ref.ObjectRef<String> $libVersion;
                    {
                        this.$libMarker = $libMarker;
                        this.$libVersion = $libVersion;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(Library library2) {
                        String string2 = library2.getName();
                        boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)this.$libMarker, (boolean)false, (int)2, null) : false;
                        if (bl) {
                            Intrinsics.checkNotNullExpressionValue((Object)library2, (String)"library");
                            ExternalLibraryInfo externalLibraryInfo = org.jetbrains.kotlin.idea.groovy.inspections.DeprecatedGradleDependencyInspection$Companion.access$parseExternalLibraryName(DeprecatedGradleDependencyInspection.Companion, library2);
                            this.$libVersion.element = externalLibraryInfo != null ? externalLibraryInfo.getVersion() : null;
                        }
                        return this.$libVersion.element == null;
                    }
                }, arg_0));
                if (libVersion.element == null) continue;
                return (String)libVersion.element;
            }
            return null;
        }

        private final ExternalLibraryInfo parseExternalLibraryName(Library library2) {
            String string2 = library2.getName();
            if (string2 == null) {
                return null;
            }
            String libName = string2;
            String string3 = StringUtils.substringAfterLastOrNull(libName, ":");
            if (string3 == null) {
                return null;
            }
            String versionWithKind = string3;
            String version2 = StringsKt.substringBefore$default((String)versionWithKind, (String)"@", null, (int)2, null);
            String string4 = StringUtils.substringBeforeLastOrNull(libName, ":");
            if (string4 == null || (string4 = StringUtils.substringAfterLastOrNull(string4, ":")) == null) {
                return null;
            }
            String artifactId2 = string4;
            if (StringsKt.isBlank((CharSequence)version2) || StringsKt.isBlank((CharSequence)artifactId2)) {
                return null;
            }
            return new ExternalLibraryInfo(artifactId2, version2);
        }

        private static final boolean libraryVersionFromOrderEntry$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ ExternalLibraryInfo access$parseExternalLibraryName(Companion $this, Library library2) {
            return $this.parseExternalLibraryName(library2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0012\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/groovy/inspections/DeprecatedGradleDependencyInspection$DependencyFinder;", "Lorg/jetbrains/kotlin/idea/groovy/inspections/KotlinGradleInspectionVisitor;", "()V", "reportOnElement", "Lcom/intellij/psi/PsiElement;", "classpathEntry", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "deprecatedInfo", "Lorg/jetbrains/kotlin/idea/versions/DeprecatedLibInfo;", "visitClosure", "", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "visitDependencyEntry", "dependencyStatement", "kotlin.gradle.code-insight-groovy"})
    @SourceDebugExtension(value={"SMAP\nDeprecatedGradleDependencyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeprecatedGradleDependencyInspection.kt\norg/jetbrains/kotlin/idea/groovy/inspections/DeprecatedGradleDependencyInspection$DependencyFinder\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,133:1\n142#2:134\n*S KotlinDebug\n*F\n+ 1 DeprecatedGradleDependencyInspection.kt\norg/jetbrains/kotlin/idea/groovy/inspections/DeprecatedGradleDependencyInspection$DependencyFinder\n*L\n38#1:134\n*E\n"})
    private static class DependencyFinder
    extends KotlinGradleInspectionVisitor {
        public void visitClosure(@NotNull GrClosableBlock closure) {
            Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
            super.visitClosure(closure);
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)closure;
            boolean $i$f$getStrictParentOfType = false;
            GrMethodCall grMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, GrMethodCall.class, (boolean)true);
            if (grMethodCall == null) {
                return;
            }
            GrMethodCall dependenciesCall = grMethodCall;
            if (!Intrinsics.areEqual((Object)dependenciesCall.getInvokedExpression().getText(), (Object)"dependencies")) {
                return;
            }
            List<GrCallExpression> dependencyEntries = GradleHeuristicHelper.INSTANCE.findStatementWithPrefixes(closure, GradleBuildScriptManipulatorUtils.getSCRIPT_PRODUCTION_DEPENDENCY_STATEMENTS());
            for (GrCallExpression dependencyStatement : dependencyEntries) {
                this.visitDependencyEntry(dependencyStatement);
            }
        }

        public void visitDependencyEntry(@NotNull GrCallExpression dependencyStatement) {
            Intrinsics.checkNotNullParameter((Object)dependencyStatement, (String)"dependencyStatement");
            for (DeprecatedLibInfo outdatedInfo : KotlinRuntimeLibraryUtilKt.getDEPRECATED_LIBRARIES_INFORMATION()) {
                String libVersion;
                Character afterMarkerChar;
                String dependencyText = dependencyStatement.getText();
                String libMarker = DeprecatedGradleDependencyInspectionKt.access$getGradleMarker(outdatedInfo.getOld());
                Intrinsics.checkNotNullExpressionValue((Object)dependencyText, (String)"dependencyText");
                if (!StringsKt.contains$default((CharSequence)dependencyText, (CharSequence)libMarker, (boolean)false, (int)2, null)) continue;
                Character c = afterMarkerChar = StringsKt.getOrNull((CharSequence)StringsKt.substringAfter$default((String)dependencyText, (String)libMarker, null, (int)2, null), (int)0);
                char c2 = '\'';
                if (c == null || c.charValue() != c2) {
                    Character c3 = afterMarkerChar;
                    c2 = '\"';
                    if (c3 == null || c3.charValue() != c2) {
                        Character c4 = afterMarkerChar;
                        c2 = ':';
                        if (c4 == null || c4.charValue() != c2) continue;
                    }
                }
                PsiFile psiFile2 = dependencyStatement.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"dependencyStatement.containingFile");
                String string2 = DifferentStdlibGradleVersionInspection.Companion.getRawResolvedLibVersion(psiFile2, outdatedInfo.getOld().getGroupId(), CollectionsKt.listOf((Object)outdatedInfo.getOld().getName()));
                if (string2 == null) {
                    PsiFile psiFile3 = dependencyStatement.getContainingFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"dependencyStatement.containingFile");
                    string2 = Companion.libraryVersionFromOrderEntry(psiFile3, outdatedInfo.getOld().getName());
                }
                if ((libVersion = string2) == null || VersionComparatorUtil.COMPARATOR.compare(libVersion, outdatedInfo.getOutdatedAfterVersion()) < 0) continue;
                PsiElement reportOnElement = this.reportOnElement(dependencyStatement, outdatedInfo);
                ReplaceStringInDocumentFix[] replaceStringInDocumentFixArray = new ReplaceStringInDocumentFix[]{new ReplaceStringInDocumentFix(reportOnElement, outdatedInfo.getOld().getName(), outdatedInfo.getNew().getName())};
                this.registerError(reportOnElement, outdatedInfo.getMessage(), replaceStringInDocumentFixArray, ProblemHighlightType.LIKE_DEPRECATED);
                break;
            }
        }

        private final PsiElement reportOnElement(GrCallExpression classpathEntry, DeprecatedLibInfo deprecatedInfo) {
            String string2 = classpathEntry.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classpathEntry.text");
            int indexOf = StringsKt.indexOf$default((CharSequence)string2, (String)deprecatedInfo.getOld().getName(), (int)0, (boolean)false, (int)6, null);
            if (indexOf < 0) {
                return (PsiElement)classpathEntry;
            }
            PsiElement psiElement2 = classpathEntry.findElementAt(indexOf);
            if (psiElement2 == null) {
                psiElement2 = (PsiElement)classpathEntry;
            }
            return psiElement2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/groovy/inspections/DeprecatedGradleDependencyInspection$ExternalLibraryInfo;", "", "artifactId", "", "version", "(Ljava/lang/String;Ljava/lang/String;)V", "getArtifactId", "()Ljava/lang/String;", "getVersion", "kotlin.gradle.code-insight-groovy"})
    private static final class ExternalLibraryInfo {
        @NotNull
        private final String artifactId;
        @NotNull
        private final String version;

        public ExternalLibraryInfo(@NotNull String artifactId2, @NotNull String version2) {
            Intrinsics.checkNotNullParameter((Object)artifactId2, (String)"artifactId");
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            this.artifactId = artifactId2;
            this.version = version2;
        }

        @NotNull
        public final String getArtifactId() {
            return this.artifactId;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }
    }
}

