/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration.kpm;

import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.idea.kpm.IdeaKpmContentRoot;
import org.jetbrains.kotlin.gradle.idea.kpm.IdeaKpmFragment;
import org.jetbrains.kotlin.gradle.idea.kpm.IdeaKpmFragmentCoordinates;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0007\u001a\n\u0010\u0018\u001a\u00020\u0017*\u00020\u0007\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\"\u001b\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0019"}, d2={"fullName", "", "Lorg/jetbrains/kotlin/gradle/idea/kpm/IdeaKpmFragmentCoordinates;", "getFullName", "(Lorg/jetbrains/kotlin/gradle/idea/kpm/IdeaKpmFragmentCoordinates;)Ljava/lang/String;", "isTestFragment", "", "Lorg/jetbrains/kotlin/gradle/idea/kpm/IdeaKpmFragment;", "(Lorg/jetbrains/kotlin/gradle/idea/kpm/IdeaKpmFragment;)Z", "resourceDirs", "", "Ljava/io/File;", "getResourceDirs", "(Lorg/jetbrains/kotlin/gradle/idea/kpm/IdeaKpmFragment;)Ljava/util/Collection;", "sourceDirs", "getSourceDirs", "calculateKotlinFragmentModuleId", "gradleModule", "Lorg/gradle/tooling/model/idea/IdeaModule;", "fragment", "resolverCtx", "Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;", "computeResourceType", "Lcom/intellij/openapi/externalSystem/model/project/ExternalSystemSourceType;", "computeSourceType", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nKotlinFragmentUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFragmentUtil.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/kpm/KotlinFragmentUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n766#2:41\n857#2,2:42\n1549#2:44\n1620#2,3:45\n766#2:48\n857#2,2:49\n1549#2:51\n1620#2,3:52\n*S KotlinDebug\n*F\n+ 1 KotlinFragmentUtil.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/kpm/KotlinFragmentUtilKt\n*L\n36#1:41\n36#1:42,2\n36#1:44\n36#1:45,3\n39#1:48\n39#1:49,2\n39#1:51\n39#1:52,3\n*E\n"})
public final class KotlinFragmentUtilKt {
    private static final String getFullName(IdeaKpmFragmentCoordinates $this$fullName) {
        return $this$fullName.getFragmentName() + CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)$this$fullName.getModule().getModuleName());
    }

    private static final boolean isTestFragment(IdeaKpmFragment $this$isTestFragment) {
        return Intrinsics.areEqual((Object)$this$isTestFragment.getCoordinates().getModule().getModuleName(), (Object)"test");
    }

    @NotNull
    public static final String calculateKotlinFragmentModuleId(@NotNull IdeaModule gradleModule, @NotNull IdeaKpmFragmentCoordinates fragment, @NotNull ProjectResolverContext resolverCtx) {
        Intrinsics.checkNotNullParameter((Object)gradleModule, (String)"gradleModule");
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)resolverCtx, (String)"resolverCtx");
        return GradleProjectResolverUtil.getModuleId((ProjectResolverContext)resolverCtx, (IdeaModule)gradleModule) + ":" + KotlinFragmentUtilKt.getFullName(fragment);
    }

    @NotNull
    public static final ExternalSystemSourceType computeSourceType(@NotNull IdeaKpmFragment $this$computeSourceType) {
        Intrinsics.checkNotNullParameter((Object)$this$computeSourceType, (String)"<this>");
        return KotlinFragmentUtilKt.isTestFragment($this$computeSourceType) ? ExternalSystemSourceType.TEST : ExternalSystemSourceType.SOURCE;
    }

    @NotNull
    public static final ExternalSystemSourceType computeResourceType(@NotNull IdeaKpmFragment $this$computeResourceType) {
        Intrinsics.checkNotNullParameter((Object)$this$computeResourceType, (String)"<this>");
        return KotlinFragmentUtilKt.isTestFragment($this$computeResourceType) ? ExternalSystemSourceType.TEST_RESOURCE : ExternalSystemSourceType.RESOURCE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<File> getSourceDirs(@NotNull IdeaKpmFragment $this$sourceDirs) {
        void $this$mapTo$iv$iv;
        IdeaKpmContentRoot it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$sourceDirs, (String)"<this>");
        Iterable $this$filter$iv = $this$sourceDirs.getContentRoots();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IdeaKpmContentRoot)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)"source")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IdeaKpmContentRoot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<File> getResourceDirs(@NotNull IdeaKpmFragment $this$resourceDirs) {
        void $this$mapTo$iv$iv;
        IdeaKpmContentRoot it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$resourceDirs, (String)"<this>");
        Iterable $this$filter$iv = $this$resourceDirs.getContentRoots();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IdeaKpmContentRoot)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)"resource")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IdeaKpmContentRoot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        return (List)destination$iv$iv;
    }
}

