/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;

public class ChooseModulePanel {
    private JPanel contentPane;
    private JRadioButton allModulesWithKtRadioButton;
    private JRadioButton singleModuleRadioButton;
    private JComboBox<String> singleModuleComboBox;
    private HyperlinkLabel allModulesWithKtNames;
    private JRadioButton allModulesRadioButton;
    @NotNull
    private final Project project;
    @NotNull
    private final List<Module> modules;
    @NotNull
    private final List<Module> modulesWithKtFiles;

    public ChooseModulePanel(@NotNull Project project2, @NotNull KotlinProjectConfigurator configurator, Collection<Module> excludeModules) {
        if (project2 == null) {
            ChooseModulePanel.$$$reportNull$$$0(0);
        }
        if (configurator == null) {
            ChooseModulePanel.$$$reportNull$$$0(1);
        }
        this.project = project2;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        Pair modulesPair = (Pair)ActionUtil.underModalProgress((Project)project2, (String)KotlinProjectConfigurationBundle.message("lookup.kotlin.modules.configurations.progress.text", objectArray), () -> {
            List<Module> modules2 = ConfigureKotlinInProjectUtilsKt.getCanBeConfiguredModules(project2, configurator);
            List<Module> modulesWithKtFiles = ConfigureKotlinInProjectUtilsKt.getCanBeConfiguredModulesWithKotlinFiles(project2, configurator);
            return Pair.create(modules2, modulesWithKtFiles);
        });
        this.modules = (List)modulesPair.first;
        this.modulesWithKtFiles = (List)modulesPair.second;
        DefaultComboBoxModel<String> comboBoxModel = new DefaultComboBoxModel<String>();
        for (Module module3 : this.modules) {
            comboBoxModel.addElement(module3.getName());
        }
        if (this.modulesWithKtFiles.isEmpty()) {
            this.allModulesWithKtRadioButton.setVisible(false);
            this.allModulesWithKtNames.setVisible(false);
        }
        this.singleModuleComboBox.setModel(comboBoxModel);
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseModulePanel.this.updateComponents();
            }
        };
        this.singleModuleRadioButton.addActionListener(listener2);
        this.allModulesWithKtRadioButton.addActionListener(listener2);
        this.allModulesRadioButton.addActionListener(listener2);
        if (this.modulesWithKtFiles.size() > 2) {
            String firstName = this.modulesWithKtFiles.get(0).getName();
            String secondName = this.modulesWithKtFiles.get(1).getName();
            String message2 = KotlinProjectConfigurationBundle.message("choose.module.modules", firstName, secondName, this.modulesWithKtFiles.size() - 2);
            this.allModulesWithKtNames.setHtmlText("<html>" + message2);
            this.allModulesWithKtNames.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    String title = KotlinProjectConfigurationBundle.message("choose.module.modules.with.kotlin", new Object[0]);
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<Module>(title, ChooseModulePanel.this.modulesWithKtFiles){

                        @NotNull
                        public String getTextFor(Module value2) {
                            String string2 = value2.getName();
                            if (string2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return string2;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/framework/ui/ChooseModulePanel$2$1", "getTextFor"));
                        }
                    }).showUnderneathOf((Component)ChooseModulePanel.this.allModulesWithKtNames);
                }
            });
        } else {
            this.allModulesWithKtNames.setText(StringUtil.join(this.modulesWithKtFiles, module2 -> module2.getName(), (String)", "));
        }
        ButtonGroup modulesGroup = new ButtonGroup();
        modulesGroup.add(this.allModulesRadioButton);
        modulesGroup.add(this.allModulesWithKtRadioButton);
        modulesGroup.add(this.singleModuleRadioButton);
        if (this.allModulesWithKtRadioButton.isVisible()) {
            this.allModulesWithKtRadioButton.setSelected(true);
        } else {
            this.allModulesRadioButton.setSelected(true);
        }
        this.updateComponents();
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    private void updateComponents() {
        this.singleModuleComboBox.setEnabled(this.singleModuleRadioButton.isSelected());
    }

    public List<Module> getModulesToConfigure() {
        if (this.allModulesRadioButton.isSelected()) {
            return this.modules;
        }
        if (this.allModulesWithKtRadioButton.isSelected()) {
            return this.modulesWithKtFiles;
        }
        String selectedItem = (String)this.singleModuleComboBox.getSelectedItem();
        if (selectedItem == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(ModuleManager.getInstance((Project)this.project).findModuleByName(selectedItem));
    }

    @NotNull
    public List<Module> getModules() {
        List<Module> list2 = this.modules;
        if (list2 == null) {
            ChooseModulePanel.$$$reportNull$$$0(2);
        }
        return list2;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        HyperlinkLabel hyperlinkLabel;
        JRadioButton jRadioButton3;
        JPanel jPanel2;
        this.contentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.singleModuleRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/KotlinProjectConfigurationBundle", ChooseModulePanel.class).getString("single.module"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.singleModuleComboBox = jComboBox;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel2.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        this.allModulesWithKtNames = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setEnabled(true);
        jPanel2.add((Component)hyperlinkLabel, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), new Dimension(-1, 100)));
        this.allModulesWithKtRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/KotlinProjectConfigurationBundle", ChooseModulePanel.class).getString("all.modules.containing.kotlin.files"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.allModulesRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/KotlinProjectConfigurationBundle", ChooseModulePanel.class).getString("all.modules"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string2.length(); ++j) {
            if (string2.charAt(j) == '&') {
                if (++j == string2.length()) break;
                if (!bl && string2.charAt(j) != '&') {
                    bl = true;
                    c = string2.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/framework/ui/ChooseModulePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/framework/ui/ChooseModulePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

